/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.render2.op;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderFactory;
import ru.softlogic.hardware.device.print.render2.RenderHelper;
import ru.softlogic.hardware.device.print.render2.op.OperationRender;
import ru.softlogic.hardware.utils.SumFormatter;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.system.util.PathUtils;

public class TemplateOperationRender
implements OperationRender {
    private final String template;
    private final Properties properties;
    private final Locale locale;

    public TemplateOperationRender(String home, String template, Locale locale) {
        this.template = template;
        this.locale = locale;
        this.properties = new Properties();
        this.properties.setProperty("file.resource.loader.path", home);
        this.properties.setProperty("runtime.log.logsystem.log4j.logger", "test");
        this.properties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.Log4JLogChute");
    }

    @Override
    public String[] process(Operation operation, RenderData data) {
        VelocityEngine ve = null;
        Template t = null;
        try {
            ve = new VelocityEngine(this.properties);
            t = ve.getTemplate(this.template, "utf-8");
            VelocityContext context = RenderHelper.createContext(operation.getDealer(), operation.getPoint(), operation.getPaymentSystem(), operation.getBank(), data);
            context.put("operation", (Object)operation);
            context.put("service", (Object)operation.getService());
            context.put("provider", (Object)operation.getService().getProvider());
            context.put("operator", (Object)operation.getService().getOperator());
            context.put("app_path", (Object)PathUtils.getAppHome());
            context.put("SumFormatter", SumFormatter.class);
            context.put("cashless", (Object)operation.getCashlessData());
            StringWriter sw = new StringWriter();
            t.merge((Context)context, (Writer)sw);
            return RenderHelper.processImage(sw.toString());
        }
        catch (Exception ex) {
            Logger.getLogger((String)"print").error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u043d\u043e\u0433\u043e \u0440\u0435\u043d\u0434\u0435\u0440\u0430", (Throwable)ex);
            Logger.getLogger((String)"print").info((Object)"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e \u0442\u0438\u043f\u043e\u0432\u043e\u0439 \u0440\u0435\u043d\u0434\u0435\u0440");
            OperationRender render = RenderFactory.createDefaultOperationRender(data.getDeviceType(), this.locale);
            if (render != null) {
                Logger.getLogger((String)"print").info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0431\u0440\u0430\u0437 \u0447\u0435\u043a\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u043c \u0440\u0435\u043d\u0434\u0435\u0440\u043e\u043c");
                return render.process(operation, data);
            }
            Logger.getLogger((String)"print").error((Object)"\u041e\u0431\u0440\u0430\u0437 \u0447\u0435\u043a\u0430 \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d");
            return new String[]{""};
        }
    }

    @Override
    public String[] processGroup(GroupOperation operation, RenderData data) {
        try {
            VelocityEngine ve = new VelocityEngine(this.properties);
            Template t = ve.getTemplate(this.template, "utf-8");
            VelocityContext context = RenderHelper.createContext(operation.getDealer(), operation.getPoint(), operation.getPaymentSystem(), operation.getBank(), data);
            context.put("operation", (Object)operation);
            context.put("service", (Object)operation.getService());
            context.put("provider", (Object)operation.getService().getProvider());
            context.put("operator", (Object)operation.getService().getOperator());
            context.put("app_path", (Object)PathUtils.getAppHome());
            context.put("SumFormatter", SumFormatter.class);
            StringWriter sw = new StringWriter();
            t.merge((Context)context, (Writer)sw);
            return sw.toString().replace("\r\n", "<br>").replace("\n", "<br>").split("<cut/>");
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException ex) {
            Logger.getLogger((String)"print").error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u043d\u043e\u0433\u043e \u0440\u0435\u043d\u0434\u0435\u0440\u0430", ex);
            Logger.getLogger((String)"print").info((Object)"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e \u0442\u0438\u043f\u043e\u0432\u043e\u0439 \u0440\u0435\u043d\u0434\u0435\u0440");
            OperationRender render = RenderFactory.createOperationRender(data.getDeviceType(), null, this.locale);
            if (render != null) {
                Logger.getLogger((String)"print").info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0431\u0440\u0430\u0437 \u0447\u0435\u043a\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u043c \u0440\u0435\u043d\u0434\u0435\u0440\u043e\u043c");
                return render.process((Operation)operation, data);
            }
            Logger.getLogger((String)"print").error((Object)"\u041e\u0431\u0440\u0430\u0437 \u0447\u0435\u043a\u0430 \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d");
            return new String[]{""};
        }
    }
}

