/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.render2.mc;

import i18n.B;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderHelper;
import ru.softlogic.hardware.device.print.render2.mc.MoneyCollectionRender;

public class DefaultMoneyCollectionRender
implements MoneyCollectionRender {
    private Logger log;
    private String path;

    public DefaultMoneyCollectionRender() {
        this("/i18n/docs/pos/");
    }

    public DefaultMoneyCollectionRender(String path) {
        this.path = path;
        this.log = Logger.getLogger((String)"print");
    }

    @Override
    public String[] process(MoneyCollection mc, RenderData data) {
        try {
            VelocityEngine engine = RenderHelper.getVelocityEngine();
            String templateImage = RenderHelper.getTemplateFromJar(this.path + "collection", Locale.getDefault());
            if (templateImage == null) {
                this.log.error((Object)B.log((String)"hdw.print.render.default.template.error"));
                return null;
            }
            StringResourceRepository repository = StringResourceLoader.getRepository();
            repository.putStringResource("default", templateImage);
            Template template = engine.getTemplate("default", "utf-8");
            int total = 0;
            for (CashUnit unit : mc.getKeeper().getCashUnits().keySet()) {
                total += ((Integer)mc.getKeeper().getCashUnits().get(unit)).intValue();
            }
            TreeSet<CashUnit> banknotes = new TreeSet<CashUnit>(Arrays.asList(CashFactory.getDefaultInstance().getCashUnits()));
            TreeSet<CashUnit> coins = new TreeSet<CashUnit>(Arrays.asList(CashFactory.getDefaultInstance().getCoinUnits()));
            VelocityContext context = RenderHelper.createContext(mc.getDealer(), mc.getPoint(), mc.getPaymentSystem(), mc.getBank(), data);
            context.put("mc", (Object)mc);
            context.put("banknotes", banknotes);
            context.put("coins", coins);
            context.put("total", (Object)total);
            if (mc.getDeviceClass() == DeviceClass.CashAcceptor) {
                context.put("units", banknotes);
            } else {
                context.put("units", coins);
            }
            StringWriter sw = new StringWriter();
            template.merge((Context)context, (Writer)sw);
            return sw.toString().replace("\r\n", "<br>").replace("\n", "<br>").split("<cut/>");
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException ex) {
            this.log.error((Object)ex, ex);
            return null;
        }
    }
}

