/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.queue.fiscal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.fs.client.ClientFactory;
import ru.softlogic.fs.client.ConnectorType;
import ru.softlogic.fs.client.FiscalClient;
import ru.softlogic.fs.client.model.Response;
import ru.softlogic.fs.client.model.dayreport.DayReportResponse;
import ru.softlogic.fs.client.model.dayreport.DayReportUnprintedResponse;
import ru.softlogic.fs.client.model.payment.FiscalData;
import ru.softlogic.fs.client.model.payment.PaymentRequest;
import ru.softlogic.fs.client.model.payment.PaymentResponse;
import ru.softlogic.fs.client.model.producers.AuthParamsProducer;
import ru.softlogic.fs.client.model.producers.PaylogicParamsProducer;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.Printer;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.adv.AdvExtractor;
import ru.softlogic.hardware.device.print.kkm.Kkm;
import ru.softlogic.hardware.device.print.kkm.KkmOperation;
import ru.softlogic.hardware.device.print.kkm.LastReportsReqest;
import ru.softlogic.hardware.device.print.kkm.ReportByDate;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.posprinter.PosPrinter;
import ru.softlogic.hardware.device.print.queue.PrinterInfoListener;
import ru.softlogic.hardware.device.print.queue.PrinterQueue;
import ru.softlogic.hardware.device.print.queue.ReportRequest;
import ru.softlogic.hardware.device.print.queue.ReportResultAdapter;
import ru.softlogic.hardware.device.print.queue.ReportResultListener;
import ru.softlogic.hardware.device.print.queue.fiscal.AuthParamsProducerImpl;
import ru.softlogic.hardware.device.print.queue.fiscal.PaylogicParamsProducerImpl;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.hardware.device.print.status.PrinterStatusObserver;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.adv.CheckAdv;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.service.Service;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.ThreadUtil;

public class FiscalPrinterQueue
implements PrinterQueue {
    private static int attemps = 3;
    private static final int ATTEMPS_TIMEOUT = 5000;
    private static final int UPDATE_TIMEOUT = 7000;
    private static final int FAKE_SEND_TIMEOUT = 300000;
    private static final int FAKE_SEND_ERROR_TIMEOUT = 60000;
    private static final int FAKE_TIMEOUT = 86400000;
    private static final Random RND = new Random();
    private static final SimpleDateFormat TG = new SimpleDateFormat("yyyyMMdd'T'HHmm");
    private static final DecimalFormat DF = new DecimalFormat();
    private static int fullNumRnd;
    private String dataPath;
    private PosPrinter printer;
    private Set<PrinterStatusObserver> observers;
    private FiscalClient client;
    private ConcurrentLinkedQueue<Object> queue;
    private Logger log;
    private Set<PrinterInfoListener> listeners;
    private final Object sync;
    private short lastCheck;
    private long lastPrinterStatus;
    private Short srvStatus;
    private long lastServerStatus;
    private long lastServerRequest;
    private long lastPayment;
    private long lastFakeError;
    private FiscalData lastFiscalData;
    private boolean blockOnError;
    private File paymentsFile;
    private LinkedList<PaymentRequest> fakePayments;
    private DeviceType deviceType;
    private boolean fqueueOnError;
    private PrinterStatus lastStatus;

    public FiscalPrinterQueue(String dataPath) {
        if (dataPath == null) {
            throw new NullPointerException("DataPath");
        }
        this.dataPath = dataPath;
        this.observers = new HashSet<PrinterStatusObserver>();
        this.queue = new ConcurrentLinkedQueue();
        this.listeners = new HashSet<PrinterInfoListener>();
        this.sync = new Object();
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.readDocument();
        this.blockOnError = true;
        if (SystemProp.getTerminalDir() == null) {
            this.log.error((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e terminal.dir");
        } else {
            try {
                this.paymentsFile = FileUtil.checkFile((String)(SystemProp.getTerminalDir() + File.separator + "data" + File.separator + "fiscal_queue.obj"));
            }
            catch (Exception ex) {
                this.log.error((Object)ex, (Throwable)ex);
                this.paymentsFile = null;
            }
        }
        DF.setMaximumFractionDigits(2);
        DF.setMinimumFractionDigits(2);
        DecimalFormatSymbols dfs = DF.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DF.setDecimalFormatSymbols(dfs);
        DF.setGroupingUsed(false);
        this.readData();
    }

    @Override
    public void setPrinter(Printer printer) {
        if (printer == null) {
            throw new NullPointerException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 printer");
        }
        if (printer.getType() != PrinterType.PosPrinter) {
            throw new IllegalArgumentException("\u041e\u0447\u0435\u0440\u0435\u0434\u044c \u043f\u0435\u0447\u0430\u0442\u0438 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u0435\u0442 \u0442\u043e\u043b\u044c\u043a\u043e pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440\u044b");
        }
        this.printer = (PosPrinter)printer;
        this.deviceType = DeviceType.valueOf(printer.getInfo().getDeviceType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        this.log.info((Object)"Handler: FiscalPrinterQueue");
        if (this.printer == null) {
            this.notifyPrinterStatus(DeviceClass.FiscalPrinter, new PrinterStatus(false, true, false, false));
            this.log.info((Object)"Stop thread");
            return;
        }
        int errCount = 0;
        while (!Thread.currentThread().isInterrupted()) {
            this.getServerStatus();
            this.updateDealerInfo();
            Object object = this.sync;
            synchronized (object) {
                Object obj = null;
                try {
                    block26: {
                        try {
                            obj = this.queue.poll();
                            if (!this.printer.isOpen()) {
                                this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u043e\u0440\u0442");
                                this.printer.open();
                                this.log.info((Object)"\u041f\u043e\u0440\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u0442. \u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u044e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
                                this.printer.init();
                                this.log.info((Object)"\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043e. \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e info");
                                DeviceInfo info = this.printer.getInfo();
                                info.setDeviceClass(DeviceClass.FiscalPrinter.getCode());
                                info.setProto("FS");
                                for (PrinterInfoListener pil : this.listeners) {
                                    pil.onInfo(this.printer.getInfo());
                                }
                                this.log.info((Object)"\u0423\u0441\u043f\u0435\u0445");
                            }
                            if (obj != null) {
                                this.lastPayment = System.currentTimeMillis();
                                this.log.info((Object)"\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                                if (!this.fqueueOnError && this.lastStatus != null && !this.lastStatus.isWork() && obj instanceof Operation) {
                                    this.log.info((Object)"\u041f\u0440\u0438\u043d\u0442\u0435\u0440 \u0432 \u043e\u0448\u0438\u0431\u043a\u0435, \u043d\u0435 \u043f\u043e\u0441\u044b\u043b\u0430\u0435\u043c \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c");
                                } else {
                                    this.printObject(obj);
                                    this.sync.wait(4000L);
                                    this.lastCheck = this.printer.nextCheckNumber();
                                    this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u043d\u043e\u043c\u0435\u0440 \u0447\u0435\u043a\u0430: " + this.lastCheck));
                                }
                                this.sync.wait(2000L);
                            } else {
                                if (this.lastPrinterStatus == 0L || System.currentTimeMillis() - this.lastPrinterStatus > 7000L) {
                                    this.lastCheck = this.printer.nextCheckNumber();
                                    this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u043d\u043e\u043c\u0435\u0440 \u0447\u0435\u043a\u0430: " + this.lastCheck));
                                    this.lastPrinterStatus = System.currentTimeMillis();
                                    PrinterStatus ps = null;
                                    for (int i = 0; i < 4 && !(ps = this.printer.getStatus()).isWork() && this.lastStatus != null && this.lastStatus.isWork(); ++i) {
                                        if (i == 3) continue;
                                        this.sync.wait(1500L);
                                    }
                                    if (!this.isServerOk() && this.blockOnError && !ps.isError()) {
                                        this.log.info((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u0432 \u043e\u0448\u0438\u0431\u043a\u0435, \u043f\u043e\u043c\u0435\u0447\u0430\u044e \u043f\u0440\u0438\u043d\u0442\u0435\u0440 \u0432 \u043e\u0448\u0438\u0431\u043a\u0443");
                                        ps.setError(true);
                                    }
                                    if (!ps.equals(this.lastStatus)) {
                                        this.log.debug((Object)("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: " + ps));
                                        this.lastStatus = ps;
                                    }
                                    this.notifyPrinterStatus(DeviceClass.FiscalPrinter, ps);
                                    errCount = 0;
                                }
                                if (System.currentTimeMillis() - this.lastPayment > 300000L) {
                                    LinkedList<PaymentRequest> toRemove = new LinkedList<PaymentRequest>();
                                    for (PaymentRequest pr : this.fakePayments) {
                                        if (pr.getPointTime() != null && System.currentTimeMillis() - pr.getPointTime().getTime() <= 86400000L) continue;
                                        this.log.info((Object)("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 \u043f\u0435\u0440\u0435\u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u0423\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438. " + pr));
                                        toRemove.add(pr);
                                        this.notifyEvent("FS: " + pr.getAccount() + "-> Timeout resend payment. Remove from queue.");
                                    }
                                    if (!toRemove.isEmpty()) {
                                        this.fakePayments.removeAll(toRemove);
                                        this.updateData();
                                    }
                                    if (!this.fakePayments.isEmpty() && System.currentTimeMillis() - this.lastFakeError > 60000L) {
                                        PaymentRequest paymentRequest = this.fakePayments.get(0);
                                        try {
                                            this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u043f\u043b\u0430\u0442\u0435\u0436 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + paymentRequest));
                                            PaymentResponse doc = this.client.pcPay(paymentRequest);
                                            this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442: " + doc));
                                            this.log.info((Object)("\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d. \u0423\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + doc));
                                            this.fakePayments.remove(paymentRequest);
                                            this.updateData();
                                        }
                                        catch (Exception ex) {
                                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430: ", (Throwable)ex);
                                            this.lastFakeError = System.currentTimeMillis();
                                        }
                                    }
                                }
                            }
                            this.sync.wait(50L);
                        }
                        catch (IOException ex) {
                            this.sync.wait(3000L);
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 \u043f\u043e\u0440\u0442\u043e\u043c", (Throwable)ex);
                            this.printer.close();
                            if (errCount == 3) {
                                this.log.error((Object)"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u043e\u0448\u0438\u0431\u043e\u043a, \u043e\u0442\u0441\u044b\u043b\u0430\u044e \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0430 c\u0435\u0440\u0432\u0435\u0440");
                                PrinterStatus ps = new PrinterStatus();
                                ps.setOnline(false);
                                this.notifyPrinterStatus(DeviceClass.FiscalPrinter, ps);
                            }
                            if (errCount >= 10) break block26;
                            ++errCount;
                        }
                    }
                    this.sync.wait(300L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.printer.close();
        this.log.info((Object)"Stop thread");
    }

    @Override
    public void print(Operation operation) {
        if (operation != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 " + operation));
            this.queue.add(operation);
        }
    }

    @Override
    public void printGroup(GroupOperation operation) {
        if (operation != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 " + operation));
            this.queue.add(operation);
        }
    }

    @Override
    public void print(MoneyCollection moneyCollection) {
        if (moneyCollection != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043d\u043e\u0432\u0430\u044f \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f " + moneyCollection));
            this.queue.add(moneyCollection);
        }
    }

    @Override
    public void printCustomDocument(CustomData customData) {
        if (customData != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 " + customData));
            this.queue.add(customData);
        }
    }

    @Override
    public void report(ReportRequest request) {
        if (request == null || request.getKkmOperation() == null) {
            throw new NullPointerException();
        }
        this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u0435\u0447\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u0430: " + request));
        this.queue.add(request);
    }

    @Override
    public void printLastZreports(LastReportsReqest request) {
        this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u0435\u0447\u0430\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445 Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432: " + request));
        this.log.info((Object)"\u0414\u043b\u044f \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u0432\u0438\u0434 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }

    @Override
    public ReportResult reportAndWait(ReportRequest request) throws Exception {
        this.log.info((Object)("reportAndWait: " + request));
        if (request.getKkmOperation() == KkmOperation.FormReportZMem) {
            try {
                DayReportUnprintedResponse drur = this.client.getUnprintedDayReports();
                if (drur == null) {
                    return new ReportResult(-100, true, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                }
                if (drur.getCode() != 0) {
                    this.log.info((Object)drur.getMessage());
                    return new ReportResult(drur.getCode(), true, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                }
                this.log.info((Object)drur.getMessage());
                this.log.info((Object)("\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u0442\u0447\u0435\u0442\u043e\u0432: " + drur.getData()));
                for (Integer num : (List)drur.getData()) {
                    this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0430\u044e \u043e\u0442\u0447\u0435\u0442 \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443: " + num));
                    DayReportResponse drr = this.client.getDayReportData(num.intValue());
                    if (drr == null) {
                        return new ReportResult(-100, true, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                    }
                    if (drr.getCode() != 0) {
                        this.log.info((Object)drur.getMessage());
                        return new ReportResult(drr.getCode(), true, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                    }
                    this.log.info((Object)drur.getMessage());
                    this.log.info((Object)("\u041e\u0431\u0440\u0430\u0437 \u043e\u0442\u0447\u0435\u0442\u0430: " + drr.getCode() + ", " + (String)drr.getData()));
                    byte[] data = Base64.decodeBase64((String)((String)drr.getData()));
                    this.log.info((Object)("\u0420\u0430\u0437\u043c\u0435\u0440 \u043e\u0442\u0447\u0435\u0442\u0430 \u0432 \u0431\u0430\u0439\u0442\u0430\u0445=" + data.length));
                    byte[] pie = new byte[200];
                    int i = 0;
                    for (i = 0; i < data.length / 200; ++i) {
                        this.log.info((Object)("Load pie " + i));
                        System.arraycopy(data, i * 200, pie, 0, 200);
                        this.printer.getPort().write(pie);
                        Thread.sleep(100L);
                    }
                    if (data.length % 200 != 0) {
                        this.log.info((Object)"Load last pie ");
                        pie = new byte[data.length % 200];
                        System.arraycopy(data, i * 200, pie, 0, pie.length);
                        this.printer.getPort().write(pie);
                        Thread.sleep(100L);
                    }
                    this.log.info((Object)"Cut paper");
                    PosPrinter pp = this.printer;
                    pp.getApi().getEquipmentApi().fullCut();
                    this.log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441");
                    Response r = this.client.setDayReportPrinted(num.intValue());
                    this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + r));
                    if (r == null) {
                        return new ReportResult(-100, true, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                    }
                    if (r.getCode() != 0) {
                        this.log.info((Object)r.getMessage());
                        return new ReportResult(r.getCode(), true, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                    }
                    this.log.info((Object)"Sleep 5 seconds");
                    Thread.sleep(5000L);
                }
                return new ReportResult(0, false, "\u0423\u0441\u043f\u0435\u0445");
            }
            catch (IOException ex) {
                this.log.error((Object)ex, (Throwable)ex);
                return new ReportResult(-100, true, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0435\u0442\u0435\u0432\u043e\u043c \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0438");
            }
        }
        this.log.info((Object)"\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0441\u043d\u044f\u0442\u0438\u044f \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
        return new ReportResult(-100, true, "\u0414\u043b\u044f \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u0432\u0438\u0434 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }

    @Override
    public void report(ReportByDate rbd) {
        this.log.info((Object)("report: " + rbd));
    }

    @Override
    public ReportResult reportAndWait(ReportByDate request) throws Exception {
        this.log.info((Object)("reportAndWait: " + request));
        this.log.info((Object)"\u0414\u043b\u044f \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u0432\u0438\u0434 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        return new ReportResult(-1, true, "\u0414\u043b\u044f \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u0432\u0438\u0434 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }

    @Override
    public short getCheckNumber() {
        return this.printer.nextCheckNumber();
    }

    @Override
    public PrinterType getPrinterType() {
        return PrinterType.KkmOnline;
    }

    @Override
    public void addInfoListener(PrinterInfoListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void addObserver(PrinterStatusObserver observer) {
        if (observer != null) {
            this.observers.add(observer);
        }
    }

    protected void notifyPrinterStatus(DeviceClass deviceClass, PrinterStatus status) {
        for (PrinterStatusObserver observer : this.observers) {
            observer.update(deviceClass, status);
        }
    }

    private void printObject(Object obj) throws IOException {
        this.log.info((Object)"\u0418\u0437\u0432\u043b\u0435\u043a\u043b\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0447\u0435\u043a \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438. \u041e\u0442\u043f\u0440\u0430\u0432\u0438\u043b\u0438 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0443");
        if (obj instanceof GroupOperation) {
            GroupOperation op = (GroupOperation)obj;
            this.printer.printGroup(op, this.getRenderData((Operation)op));
        } else if (obj instanceof Operation) {
            Operation op = (Operation)obj;
            this.printer.print(op, this.getRenderData(op));
        } else if (obj instanceof CustomData) {
            CustomData customData = (CustomData)obj;
            this.printer.print(customData, this.getRenderData(customData));
        } else if (obj instanceof MoneyCollection) {
            MoneyCollection mc = (MoneyCollection)obj;
            this.printer.print(mc, this.getInkassRenderData(mc));
        } else if (obj instanceof ReportRequest) {
            ReportRequest request = (ReportRequest)obj;
            ReportResultListener rrl = request.getListener() != null ? request.getListener() : new ReportResultAdapter();
            this.reportRequest(request, rrl);
        } else if (obj instanceof ReportByDate) {
            ReportByDate rbd = (ReportByDate)obj;
            ReportResultListener rrl = rbd.getListener() != null ? rbd.getListener() : new ReportResultAdapter();
            this.reportRequest(rbd, rrl);
        } else {
            this.log.error((Object)"\u041d\u0435\u0438\u0437\u0432\u0435\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0434\u043b\u044f \u043f\u0435\u0447\u0430\u0442\u0438");
        }
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u044c \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
    }

    private RenderData getRenderData(Operation op) {
        RenderData rd = this.getRenderData(op.getService(), op);
        if (this.isNeedToSend(op)) {
            HashMap<String, Object> add = new HashMap<String, Object>();
            FiscalData fd = this.getDocumentFromServer(op);
            if (fd == null) {
                fd = this.getFakeDocument(op.getSumResult().getIncome().getSum());
                this.updateDocument(fd);
                add.put("fakeFD", true);
            }
            add.put("fiscalData", fd);
            rd.setAdditional(add);
        }
        return rd;
    }

    private RenderData getRenderData(Service service, Operation operation) {
        RenderData data = new RenderData();
        data.setAdvertisement(this.getAdvContent(service.getId(), operation.getLocale()));
        String attr = null;
        try {
            ReferenceManager rm = ReferenceManager.getInstance();
            operation.setBank(rm.getBank());
            operation.setPaymentSystem(rm.getPaymentSystem());
            if (operation.getDealer() == null) {
                operation.setDealer(rm.getDealer());
            }
            if (operation.getPoint() == null) {
                operation.setPoint(rm.getPoint());
            }
            if (service.getCheckRender() != null && !service.getCheckRender().isEmpty()) {
                data.setRenderName(service.getCheckRender());
            } else {
                data.setRenderName(rm.getPointOptions().getCheckRender());
            }
            if (rm.getPointOptions() != null) {
                data.setUseFiscalDepartments(rm.getPointOptions().isUseFiscalDepartments());
            }
            this.log.info((Object)("\u0411\u0438\u0442\u044c \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044e \u043f\u043e \u0440\u0430\u0437\u043d\u044b\u043c \u043e\u0442\u0434\u0435\u043b\u0430\u043c: " + rm.getPointOptions().isUseFiscalDepartments()));
            attr = (String)rm.getDealer().getProperties().get("fserver.g2.send.attemps");
            if (attr != null && !attr.isEmpty()) {
                attemps = Integer.parseInt(attr);
            }
            attemps = attemps > 0 ? attemps : 1;
        }
        catch (NumberFormatException ex) {
            this.log.warn((Object)("Error on parse attemps: " + ex.getMessage() + ", value=" + attr));
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        if (operation.isCopy()) {
            data.setDeviceClass(this.deviceType.getDeviceClass());
        } else {
            data.setDeviceClass(DeviceClass.RemotePrinter);
        }
        data.setDeviceType(this.deviceType);
        data.setPrinterType(this.getPrinterType());
        data.setFiscalMode(true);
        return data;
    }

    private String getAdvContent(int idService, Locale locale) {
        CheckAdv adv = AdvExtractor.extractCheckAdv(idService);
        this.log.info((Object)("\u0418\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u043e \u0440\u0435\u043a\u043b\u0430\u043c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: " + adv));
        if (adv != null) {
            String advMessage = locale == null ? null : (String)adv.getLangs().get(locale.getLanguage());
            return advMessage != null ? advMessage : adv.getContent();
        }
        return null;
    }

    private RenderData getInkassRenderData(MoneyCollection mc) {
        RenderData data = new RenderData();
        try {
            ReferenceManager rm = ReferenceManager.getInstance();
            mc.setBank(rm.getBank());
            mc.setPaymentSystem(rm.getPaymentSystem());
            mc.setDealer(rm.getDealer());
            mc.setPoint(rm.getPoint());
            data.setRenderName(rm.getPointOptions().getInkassRender());
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        data.setDeviceClass(this.deviceType.getDeviceClass());
        data.setDeviceType(this.deviceType);
        data.setFiscalMode(this.printer instanceof Kkm);
        return data;
    }

    private void reportRequest(ReportRequest request, ReportResultListener rrl) {
        if (this.printer.getType() == PrinterType.Kkm || this.printer.getType() == PrinterType.KkmOnline) {
            try {
                Kkm kkm = (Kkm)((Object)this.printer);
                ReportResult rr = null;
                switch (request.getKkmOperation()) {
                    case FormReportX: {
                        rr = kkm.formReportX();
                        break;
                    }
                    case FormReportZ: {
                        rr = kkm.formReportZ();
                        break;
                    }
                    case FormReportZMem: {
                        rr = kkm.formReportZMem();
                        break;
                    }
                    case CloseReportZToMem: {
                        rr = kkm.closeReportZToMem();
                        break;
                    }
                }
                this.log.info((Object)("result=" + rr));
                rrl.onResult(rr);
            }
            catch (IOException ex) {
                rrl.onFailure(ex);
            }
        } else {
            rrl.onUnsupport();
        }
    }

    private RenderData getRenderData(CustomData customData) {
        RenderData data = new RenderData();
        if (customData.getService() != null) {
            data.setAdvertisement(this.getAdvContent(customData.getService().getId(), null));
        }
        try {
            ReferenceManager rm = ReferenceManager.getInstance();
            customData.setBank(rm.getBank());
            customData.setPaymentSystem(rm.getPaymentSystem());
            customData.setDealer(rm.getDealer());
            customData.setPoint(rm.getPoint());
            if (customData.getTemplate() != null) {
                data.setRenderName(customData.getTemplate());
            } else {
                data.setRenderName(customData.getService().getCheckRender());
            }
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        data.setDeviceClass(this.deviceType.getDeviceClass());
        data.setDeviceType(this.deviceType);
        data.setFiscalMode(this.printer instanceof Kkm);
        return data;
    }

    private void reportRequest(ReportByDate rbd, ReportResultListener rrl) {
        if (this.printer instanceof Kkm) {
            try {
                Kkm kkm = (Kkm)((Object)this.printer);
                rrl.onResult(kkm.formReportDateRange(rbd.getBegin(), rbd.getEnd(), !rbd.isDetailed(), null));
            }
            catch (IOException ex) {
                rrl.onFailure(ex);
            }
        } else {
            rrl.onUnsupport();
        }
    }

    private void getServerStatus() {
        if (this.client == null) {
            return;
        }
        if ((this.srvStatus == null || System.currentTimeMillis() - this.lastServerStatus > 600000L) && System.currentTimeMillis() - this.lastServerRequest > 120000L) {
            for (int i = 0; i < 5; ++i) {
                this.log.info((Object)"\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c \u0441\u0442\u0430\u0442\u0443\u0441 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                try {
                    Response devicesAvailable = this.client.devicesAvailable();
                    this.srvStatus = devicesAvailable.getCode();
                    this.log.info((Object)("\u0421\u0442\u0430\u0442\u0443\u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + this.srvStatus));
                    this.lastServerStatus = this.lastServerRequest = System.currentTimeMillis();
                    return;
                }
                catch (Exception ex) {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043c\u0435\u043d\u0435", (Throwable)ex);
                    continue;
                }
            }
            this.lastServerRequest = System.currentTimeMillis();
        }
    }

    private boolean isServerOk() {
        if (this.client == null) {
            return false;
        }
        return this.srvStatus == null || this.srvStatus == 0 && System.currentTimeMillis() - this.lastServerStatus < 660000L;
    }

    private FiscalData getDocumentFromServer(Operation operation) {
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e \u043d\u0430 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0435\u0440: " + operation));
        PaymentRequest pr = null;
        pr = operation.getSumResult().getCashLess() != null && !operation.getSumResult().getCashLess().isEmpty() ? new PaymentRequest(operation.getCheckNumber(), operation.getService().getId(), operation.getService().getName(), (String)operation.getService().getProperties().get("fserver.g2.group.service"), (String)operation.getForm().get("id1"), operation.getSumResult().getCash().getBasicSum(), operation.getSumResult().getCash().getBasicSum(), 0, 0, operation.getDate()) : new PaymentRequest(operation.getCheckNumber(), operation.getService().getId(), operation.getService().getName(), (String)operation.getService().getProperties().get("fserver.g2.group.service"), (String)operation.getForm().get("id1"), operation.getSumResult().getIncome().getBasicSum(), operation.getSumResult().getOut().getBasicSum(), operation.getSumResult().getIncome().sub(operation.getSumResult().getOut()).sub(operation.getSumResult().getChange()).getBasicSum(), operation.getSumResult().getChange().getBasicSum(), operation.getDate());
        long start = System.currentTimeMillis();
        PaymentResponse doc = null;
        for (int i = 0; i < attemps; ++i) {
            try {
                doc = this.client.pcPay(pr);
                this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442: " + doc));
                if (doc.getCode() != 0) break;
                try {
                    this.updateDocument((FiscalData)doc.getData());
                }
                catch (Exception ex) {
                    this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438", (Throwable)ex);
                }
                return (FiscalData)doc.getData();
            }
            catch (Exception ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430: ", (Throwable)ex);
                if (i == attemps - 1) {
                    this.notifyEvent("FS: " + (String)operation.getForm().get("id1") + "-> ex:" + ex.getMessage() + ", timeout:" + (System.currentTimeMillis() - start));
                    if (!SystemProp.isFiscalResend()) {
                        this.log.info((Object)"\u0414\u043e\u0441\u044b\u043b\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0430");
                    } else {
                        this.fakePayments.add(pr);
                        this.updateData();
                    }
                }
                ThreadUtil.sleep((long)5000L);
                continue;
            }
        }
        return null;
    }

    private FiscalData getFakeDocument(double sumIn) {
        FiscalData doc;
        int dayNum = this.getDayNum();
        int docNum = this.lastFiscalData.getDocNum() + 1;
        fullNumRnd = this.extractFullNumRnd(this.lastFiscalData.getDocNumFull(), dayNum, docNum);
        int fullDocNum = 1000 * dayNum + docNum + fullNumRnd;
        Date time = new Date();
        String docHash = this.getDocHash();
        this.lastFiscalData = doc = new FiscalData(this.lastFiscalData.getDeviceType(), this.lastFiscalData.getDeviceFactoryNumber(), this.lastFiscalData.getDeviceRegNumber(), this.lastFiscalData.getDeviceFsNum(), this.lastFiscalData.getTaxNum(), this.lastFiscalData.getSite(), time, this.lastFiscalData.getDocNum() + 1, this.lastFiscalData.getDocShift(), docHash, this.getBarcode(time, sumIn, this.lastFiscalData.getDeviceFsNum(), fullDocNum, docHash), fullDocNum);
        this.log.info((Object)("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442: " + doc));
        return doc;
    }

    private int getDayNum() {
        GregorianCalendar cal = new GregorianCalendar();
        return cal.get(6);
    }

    private String getDocHash() {
        return String.format("%10d", RND.nextInt(Integer.MAX_VALUE));
    }

    private int extractFullNumRnd(int fullDocNum, int dayNum, int docNum) {
        return fullDocNum - (100 * dayNum + docNum);
    }

    private String getBarcode(Date time, double sumIn, String fsNum, int fullDocNum, String docHash) {
        return "t=" + TG.format(time) + "&s=" + DF.format(sumIn) + "&fn=" + fsNum + "&i=" + fullDocNum + "&fp=" + docHash + "&n=1";
    }

    private void notifyEvent(String comment) {
        for (PrinterStatusObserver pso : this.observers) {
            pso.errorEvent(comment);
        }
    }

    private void updateDealerInfo() {
        if (this.client == null) {
            try {
                Dealer dealer = ReferenceManager.getInstance().getDealer();
                this.client = ClientFactory.getFiscalClient((ConnectorType)ConnectorType.PRODUCTION, (AuthParamsProducer)new AuthParamsProducerImpl(), (PaylogicParamsProducer)new PaylogicParamsProducerImpl());
                if (dealer != null) {
                    this.log.info((Object)dealer.getProperties());
                    this.fqueueOnError = "true".equalsIgnoreCase((String)dealer.getProperties().get("fserver.fqueue-on-error"));
                    String boe = (String)dealer.getProperties().get("fserver.block-on-error");
                    if (boe != null && "false".equals(boe)) {
                        this.blockOnError = false;
                    }
                    String timeout = (String)dealer.getProperties().get("fserver.timeout");
                    this.log.info((Object)("Timeout: " + timeout));
                    this.log.info((Object)("Block on error: " + this.blockOnError));
                    this.log.info((Object)"\u041a\u043b\u0438\u0435\u043d\u0442 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d");
                }
            }
            catch (IOException ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
            catch (ReferenceException referenceException) {
                // empty catch block
            }
        }
    }

    private void updateDocument(FiscalData doc) {
        try (FileOutputStream fos = new FileOutputStream(this.dataPath + "/fs.obj");
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(doc);
        }
        catch (Exception ex) {
            this.log.error((Object)("Can't write " + doc), (Throwable)ex);
        }
    }

    private void readDocument() {
        try (FileInputStream fis = new FileInputStream(this.dataPath + "/fs.obj");
             ObjectInputStream ois = new ObjectInputStream(fis);){
            this.lastFiscalData = (FiscalData)ois.readObject();
            this.log.info((Object)("Read data: " + this.lastFiscalData));
        }
        catch (Exception ex) {
            this.log.error((Object)"Error on read document", (Throwable)ex);
            fullNumRnd = RND.nextInt(Integer.MAX_VALUE);
            int fullDocNum = 1000 * this.getDayNum() + 1 + fullNumRnd;
            this.lastFiscalData = new FiscalData("", "", "", "", "", "", new Date(), 1, 1, "", "", fullDocNum);
        }
    }

    private void readData() {
        this.log.info((Object)"*************** \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0447\u0442\u0435\u043d\u0438\u0435 \u043d\u0435\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 ***************");
        if (this.paymentsFile != null) {
            try (FileInputStream fis = new FileInputStream(this.paymentsFile);
                 ObjectInputStream ois = new ObjectInputStream(fis);){
                Object obj = ois.readObject();
                if (obj instanceof LinkedList) {
                    this.fakePayments = (LinkedList)obj;
                }
            }
            catch (Exception ex) {
                this.log.info((Object)ex.getMessage());
            }
        }
        if (this.fakePayments == null) {
            this.fakePayments = new LinkedList();
        }
        this.log.info((Object)"********************* \u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b \u0447\u0442\u0435\u043d\u0438\u0435 *********************");
    }

    private void updateData() {
        if (this.paymentsFile != null) {
            try (FileOutputStream fos = new FileOutputStream(this.paymentsFile);
                 ObjectOutputStream oos = new ObjectOutputStream(fos);){
                oos.writeObject(this.fakePayments);
            }
            catch (Exception ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
        }
    }

    @Override
    public int getFiscalServerStatus() throws Exception {
        if (this.client == null) {
            throw new IOException();
        }
        return this.client.devicesAvailable().getCode();
    }

    private boolean isNeedToSend(Operation op) {
        if (op.isCopy()) {
            this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u044c \u043a\u043e\u043f\u0438\u0438 \u0447\u0435\u043a\u0430. \u041d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u043d\u0430 \u0424\u0421");
            return false;
        }
        if (op.getSumResult().getCash() == null || op.getSumResult().getCash().isEmpty()) {
            this.log.info((Object)"\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442. \u041d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u043d\u0430 \u0424\u0421.");
            return false;
        }
        if (op.getService() != null && Boolean.TRUE.equals(op.getService().isNotFiscal())) {
            this.log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043d\u0430 \u0424\u0421 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0432 \u043a\u0430\u0431\u0438\u043d\u0435\u0442\u0435. \u041d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u043d\u0430 \u0424\u0421.");
            return false;
        }
        return true;
    }

    @Override
    public PrinterStatus getLastStatus() {
        return this.lastStatus;
    }

    @Override
    public ReportResult reportAndWait(LastReportsReqest request) throws Exception {
        return new ReportResult(-100, true, "\u0414\u043b\u044f \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u0432\u0438\u0434 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }
}

