/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.queue;

import java.io.IOException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.Printer;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.adv.AdvExtractor;
import ru.softlogic.hardware.device.print.kkm.Kkm;
import ru.softlogic.hardware.device.print.kkm.KkmOnline;
import ru.softlogic.hardware.device.print.kkm.KkmOperation;
import ru.softlogic.hardware.device.print.kkm.LastReportsReqest;
import ru.softlogic.hardware.device.print.kkm.ReportByDate;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.queue.PrinterInfoListener;
import ru.softlogic.hardware.device.print.queue.PrinterQueue;
import ru.softlogic.hardware.device.print.queue.ReportRequest;
import ru.softlogic.hardware.device.print.queue.ReportResultAdapter;
import ru.softlogic.hardware.device.print.queue.ReportResultListener;
import ru.softlogic.hardware.device.print.queue.ReportResultStub;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.hardware.device.print.status.PrinterStatusObserver;
import ru.softlogic.hardware.utils.CommonUtils;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.adv.CheckAdv;
import ru.softlogic.reference.service.Service;
import ru.softlogic.system.util.ThreadUtil;

public class BasePrinterQueue
implements PrinterQueue {
    private static final int UPDATE_TIMEOUT = 7000;
    private static final int TIME_CORRECT_TIMEOUT = 6600000;
    private final ConcurrentLinkedQueue<Object> queue = new ConcurrentLinkedQueue();
    private final Object sync;
    private final Set<PrinterStatusObserver> observers;
    private final Set<PrinterInfoListener> listeners;
    private Printer printer;
    private long last;
    private long lastTimeCorrection;
    private volatile boolean lockOnTimeCorrection;
    private final Logger log = Logger.getLogger((String)"print");
    private final Level logLevel = this.log.getLevel();
    private short lastCheck;
    private DeviceType deviceType;
    private PrinterStatus lastStatus = null;

    public BasePrinterQueue() {
        this.listeners = new HashSet<PrinterInfoListener>();
        this.sync = new Object();
        this.observers = new HashSet<PrinterStatusObserver>();
    }

    @Override
    public void setPrinter(Printer printer) {
        this.printer = printer;
        this.deviceType = DeviceType.valueOf(printer.getInfo().getDeviceType());
    }

    @Override
    public PrinterType getPrinterType() {
        return this.printer.getType();
    }

    @Override
    public void addInfoListener(PrinterInfoListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void print(Operation operation) {
        if (operation != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 " + operation));
            if (!this.lockOnTimeCorrection) {
                this.queue.add(operation);
            } else {
                this.log.info((Object)"\u041a\u041a\u041c \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u043d\u0430 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u043a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438");
            }
        }
    }

    @Override
    public void printGroup(GroupOperation operation) {
        if (operation != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 " + operation));
            if (!this.lockOnTimeCorrection) {
                this.queue.add(operation);
            } else {
                this.log.info((Object)"\u041a\u041a\u041c \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u043d\u0430 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u043a\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438");
            }
        }
    }

    @Override
    public void printCustomDocument(CustomData customData) {
        if (customData != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 " + customData));
            this.queue.add(customData);
        }
    }

    @Override
    public void print(MoneyCollection moneyCollection) {
        if (moneyCollection != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043d\u043e\u0432\u0430\u044f \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f " + moneyCollection));
            this.queue.add(moneyCollection);
        }
    }

    @Override
    public void report(ReportRequest request) {
        if (request == null || request.getKkmOperation() == null) {
            throw new NullPointerException();
        }
        this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u0435\u0447\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u0430: " + request));
        this.queue.add(request);
    }

    @Override
    public ReportResult reportAndWait(ReportRequest request) throws Exception {
        if (request == null || request.getKkmOperation() == null) {
            throw new NullPointerException();
        }
        this.log.info((Object)("reportAndWait " + request));
        Object object = this.sync;
        synchronized (object) {
            this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u0435\u0447\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u0430: " + request));
            ReportResultStub rrs = new ReportResultStub();
            this.reportRequest(request, (ReportResultListener)rrs);
            if (rrs.getResult() != null) {
                return rrs.getResult();
            }
            if (rrs.getEx() != null) {
                throw new Exception(rrs.getEx());
            }
            throw new Exception("Not supported");
        }
    }

    @Override
    public ReportResult reportAndWait(LastReportsReqest request) throws Exception {
        if (request == null) {
            throw new NullPointerException();
        }
        this.log.info((Object)("reportAndWait " + request));
        Object object = this.sync;
        synchronized (object) {
            this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u0435\u0447\u0430\u0442\u044c \u043a\u043e\u043f\u0438\u0439 \u043e\u0442\u0447\u0435\u0442\u043e\u0432: " + request.getCount()));
            ReportResultStub rrs = new ReportResultStub();
            this.printLastZreports(request.getCount(), rrs);
            if (rrs.getResult() != null) {
                return rrs.getResult();
            }
            if (rrs.getEx() != null) {
                throw new Exception(rrs.getEx());
            }
            throw new Exception("Not supported");
        }
    }

    @Override
    public ReportResult reportAndWait(ReportByDate request) throws Exception {
        if (request == null) {
            throw new NullPointerException();
        }
        this.log.info((Object)("reportAndWait " + request));
        Object object = this.sync;
        synchronized (object) {
            this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u0435\u0447\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u0430: " + request));
            ReportResultStub rrs = new ReportResultStub();
            this.reportRequest(request, (ReportResultListener)rrs);
            if (rrs.getResult() != null) {
                return rrs.getResult();
            }
            if (rrs.getEx() != null) {
                throw new Exception(rrs.getEx());
            }
            throw new Exception("Not supported");
        }
    }

    @Override
    public void report(ReportByDate rbd) {
        this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u043f\u043e \u0434\u0430\u0442\u0430\u043c: " + rbd));
        this.queue.add(rbd);
    }

    @Override
    public short getCheckNumber() {
        return this.lastCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        this.log.info((Object)"Handler: BasePrinterQueue");
        errCount = 0;
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                this.printer.close();
                this.log.info((Object)"Stop thread");
                return;
            }
            this.lockOnTimeCorrection = false;
            var2_2 = this.sync;
            synchronized (var2_2) {
                obj = null;
                try {
                    try {
                        obj = this.queue.poll();
                        if (!this.printer.isOpen()) {
                            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u043e\u0440\u0442");
                            this.printer.open();
                            this.log.info((Object)"\u041f\u043e\u0440\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u0442. \u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u044e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
                            this.printer.init();
                            this.log.info((Object)"\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043e. \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e info");
                            for (PrinterInfoListener pil : this.listeners) {
                                pil.onInfo(this.printer.getInfo());
                            }
                            this.log.info((Object)"\u0423\u0441\u043f\u0435\u0445");
                        }
                        if (obj != null) {
                            this.log.info((Object)"\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                            if (this.lastStatus != null && !this.lastStatus.isWork() && obj instanceof Operation) {
                                this.log.info((Object)"\u041f\u0440\u0438\u043d\u0442\u0435\u0440 \u0432 \u043e\u0448\u0438\u0431\u043a\u0435, \u043d\u0435 \u043f\u043e\u0441\u044b\u043b\u0430\u0435\u043c \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c");
                            } else {
                                this.printObject(obj);
                                Thread.sleep(4000L);
                                this.lastCheck = this.printer.nextCheckNumber();
                                this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u043d\u043e\u043c\u0435\u0440 \u0447\u0435\u043a\u0430: " + this.lastCheck));
                            }
                            Thread.sleep(2000L);
                        } else if (this.last == 0L || Math.abs(System.currentTimeMillis() - this.last) > 7000L) {
                            this.lastCheck = this.printer.nextCheckNumber();
                            this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u043d\u043e\u043c\u0435\u0440 \u0447\u0435\u043a\u0430: " + this.lastCheck));
                            this.last = System.currentTimeMillis();
                            ps = null;
                            for (i = 0; i < 4 && !(ps = this.printer.getStatus()).isWork() && this.lastStatus != null && this.lastStatus.isWork(); ++i) {
                                if (i == 3) continue;
                                ThreadUtil.sleep((long)1500L);
                            }
                            if (!ps.equals(this.lastStatus)) {
                                this.log.debug((Object)("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: " + ps));
                                this.lastStatus = ps;
                            }
                            zReportSyncTime = false;
                            try {
                                zReportSyncTime = ReferenceManager.getInstance().getPointOptions().iszReportSyncTime();
                            }
                            catch (ReferenceException var6_10) {
                                // empty catch block
                            }
                            if (!(!zReportSyncTime || this.lastTimeCorrection != 0L && Math.abs(System.currentTimeMillis() - this.lastTimeCorrection) <= 6600000L || this.printer.getType() != PrinterType.Kkm && this.printer.getType() != PrinterType.KkmOnline)) {
                                this.lastTimeCorrection = System.currentTimeMillis();
                                hour = Calendar.getInstance().get(11);
                                if (hour < 6) {
                                    this.log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c \u0432\u0440\u0435\u043c\u044f \u041a\u041a\u041c");
                                    kkm = (Kkm)this.printer;
                                    if (kkm.isNeedCorrectTime()) {
                                        this.lockOnTimeCorrection = true;
                                        this.notifyPrinterStatus(this.deviceType.getDeviceClass(), new PrinterStatus(false, true, false, false));
                                        kkm.correctTime();
                                    }
                                }
                            }
                            this.notifyPrinterStatus(this.deviceType.getDeviceClass(), ps);
                            errCount = 0;
                        }
                        Thread.sleep(50L);
                    }
                    catch (IOException ex) {
                        Thread.sleep(3000L);
                        this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 \u043f\u043e\u0440\u0442\u043e\u043c", (Throwable)ex);
                        this.printer.close();
                        if (errCount == 3) {
                            this.log.error((Object)"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u043e\u0448\u0438\u0431\u043e\u043a, \u043e\u0442\u0441\u044b\u043b\u0430\u044e \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0430 c\u0435\u0440\u0432\u0435\u0440");
                            ps = new PrinterStatus();
                            ps.setOnline(false);
                            this.notifyPrinterStatus(this.deviceType.getDeviceClass(), ps);
                        }
                        if (errCount < 10) {
                            ++errCount;
                        }
                        ** if (obj == null || obj instanceof KkmOperation) goto lbl-1000
                    }
lbl-1000:
                    // 1 sources

                    {
                        // empty if block
                    }
lbl-1000:
                    // 1 sources

                    {
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            ThreadUtil.sleep((long)100L);
        }
    }

    private void printObject(Object obj) throws IOException {
        this.log.info((Object)"\u0418\u0437\u0432\u043b\u0435\u043a\u043b\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0447\u0435\u043a \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438. \u041e\u0442\u043f\u0440\u0430\u0432\u0438\u043b\u0438 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0443");
        if (obj instanceof Operation && !CommonUtils.isCanLog((Operation)obj)) {
            this.log.info((Object)"\u041d\u0435 \u043b\u043e\u0433\u0438\u0440\u0443\u0435\u043c \u043f\u0435\u0447\u0430\u0442\u044c \u0447\u0435\u043a\u0430, \u0438\u043c\u0435\u044e\u0442\u0441\u044f \u043c\u0430\u0441\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b");
            this.log.setLevel(Level.WARN);
        }
        if (obj instanceof GroupOperation) {
            GroupOperation op = (GroupOperation)obj;
            this.printer.printGroup(op, this.getRenderData(op.getService(), (Operation)op));
        } else if (obj instanceof Operation) {
            Operation op = (Operation)obj;
            this.printer.print(op, this.getRenderData(op.getService(), op));
        } else if (obj instanceof CustomData) {
            CustomData customData = (CustomData)obj;
            this.printer.print(customData, this.getRenderData(customData));
        } else if (obj instanceof MoneyCollection) {
            MoneyCollection mc = (MoneyCollection)obj;
            this.printer.print(mc, this.getInkassRenderData(mc));
        } else if (obj instanceof ReportRequest) {
            ReportRequest request = (ReportRequest)obj;
            ReportResultListener rrl = request.getListener() != null ? request.getListener() : new ReportResultAdapter();
            this.reportRequest(request, rrl);
        } else if (obj instanceof ReportByDate) {
            ReportByDate rbd = (ReportByDate)obj;
            ReportResultListener rrl = rbd.getListener() != null ? rbd.getListener() : new ReportResultAdapter();
            this.reportRequest(rbd, rrl);
        } else if (obj instanceof LastReportsReqest) {
            LastReportsReqest request = (LastReportsReqest)obj;
            ReportResultListener rrl = request.getListener() != null ? request.getListener() : new ReportResultAdapter();
            this.printLastZreports(request.getCount(), rrl);
        } else {
            this.log.error((Object)"\u041d\u0435\u0438\u0437\u0432\u0435\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0434\u043b\u044f \u043f\u0435\u0447\u0430\u0442\u0438");
        }
        this.log.setLevel(this.logLevel);
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u044c \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
    }

    private void reportRequest(ReportRequest request, ReportResultListener rrl) {
        if (this.printer.getType() == PrinterType.Kkm || this.printer.getType() == PrinterType.KkmOnline) {
            try {
                Kkm kkm = (Kkm)this.printer;
                ReportResult rr = null;
                switch (request.getKkmOperation()) {
                    case FormReportX: {
                        rr = kkm.formReportX();
                        break;
                    }
                    case FormReportZ: {
                        rr = kkm.formReportZ();
                        break;
                    }
                    case CloseReportZToMem: {
                        rr = kkm.closeReportZToMem();
                        break;
                    }
                    case FormReportZMem: {
                        if (this.getPrinterType() == PrinterType.Kkm) {
                            rr = kkm.formReportZMem();
                            break;
                        }
                        if (this.getPrinterType() != PrinterType.KkmOnline) break;
                        ReportResultStub rrs = new ReportResultStub();
                        this.printLastZreports(1, rrs);
                        rr = rrs.getResult();
                    }
                }
                this.log.info((Object)("result=" + rr));
                rrl.onResult(rr);
            }
            catch (IOException ex) {
                rrl.onFailure(ex);
            }
        } else {
            rrl.onUnsupport();
        }
    }

    private void reportRequest(ReportByDate rbd, ReportResultListener rrl) {
        if (this.printer instanceof Kkm) {
            try {
                Kkm kkm = (Kkm)this.printer;
                rrl.onResult(kkm.formReportDateRange(rbd.getBegin(), rbd.getEnd(), !rbd.isDetailed(), rbd.getPassword()));
            }
            catch (IOException ex) {
                rrl.onFailure(ex);
            }
        } else {
            rrl.onUnsupport();
        }
    }

    private String getAdvContent(int idService, Locale locale) {
        CheckAdv adv = AdvExtractor.extractCheckAdv(idService);
        this.log.info((Object)("\u0418\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u043e \u0440\u0435\u043a\u043b\u0430\u043c\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: " + adv));
        if (adv != null) {
            String advMessage = locale == null ? null : (String)adv.getLangs().get(locale.getLanguage());
            return advMessage != null ? advMessage : adv.getContent();
        }
        return null;
    }

    private RenderData getRenderData(Service service, Operation operation) {
        RenderData data = new RenderData();
        data.setAdvertisement(this.getAdvContent(service.getId(), operation.getLocale()));
        try {
            ReferenceManager rm = ReferenceManager.getInstance();
            operation.setBank(rm.getBank());
            operation.setPaymentSystem(rm.getPaymentSystem());
            if (operation.getDealer() == null) {
                operation.setDealer(rm.getDealer());
            }
            if (operation.getPoint() == null) {
                operation.setPoint(rm.getPoint());
            }
            if (service.getCheckRender() != null && !service.getCheckRender().isEmpty()) {
                data.setRenderName(service.getCheckRender());
            } else {
                data.setRenderName(rm.getPointOptions().getCheckRender());
            }
            if (rm.getPointOptions() != null) {
                data.setUseFiscalDepartments(rm.getPointOptions().isUseFiscalDepartments());
            }
            this.log.info((Object)("\u0411\u0438\u0442\u044c \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044e \u043f\u043e \u0440\u0430\u0437\u043d\u044b\u043c \u043e\u0442\u0434\u0435\u043b\u0430\u043c: " + rm.getPointOptions().isUseFiscalDepartments()));
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        data.setDeviceClass(this.deviceType.getDeviceClass());
        data.setDeviceType(this.deviceType);
        data.setPrinterType(this.getPrinterType());
        data.setFiscalMode(this.printer instanceof Kkm);
        return data;
    }

    private RenderData getInkassRenderData(MoneyCollection mc) {
        RenderData data = new RenderData();
        try {
            ReferenceManager rm = ReferenceManager.getInstance();
            mc.setBank(rm.getBank());
            mc.setPaymentSystem(rm.getPaymentSystem());
            mc.setDealer(rm.getDealer());
            mc.setPoint(rm.getPoint());
            data.setRenderName(rm.getPointOptions().getInkassRender());
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        data.setDeviceClass(this.deviceType.getDeviceClass());
        data.setDeviceType(this.deviceType);
        data.setFiscalMode(this.printer instanceof Kkm);
        return data;
    }

    private RenderData getRenderData(CustomData customData) {
        RenderData data = new RenderData();
        if (customData.getService() != null) {
            data.setAdvertisement(this.getAdvContent(customData.getService().getId(), null));
        }
        try {
            ReferenceManager rm = ReferenceManager.getInstance();
            customData.setBank(rm.getBank());
            customData.setPaymentSystem(rm.getPaymentSystem());
            customData.setDealer(rm.getDealer());
            customData.setPoint(rm.getPoint());
            if (customData.getTemplate() != null) {
                data.setRenderName(customData.getTemplate());
            } else {
                data.setRenderName(customData.getService().getCheckRender());
            }
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        data.setDeviceClass(this.deviceType.getDeviceClass());
        data.setDeviceType(this.deviceType);
        data.setFiscalMode(this.printer instanceof Kkm);
        return data;
    }

    @Override
    public void addObserver(PrinterStatusObserver observer) {
        if (observer != null) {
            this.observers.add(observer);
        }
    }

    private void notifyPrinterStatus(DeviceClass deviceClass, PrinterStatus status) {
        for (PrinterStatusObserver observer : this.observers) {
            observer.update(deviceClass, status);
        }
    }

    @Override
    public int getFiscalServerStatus() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrinterStatus getLastStatus() {
        return this.lastStatus;
    }

    @Override
    public void printLastZreports(LastReportsReqest request) {
        if (request == null) {
            throw new NullPointerException();
        }
        this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u0435\u0447\u0430\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445 Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432: " + request));
        this.queue.add(request);
    }

    private void printLastZreports(int number, ReportResultListener rrl) {
        if (this.printer.getType() == PrinterType.KkmOnline) {
            if (this.printer instanceof KkmOnline) {
                try {
                    KkmOnline kkm = (KkmOnline)((Object)this.printer);
                    ReportResult rr = kkm.printLastZreports(number);
                    rrl.onResult(rr);
                }
                catch (IOException ex) {
                    rrl.onFailure(ex);
                }
            } else {
                try {
                    ReportResult rr = ((Kkm)this.printer).formReportZMem();
                    rrl.onResult(rr);
                }
                catch (IOException ex) {
                    rrl.onFailure(ex);
                }
            }
        } else {
            rrl.onUnsupport();
        }
    }
}

