/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.pblock;

import com.google.zxing.WriterException;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.posprinter.PrnUtils;
import ru.softlogic.hardware.device.print.posprinter.api.PrinterApi;
import ru.softlogic.hardware.device.print.posprinter.img.BarcodeGenerator;
import ru.softlogic.hardware.device.print.posprinter.pblock.PrintBlock;

public class BarcodePrintBlock
implements PrintBlock {
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_DOUBLE_WIDTH = 1;
    public static final int SIZE_DOUBLE_HEIGHT = 2;
    public static final int SIZE_DOUBLE = 3;
    public static final String TYPE_QRCODE = "qrcode";
    public static final String TYPE_PDF417 = "pdf417";
    public static final String TYPE_ITF = "itf";
    private static final String name = "barcodesrc.png";
    private final String value;
    private final String type;
    private final int size;
    private final Map<String, String> params;
    private final Logger log;

    public BarcodePrintBlock(String type, String value, int size, Map<String, String> params, Logger log) {
        this.size = size;
        this.value = value;
        this.type = type;
        this.params = params;
        this.log = log;
    }

    @Override
    public void print(PrinterApi api) throws IOException {
        try {
            if (TYPE_PDF417.equals(this.type)) {
                BarcodeGenerator.generatePDF417(PrnUtils.getPath(name), this.value);
            } else if (TYPE_ITF.equals(this.type)) {
                BarcodeGenerator.generateITF(PrnUtils.getPath(name), this.value);
            } else {
                BarcodeGenerator.generateQRCode(PrnUtils.getPath(name), this.value, this.params);
            }
            api.printImage(name, this.size);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (WriterException ex) {
            this.log.error((Object)"Error on process image", (Throwable)ex);
        }
    }

    public String toString() {
        return "BarcodePrintBlock{value=" + this.value + ", type=" + this.type + ", name=" + name + ", size=" + this.size + '}';
    }
}

