/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.img;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.ITFWriter;
import com.google.zxing.pdf417.PDF417Writer;
import com.google.zxing.pdf417.encoder.Dimensions;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.Map;

public class BarcodeGenerator {
    public static void generateQRCode(File path, String value, Map<String, String> params) throws WriterException, IOException {
        EnumMap<EncodeHintType, Object> hintMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        hintMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.L);
        hintMap.put(EncodeHintType.MARGIN, (Object)0);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        int size = BarcodeGenerator.getParam(params, "size", 256, 100, 500);
        BitMatrix biteMatrix = qrCodeWriter.encode(value, BarcodeFormat.QR_CODE, size, size, hintMap);
        MatrixToImageWriter.writeToStream((BitMatrix)biteMatrix, (String)"png", (OutputStream)new FileOutputStream(path));
    }

    public static void generatePDF417(File path, String value) throws WriterException, IOException {
        PDF417Writer dF417Writer = new PDF417Writer();
        EnumMap<EncodeHintType, Integer> hintMap = new EnumMap<EncodeHintType, Integer>(EncodeHintType.class);
        hintMap.put(EncodeHintType.MARGIN, 0);
        hintMap.put(EncodeHintType.PDF417_DIMENSIONS, (Integer)new Dimensions(1, 100, 25, 100));
        BitMatrix biteMatrix = dF417Writer.encode(value, BarcodeFormat.PDF_417, 2, 1, hintMap);
        MatrixToImageWriter.writeToStream((BitMatrix)biteMatrix, (String)"png", (OutputStream)new FileOutputStream(path));
    }

    public static void generateITF(File path, String value) throws WriterException, IOException {
        ITFWriter itfWriter = new ITFWriter();
        EnumMap<EncodeHintType, Integer> hintMap = new EnumMap<EncodeHintType, Integer>(EncodeHintType.class);
        hintMap.put(EncodeHintType.MARGIN, 0);
        BitMatrix biteMatrix = itfWriter.encode(value, BarcodeFormat.ITF, value.length() * 32, 128, hintMap);
        MatrixToImageWriter.writeToStream((BitMatrix)biteMatrix, (String)"png", (OutputStream)new FileOutputStream(path));
    }

    private static int getParam(Map<String, String> params, String name, int def, int min, int max) {
        String val = params.get(name);
        if (val == null || !val.matches("\\d+")) {
            return def;
        }
        int res = Integer.parseInt(val);
        if (res < min) {
            return min;
        }
        if (res > max) {
            return max;
        }
        return res;
    }
}

