/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.drv.ddc;

import java.util.LinkedList;
import java.util.ResourceBundle;
import ru.softlogic.hardware.utils.ByteUtils;

public class FontHelper {
    public static final String rus = "\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f";

    public static byte[] getCharImage(char c) {
        try {
            String data = ResourceBundle.getBundle("ru.softlogic.hardware.device.print.posprinter.drv.ddc.font").getString("" + c);
            LinkedList<Byte> res = new LinkedList<Byte>();
            for (String bt : data.split(" ")) {
                byte symbol = (byte)Integer.parseInt(bt, 16);
                res.add(symbol);
            }
            return ByteUtils.convert(res);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static byte[] getCharCmd(char c, int code) {
        byte[] image = FontHelper.getCharImage(c);
        if (image == null) {
            return null;
        }
        byte[] res = new byte[image.length + 6];
        res[0] = 27;
        res[1] = 38;
        res[2] = 3;
        res[3] = (byte)(code & 0xFF);
        res[4] = (byte)(code & 0xFF);
        res[5] = 12;
        System.arraycopy(image, 0, res, 6, image.length);
        return res;
    }

    public static Integer getCharCode(char c) {
        int pos = rus.indexOf(c = Character.toUpperCase(c));
        if (pos < 0) {
            return null;
        }
        return pos + 94;
    }

    public static byte convertFrom866(byte b) {
        int code = b & 0xFF;
        if (code == 240) {
            return 100;
        }
        if (code >= 128 && code <= 133) {
            return (byte)(code - 34);
        }
        if (code >= 134 && code <= 159) {
            return (byte)(code - 33);
        }
        return b;
    }

    public static byte[] convertFrom866(byte[] b) {
        if (b == null) {
            return null;
        }
        for (int i = 0; i < b.length; ++i) {
            b[i] = FontHelper.convertFrom866(b[i]);
        }
        return b;
    }
}

