/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.drv;

import java.io.IOException;
import ru.softlogic.hardware.device.print.Tags;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.drv.GenericPrinterApi2;
import ru.softlogic.io.BasePort;

public abstract class StarLinePrinterApi<T extends BasePort>
extends GenericPrinterApi2<T> {
    public StarLinePrinterApi(T port) {
        super(port);
        this.tags.put(Tags.BoldBegin, new byte[]{27, 69});
        this.tags.put(Tags.BoldEnd, new byte[]{27, 70});
        this.tags.put(Tags.UnderLineBegin, new byte[]{27, 45, 49});
        this.tags.put(Tags.UnderLineEnd, new byte[]{27, 45, 48});
        this.tags.put(Tags.AlignCenter, new byte[]{27, 29, 97, 49});
        this.tags.put(Tags.AlignLeft, new byte[]{27, 29, 97, 48});
        this.tags.put(Tags.AlignRight, new byte[]{27, 29, 97, 50});
        this.tags.put(Tags.SmallBegin, null);
        this.tags.put(Tags.SmallEnd, null);
    }

    @Override
    public void scroll(int scroll) throws IOException {
        if (scroll > 0) {
            this.log.debug((Object)("Scroll data to " + scroll));
            ((BasePort)this.port).write(new byte[]{27, 97, (byte)(scroll & 0xFF)});
        }
    }

    @Override
    public void fullCut() throws IOException {
        ((BasePort)this.port).setTimeout(2000);
        this.log.debug((Object)"Cut paper");
        ((BasePort)this.port).write(new byte[]{27, 100, 1});
    }

    @Override
    public void partialCut() throws IOException {
        this.fullCut();
    }

    @Override
    public void init(PosPrinterOptions options) throws IOException {
        ((BasePort)this.port).setTimeout(200);
        this.log.debug((Object)"Init printer");
        ((BasePort)this.port).write(new byte[]{27, 64});
        this.log.debug((Object)("Set encoding to " + options.getEncoding()));
        ((BasePort)this.port).write(new byte[]{27, 29, 116, 10});
    }

    @Override
    public int getModelId() throws IOException {
        return 0;
    }

    @Override
    public String getVendor() {
        return "Star";
    }

    @Override
    public String getModel() {
        return "TUP900/Line";
    }

    @Override
    public void reset() throws IOException {
    }
}

