/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.drv;

import java.io.IOException;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.posprinter.PosPrinter;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.api.PrinterDeviceApi;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderManager;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.system.util.ThreadUtil;

public class PosPrinterStub
extends PosPrinter {
    private final Random rnd;
    private final Logger log;
    private final DeviceInfo info = new DeviceInfo(DeviceType.PosPrinterStub);
    private boolean open;

    public PosPrinterStub(PrinterDeviceApi api, PosPrinterOptions options) {
        super(api, options);
        this.rnd = new Random();
        this.log = Logger.getLogger((String)"print");
    }

    @Override
    public void print(Operation operation, RenderData data) throws IOException {
        String[] res = RenderManager.renderingOperation(DeviceType.GenericPosPrinter, operation, data);
        if (res != null) {
            for (String image : res) {
                this.log.info((Object)image);
            }
        } else {
            this.log.info((Object)"no image");
        }
    }

    @Override
    public void print(MoneyCollection moneyCollection, RenderData renderData) throws IOException {
        String[] image = RenderManager.renderingMoneyCollection(DeviceType.GenericPosPrinter, moneyCollection, renderData);
        if (image != null && image.length > 0) {
            this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0447\u0435\u043a\u043e\u0432 " + image.length));
            for (int i = 0; i < image.length; ++i) {
                String str;
                if (i != 0) {
                    ThreadUtil.sleep((long)3000L);
                }
                if ((str = image[i]) == null || str.trim().isEmpty()) continue;
                this.log.info((Object)image);
            }
        }
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        return new PrinterStatus();
    }

    @Override
    public short nextCheckNumber() {
        return (short)this.rnd.nextInt(16000);
    }

    @Override
    public void open() throws IOException {
        this.open = true;
    }

    @Override
    public void init() throws IOException {
        this.log.info((Object)"PosPrinterStub is init");
        this.info.setVendor("SoftLogic");
        this.info.setModel("PosPrinterStub");
        this.info.setFirmware("v0.1");
        this.log.info((Object)"Hardware info:");
        this.log.info((Object)("    Vendor: " + this.info.getVendor()));
        this.log.info((Object)("    Model: " + this.info.getModel()));
        this.log.info((Object)("    Firmware: " + this.info.getFirmware()));
    }

    @Override
    public void close() {
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    @Override
    public void printGroup(GroupOperation operation, RenderData renderData) throws IOException {
        this.print((Operation)operation, renderData);
    }

    @Override
    public void print(CustomData customData, RenderData renderData) throws IOException {
        String[] res = RenderManager.renderingCustomData(DeviceType.PosPrinterStub, customData, renderData);
        if (res != null && res.length > 0) {
            boolean first = true;
            this.log.info((Object)"\u0412\u0441\u0435\u0433\u043e \u0447\u0435\u043a\u043e\u0432");
            for (int i = 0; i < res.length; ++i) {
                if (i != 0) {
                    ThreadUtil.sleep((long)3000L);
                }
                String str = res[i];
                this.log.info((Object)("data " + i + ": " + str));
            }
        }
    }

    @Override
    public PrinterType getType() {
        return PrinterType.PosPrinter;
    }
}

