/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.drv;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.Tags;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.api.BasePrinterApi;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class IctGP58CA
extends BasePrinterApi {
    private SerialPort port;
    private String encoding;
    private Logger log;
    private Map<Tags, String> tags;
    private PrinterStatus ps;
    private int count;
    private final byte[] begin = new byte[]{80, -13, 0, 0};

    public IctGP58CA(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Port");
        }
        this.port = port;
        this.port.putParams(new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.Even));
        this.encoding = "cp1251";
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.tags = new EnumMap<Tags, String>(Tags.class);
        this.tags.put(Tags.BoldBegin, "");
        this.tags.put(Tags.BoldEnd, "");
        this.tags.put(Tags.UnderLineBegin, "");
        this.tags.put(Tags.UnderLineEnd, "");
        this.tags.put(Tags.AlignCenter, "");
        this.tags.put(Tags.AlignLeft, "");
        this.tags.put(Tags.AlignRight, "");
        this.tags.put(Tags.SmallBegin, "");
        this.tags.put(Tags.SmallEnd, "");
        this.tags.put(Tags.Br, "\r\n");
        this.ps = new PrinterStatus();
        this.ps.setError(false);
        this.ps.setOnline(true);
        this.ps.setPaperEnd(false);
        this.ps.setPaperNearEnd(false);
    }

    @Override
    public void init(PosPrinterOptions options) throws IOException {
    }

    @Override
    public void print(String text) throws IOException {
        this.log.debug((Object)"Start print, replace tags");
        text = text.replace("\n", "\r\n");
        text = this.processTags(text);
        this.count = 0;
        try {
            this.port.flush(Flush.RxTx);
            Matcher m2 = Pattern.compile(".{1,48}").matcher(text);
            while (m2.find()) {
                this.log.info((Object)(">>" + m2.group(0)));
                this.port.write(this.begin);
                this.port.write(m2.group(0).getBytes(this.encoding));
                this.port.write("\r".getBytes(this.encoding));
                this.port.write(new byte[]{13, 12});
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException(ex);
        }
    }

    @Override
    public void scroll(int scroll) throws IOException {
        try {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0430 \u0441\u0442\u0440\u043e\u043a: " + scroll));
            for (int i = 0; i < scroll; ++i) {
                this.port.write(this.begin);
                this.port.write(" \r".getBytes(this.encoding));
                this.port.write(new byte[]{13, 12});
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException(ex);
        }
    }

    @Override
    public void fullCut() throws IOException {
        this.port.write(new byte[]{13, 12});
        this.log.info((Object)"\u041e\u0436\u0438\u0434\u0430\u0435\u043c \u043e\u0442\u0432\u0435\u0442\u0430");
        this.port.setTimeout(5000);
        int data = this.port.readByte();
        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442 \u043e\u0442 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 " + String.format("0x%02x", data)));
        this.ps.setPaperEnd(data != 187);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException(ex);
        }
        this.port.setTimeout(100);
        this.log.info((Object)"\u041f\u043e\u0441\u044b\u043b\u0430\u044e \u043e\u0442\u0440\u0435\u0437\u043a\u0443");
        this.port.write(new byte[]{27, -11});
    }

    @Override
    public void partialCut() throws IOException {
        this.fullCut();
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        return this.ps;
    }

    @Override
    public int getModelId() throws IOException {
        return 0;
    }

    @Override
    public Port getConnection() {
        return this.port;
    }

    @Override
    public String getVendor() {
        return "ICT";
    }

    @Override
    public String getModel() {
        return "GP58CA";
    }

    private String processTags(String text) {
        for (Tags tag : Tags.values()) {
            String data = this.tags.get((Object)tag);
            text = text.replace(tag.getString(), data == null ? "" : data);
        }
        return text;
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void dispense(int steps) throws IOException {
    }

    @Override
    public String getFirmware() {
        return "n/a";
    }
}

