/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.drv;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.Tags;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.api.BasePrinterApi;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.Port;
import ru.softlogic.system.util.Translit;

public class GeBE
extends BasePrinterApi {
    private BidirectionPort port;
    private Logger log;
    private String encoding;
    private Map<Tags, String> tags;
    private boolean translit;

    public GeBE(BidirectionPort port, boolean translit) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Port");
        }
        this.port = port;
        this.encoding = "cp1251";
        this.translit = translit;
        this.log = Logger.getLogger((String)"print");
        this.tags = new EnumMap<Tags, String>(Tags.class);
        this.tags.put(Tags.BoldBegin, "");
        this.tags.put(Tags.BoldEnd, "");
        this.tags.put(Tags.UnderLineBegin, "");
        this.tags.put(Tags.UnderLineEnd, "");
        this.tags.put(Tags.AlignCenter, "");
        this.tags.put(Tags.AlignLeft, "");
        this.tags.put(Tags.AlignRight, "");
        this.tags.put(Tags.SmallBegin, "");
        this.tags.put(Tags.SmallEnd, "");
        this.tags.put(Tags.Br, "\n");
    }

    @Override
    public void init(PosPrinterOptions options) throws IOException {
        this.port.setTimeout(200);
        this.log.debug((Object)"Init printer");
        this.port.write(new byte[]{27, 64});
    }

    @Override
    public void print(String text) throws IOException {
        this.log.debug((Object)"Start print, replace tags");
        text = this.processTags(text);
        if (this.translit) {
            text = Translit.translit((String)text);
        }
        this.log.debug((Object)"Send data");
        this.port.setTimeout(1000 + text.length() * 4);
        this.port.write(new byte[]{1});
        Matcher m2 = Pattern.compile(".{1,26}").matcher(text);
        while (m2.find()) {
            this.port.write(m2.group(0).getBytes(this.encoding));
            this.port.write((byte)10);
        }
        this.log.debug((Object)"Stop print");
    }

    @Override
    public void scroll(int scroll) throws IOException {
        for (int i = 0; i < scroll; ++i) {
            this.port.write("\n".getBytes());
        }
    }

    @Override
    public void fullCut() throws IOException {
        this.port.setTimeout(2000);
        this.log.debug((Object)"Cut paper");
        this.port.write(new byte[]{27, 105});
    }

    @Override
    public void partialCut() throws IOException {
        this.fullCut();
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        this.port.setTimeout(50);
        this.port.tryRead(1000);
        this.port.setTimeout(1000);
        this.port.write((byte)24);
        int res = this.port.readByte();
        PrinterStatus status = new PrinterStatus();
        status.setPaperEnd((res & 2) > 0);
        status.setError((res & 0x7E) > 0);
        return status;
    }

    @Override
    public int getModelId() throws IOException {
        return 0;
    }

    @Override
    public Port getConnection() {
        return this.port;
    }

    @Override
    public String getVendor() {
        return "GeBE";
    }

    @Override
    public String getModel() {
        return "GeBE";
    }

    private String processTags(String text) {
        for (Tags tag : Tags.values()) {
            String data = this.tags.get((Object)tag);
            text = text.replace(tag.getString(), data == null ? "" : data);
        }
        return text;
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void dispense(int steps) throws IOException {
    }

    @Override
    public String getFirmware() {
        return "n/a";
    }
}

