/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.api;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.posprinter.api.PrinterApi;
import ru.softlogic.hardware.device.print.posprinter.api.PrinterDeviceApi;
import ru.softlogic.io.Port;
import ru.softlogic.io.usb.UsbPort;

public class UsbPrinterApi
implements PrinterDeviceApi {
    protected UsbPort port;
    protected PrinterApi api;
    protected DeviceType deviceType;
    protected Logger log;

    public UsbPrinterApi(UsbPort port, PrinterApi api, DeviceType deviceType) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 UsbPort");
        }
        if (api == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 api");
        }
        if (deviceType == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 deviceType");
        }
        this.port = port;
        this.api = api;
        this.deviceType = deviceType;
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    @Override
    public PrinterApi getEquipmentApi() {
        return this.api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            try {
                this.port.open();
                int modelId = this.api.getModelId();
                this.log.info((Object)String.format("Printer ID: 0x%02x", modelId));
                if (modelId != 0) {
                    if (modelId == 93 || modelId == 94) {
                        this.deviceType = DeviceType.CustomVkp80;
                    } else {
                        if (modelId == 117) {
                            this.log.debug((Object)("api.getModel();" + this.api.getModel()));
                            throw new NoSuchDeviceException();
                        }
                        if (modelId == 147) {
                            this.deviceType = DeviceType.CustomTg2480;
                        } else if (modelId == 168) {
                            this.deviceType = DeviceType.CustomTg2480;
                        } else if (modelId == 81) {
                            this.deviceType = DeviceType.CitizenCTS2000;
                        }
                    }
                    this.api.getStatus();
                    this.api.getStatus();
                    DeviceType deviceType = this.deviceType;
                    return deviceType;
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.port.close();
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.port.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    @Override
    public Port getPort() {
        return this.port;
    }

    @Override
    public void open() throws IOException {
        this.port.open();
    }

    @Override
    public void close() {
        this.port.close();
    }
}

