/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.posprinter.api.PrinterApi;
import ru.softlogic.hardware.device.print.posprinter.api.PrinterDeviceApi;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.system.util.ArrayUtils;

public class SerialPrinterApi
implements PrinterDeviceApi,
SerialDeviceApi {
    protected SerialPort serialPort;
    protected Map<Boolean, SerialParams[]> serialParams;
    protected PrinterApi api;
    protected DeviceType deviceType;
    protected Logger log;

    public SerialPrinterApi(SerialPort serialPort, SerialParams[] sp, PrinterApi api, DeviceType deviceType) {
        if (serialPort == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 connection");
        }
        if (api == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 api");
        }
        if (deviceType == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 deviceType");
        }
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.serialPort = serialPort;
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        if (sp == null) {
            this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)});
            this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.Even), new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.Even), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.Even), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.Even), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.Even), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.Mark)});
            this.log.debug((Object)"\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u0438 \u043a\u043e\u043c-\u043f\u043e\u0440\u0442\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        } else {
            this.serialParams.put(Boolean.TRUE, sp);
            this.serialParams.put(Boolean.FALSE, new SerialParams[0]);
        }
        this.api = api;
        this.deviceType = deviceType;
    }

    @Override
    public void open() throws IOException {
        if (this.serialParams.get(Boolean.TRUE).length == 1 && this.serialParams.get(Boolean.FALSE).length == 0) {
            this.serialPort.putParams(this.serialParams.get(Boolean.TRUE)[0]);
        }
        this.serialPort.open();
        this.serialPort.setFlow(Flow.None);
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return (SerialParams[])ArrayUtils.arrayMerge((Object[][])new SerialParams[][]{this.serialParams.get(true), this.serialParams.get(false)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (this.deviceType == DeviceType.CitizenCbm1000) {
            throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
        }
        for (SerialParams params : this.getAvailableParameters()) {
            try {
                this.serialPort.putParams(params);
                this.serialPort.open();
                int modelId = this.api.getModelId();
                this.log.info((Object)String.format("Printer ID: 0x%02x", modelId));
                Object dt = null;
                if (modelId == 0 || modelId == 117) continue;
                if (modelId == 93 || modelId == 94) {
                    this.deviceType = DeviceType.CustomVkp80;
                } else if (modelId == 147) {
                    this.deviceType = DeviceType.CustomTg2480;
                } else if (modelId == 168) {
                    this.deviceType = DeviceType.CustomTg2480;
                } else if (modelId == 95) {
                    this.deviceType = DeviceType.SnbcT080;
                }
                this.api.getStatus();
                this.api.getStatus();
                DeviceType deviceType = this.deviceType;
                return deviceType;
            }
            catch (Exception exception) {
            }
            finally {
                this.serialPort.close();
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public PrinterApi getEquipmentApi() {
        return this.api;
    }

    @Override
    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    @Override
    public Port getPort() {
        return this.serialPort;
    }
}

