/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.treasurer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.cash.Sum;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.kkm.BaseKkm;
import ru.softlogic.hardware.device.print.kkm.KKMUtil;
import ru.softlogic.hardware.device.print.kkm.KkmControl;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.kkm.treasurer.Helper;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerApi;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerLongState;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerPrinter;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerResult;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerShortState;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerType;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerU;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerVersion;
import ru.softlogic.hardware.device.print.kkm.treasurer.msg.TreasurerResultException;
import ru.softlogic.hardware.device.print.kkm.treasurer.msg.m;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderManager;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.connector.ZReportInfo;
import ru.softlogic.system.util.ThreadUtil;

public class TreasurerKkm
extends BaseKkm {
    private TreasurerApi api;
    private Logger log;
    private DeviceInfo deviceInfo;
    private TreasurerPrinter printer;
    private TreasurerVersion softwareVersion;
    private PrinterStatus lastStatus;
    private ResourceBundle bundle;
    private KkmOptions options;
    private int scroll;
    private int model;
    private TreasurerShortState lastshortState;
    private TreasurerLongState lastLongState;
    private boolean globalError;
    private KkmControl control;

    public TreasurerKkm(SerialPort port, KkmOptions options, KkmControl control) {
        super(DeviceType.TreasurerKkm, port, options);
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        if (options == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 KkmOptions");
        }
        if (control == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 KkmControl");
        }
        this.options = options;
        this.control = control;
        this.api = new TreasurerApi(port);
        this.printer = new TreasurerPrinter(port, options.getWidth());
        this.deviceInfo = new DeviceInfo(DeviceType.TreasurerKkm);
        this.deviceInfo.setPort(port.getName());
        this.deviceInfo.setVendor("PAYKiosk");
        this.bundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.print.kkm.kkm");
        this.log = Logger.getLogger((String)"print");
        if (options.getScroll() != null && options.getScroll() > 0) {
            this.scroll = options.getScroll();
        }
        if (options.getAdminPassword() != null && options.getAdminPassword().matches("^\\d+$")) {
            this.api.setFpPassword(options.getAdminPassword().isEmpty() ? 0 : Integer.parseInt(options.getAdminPassword()));
        } else {
            this.log.info((Object)"\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0424\u041f \u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u0431\u0435\u0437 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439");
        }
        if (options.getOperatorPassword() != null && options.getOperatorPassword().matches("^\\d+$")) {
            this.api.setPassword(options.getOperatorPassword().isEmpty() ? 0 : Integer.parseInt(options.getOperatorPassword()));
        } else {
            this.log.info((Object)"\u041f\u0430\u0440\u043e\u043b\u044c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u0431\u0435\u0437 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439");
        }
    }

    @Override
    public ReportResult formReportX() throws IOException {
        this.log.info((Object)"\u0421\u043d\u044f\u0442\u0438\u0435 X-\u043e\u0442\u0447\u0435\u0442\u0430. \u0412\u044b\u0445\u043e\u0436\u0443 \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430");
        try {
            m.addResEx(this.exitMode(true));
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0430\u044e \u0424\u0420 \u0432 \u0440\u0435\u0436\u0438\u043c \u0441\u043d\u044f\u0442\u0438\u044f X \u043e\u0442\u0447\u0435\u0442\u0430");
            m.addResEx(this.api.selectMode((byte)2));
            this.log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e X-\u043e\u0442\u0447\u0435\u0442");
            m.addResEx(this.api.reportX());
            return new ReportResult(0, false, m.getMessage(0));
        }
        catch (TreasurerResultException ex) {
            return new ReportResult(ex.getErrorCode(), true, ex.getMessage());
        }
    }

    @Override
    public ReportResult formReportZ() throws IOException {
        try {
            this.log.info((Object)"\u0421\u043d\u044f\u0442\u0438\u0435 Z-\u043e\u0442\u0447\u0435\u0442\u0430. \u0412\u044b\u0445\u043e\u0436\u0443 \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430");
            m.addResEx(this.exitMode(true));
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0430\u044e \u0424\u0420 \u0432 \u0440\u0435\u0436\u0438\u043c \u0441\u043d\u044f\u0442\u0438\u044f Z \u043e\u0442\u0447\u0435\u0442\u0430");
            m.addResEx(this.api.selectMode((byte)3));
            ZReportInfo zReport = this.api.readZReportInfo();
            this.log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e Z-\u043e\u0442\u0447\u0435\u0442 \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438. \u041e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0430\u0435\u043c \u0441\u043d\u044f\u0442\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
            int res = this.api.printReportsFromMemory();
            if (res == 0 || res == 122 || res == 170) {
                m.addRes(res);
                this.log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e Z-\u043e\u0442\u0447\u0435\u0442");
                res = this.api.reportZ();
                if (res == 0) {
                    this.notifyZReportInfo(zReport);
                }
                m.addResEx(res);
            } else {
                m.addResEx(res);
            }
            return new ReportResult(0, false, m.getMessage(0));
        }
        catch (TreasurerResultException ex) {
            return new ReportResult(ex.getErrorCode(), true, ex.getMessage());
        }
    }

    @Override
    public ReportResult closeReportZToMem() throws IOException {
        try {
            this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0441\u043c\u0435\u043d\u0443 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c. \u0412\u044b\u0445\u043e\u0436\u0443 \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430");
            m.addResEx(this.api.exitMode());
            this.log.info((Object)"\u0421\u0442\u0430\u0432\u043b\u044e \u0440\u0435\u0436\u0438\u043c \u0441\u043d\u044f\u0442\u0438\u044f Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432");
            m.addResEx(this.api.selectMode((byte)3));
            ZReportInfo zReport = this.api.readZReportInfo();
            this.log.info((Object)"\u0412\u043a\u043b\u044e\u0447\u0430\u044e \u0440\u0435\u0436\u0438\u043c \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0442\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0445 \u043e\u0442\u0447\u0435\u0442\u043e\u0432");
            m.addResEx(this.api.putReportsToMemory());
            this.log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e Z \u043e\u0442\u0447\u0435\u0442 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
            m.addResEx(this.api.reportZ());
            this.notifyZReportInfo(zReport);
            return new ReportResult(0, false, m.getMessage(0));
        }
        catch (TreasurerResultException ex) {
            return new ReportResult(ex.getErrorCode(), true, ex.getMessage());
        }
    }

    @Override
    public ReportResult formReportDateRange(Date start, Date finish, boolean shortReport, String password) throws IOException {
        this.log.info((Object)("\u0424\u043e\u0440\u043c\u0438\u0440\u0443\u044e \u043e\u0442\u0447\u0435\u0442 \u043f\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0443 \u0434\u0430\u0442, \u043e\u0442 " + start + ", \u0434\u043e " + finish + ", short=" + shortReport));
        this.log.info((Object)"\u0412\u044b\u0445\u043e\u0436\u0443 \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430");
        int res = this.api.exitMode();
        m.addRes(res);
        this.log.info((Object)"\u0412\u044b\u0431\u0438\u0440\u0430\u044e \u0440\u0435\u0436\u0438\u043c \u0440\u0430\u0431\u043e\u0442\u044b \u0441 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u044c\u044e");
        res = this.api.selectMode((byte)5, password);
        m.addRes(res);
        if (res == 0) {
            this.log.info((Object)"\u0424\u043e\u0440\u043c\u0438\u0440\u0443\u044e \u043e\u0442\u0447\u0435\u0442");
            res = this.api.fiscalReportByDateRange(start, finish, shortReport ? 0 : 1);
            m.addRes(res);
        }
        this.log.info((Object)"\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u0430");
        return new ReportResult(res, res != 0, m.getMessage(res));
    }

    @Override
    public ReportResult formReportZMem() throws IOException {
        try {
            this.log.info((Object)"\u0421\u043d\u044f\u0442\u0438\u0435 Z-\u043e\u0442\u0447\u0435\u0442\u0430 \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438. \u0412\u044b\u0445\u043e\u0436\u0443 \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430");
            m.addResEx(this.exitMode(true));
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0430\u044e \u0424\u0420 \u0432 \u0440\u0435\u0436\u0438\u043c \u0441\u043d\u044f\u0442\u0438\u044f Z \u043e\u0442\u0447\u0435\u0442\u0430");
            m.addResEx(this.api.selectMode((byte)3));
            this.log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e Z-\u043e\u0442\u0447\u0435\u0442 \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
            m.addResEx(this.api.printReportsFromMemory());
            return new ReportResult(0, false, m.getMessage(0));
        }
        catch (TreasurerResultException ex) {
            return new ReportResult(ex.getErrorCode(), true, ex.getMessage());
        }
    }

    @Override
    public void print(CustomData customData, RenderData renderData) throws IOException {
        String[] str = RenderManager.renderingCustomData(DeviceType.TreasurerKkm, customData, renderData);
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442:");
        if (str != null && str.length > 0 && !str[0].trim().isEmpty()) {
            this.printer.print(str[0].trim());
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            this.printer.scroll(4 + this.scroll);
            this.log.info((Object)"\u041e\u0442\u0440\u0435\u0437\u0430\u044e");
            m.addRes(this.api.cutPaper((byte)0));
        } else {
            this.log.error((Object)"\u041d\u0435\u0447\u0435\u0433\u043e \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Operation operation, RenderData data) throws IOException {
        if (this.isSupportedNotFiscalMode() && Boolean.TRUE.equals(operation.getService().isNotFiscal())) {
            this.printNotFiscal(operation, data);
            return;
        }
        int res = 0;
        this.log.info((Object)"Begin------------------------------------------------------");
        long start = System.currentTimeMillis();
        try {
            boolean isBankCard;
            for (int i = 0; i < 2; ++i) {
                res = this.exitMode(true);
                if (res != 0) {
                    this.notifyError(operation, "exitMode", res);
                }
                this.log.info((Object)"\u0412\u044b\u0431\u0438\u0440\u0430\u0435\u043c \u0440\u0435\u0436\u0438\u043c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438");
                res = this.api.selectMode((byte)1);
                m.addRes(res);
                if (res == 0 || res == 30) break;
                this.processError(res, true);
            }
            if (res != 0 && res != 30) {
                this.notifyError(operation, "selectMode", res);
            }
            SumResult sumResult = operation.getSumResult();
            this.log.info((Object)("\u0421\u0443\u043c\u043c\u044b: " + sumResult));
            int paymentTool = operation.getPaymentTool();
            boolean bl = isBankCard = paymentTool == 2 || paymentTool == 3;
            if (sumResult.getCash().getBasicSum() > 0 && sumResult.getCashLess().isEmpty() && !operation.isCopy()) {
                this.printComplex(operation, data, false);
            } else if (sumResult.getCash().isEmpty() && !sumResult.getCashLess().isEmpty() && !operation.isCopy() && isBankCard) {
                this.printComplex(operation, data, true);
            } else if (sumResult.getCash().getBasicSum() > 0 && !sumResult.getCashLess().isEmpty() && !operation.isCopy()) {
                this.printCashOnly(operation, data);
            } else {
                this.log.info((Object)"\u041d\u0435\u0442 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438. \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043e\u0431\u044b\u0447\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442: " + data.getRenderName()));
                Object[] str = RenderManager.renderingOperation(DeviceType.TreasurerPrinter, operation, data);
                this.log.info((Object)Arrays.toString(str));
                if (str != null) {
                    for (int i = 0; i < str.length; ++i) {
                        Object string = str[i];
                        this.printer.print((String)string);
                        this.printer.scroll(4 + this.scroll);
                        this.printer.partialCut();
                        ThreadUtil.sleep((long)(i == str.length - 1 ? 0 : 2000));
                    }
                }
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430/\u0432\u044b\u0432\u043e\u0434\u0430 \u043f\u0440\u0438 \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430", (Throwable)ex);
            this.notifyOperationError(operation, null, ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a", (Throwable)ex);
        }
        finally {
            this.log.info((Object)("****** \u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430: " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    @Override
    public void print(MoneyCollection moneyCollection, RenderData renderData) throws IOException {
        this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u044c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: " + moneyCollection));
        this.log.info((Object)"\u041f\u043e\u0441\u044b\u043b\u0430\u044e \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c");
        String[] res = RenderManager.renderingMoneyCollection(DeviceType.TreasurerKkm, moneyCollection, renderData);
        if (res != null && res.length > 0) {
            this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0447\u0435\u043a\u043e\u0432 " + res.length));
            for (int i = 0; i < res.length; ++i) {
                String str;
                if (i != 0) {
                    ThreadUtil.sleep((long)3000L);
                }
                if ((str = res[i]) == null || str.trim().isEmpty()) continue;
                this.printer.print(str);
                this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + (4 + this.scroll)));
                this.printer.scroll(4 + this.scroll);
                this.log.info((Object)"\u041e\u0442\u0440\u0435\u0437\u0430\u044e");
                this.printer.fullCut();
            }
        }
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u044c \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        PrinterStatus ps = new PrinterStatus();
        TreasurerShortState shortState = this.api.getShortState();
        if (this.lastshortState == null || !this.lastshortState.equals(shortState)) {
            this.log.info((Object)("Short state: " + shortState));
            this.lastshortState = shortState;
            this.globalError = false;
            if (shortState.getMode() == 7 && shortState.getSubmode() == 14) {
                this.log.info((Object)"\u0411\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0430 \u043f\u0440\u0438 \u043e\u0448\u0438\u0431\u043a\u0435 \u042d\u041a\u041b\u0417");
                this.globalError = true;
            }
            if (shortState.getMode() == 5 && shortState.getSubmode() == 1) {
                this.log.info((Object)"\u0411\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0430 \u0438\u0437\u0437\u0430 \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0424\u041f");
                this.globalError = true;
                this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0440\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u043c\u0438 \u043f\u0430\u0440\u043e\u043b\u044f\u043c\u0438");
                m.addRes(this.api.selectMode((byte)5));
            }
        }
        ps.setPaperEnd(shortState.isPaperEnd());
        ps.setError(!shortState.isWork());
        ps.setOnline(shortState.isPrinterConnected());
        TreasurerLongState als = this.api.getLongState();
        if (this.lastLongState == null || !this.lastLongState.equals(als)) {
            this.log.info((Object)("Long state: " + als));
            this.lastLongState = als;
        }
        if ((als.getFlags() & 0x20) > 0) {
            ps.setError(true);
        }
        if (this.globalError) {
            ps.setError(this.globalError);
        }
        if (ps.isWork()) {
            int res = this.exitMode(false);
            m.addRes(res);
            if (res == 0) {
                res = this.api.selectMode((byte)1);
                m.addRes(res);
                if (res == 136) {
                    if ((res = this.processError(res, false)) == 103) {
                        this.log.info((Object)"\u0411\u0443\u0444\u0444\u0435\u0440 \u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d[136->103]");
                        ps.setPaperEnd(true);
                    }
                } else if (res == 177) {
                    ps.setOnline(false);
                }
            }
        }
        if (!ps.equals(this.lastStatus)) {
            this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: " + ps));
            this.lastStatus = ps;
        }
        return ps;
    }

    @Override
    public short nextCheckNumber() {
        Random rnd = new Random();
        return (short)rnd.nextInt(16000);
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public boolean isOpen() {
        return this.api.getPort().isOpen();
    }

    @Override
    public DeviceInfo getInfo() {
        return this.deviceInfo;
    }

    @Override
    public void init() throws IOException {
        TreasurerLongState longState = this.api.getLongState();
        this.log.info((Object)"-----------------------------------------------------------");
        this.log.info((Object)("\u041f\u043e\u0440\u0442: " + this.api.getPort()));
        this.log.info((Object)"-----------------------------------------------------------");
        this.log.info((Object)("\u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e: " + longState.getSoftwareVersion()));
        this.log.info((Object)("\u0417\u0430\u0432\u043e\u0434\u0441\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440: " + longState.getFactoryNumber()));
        this.log.info((Object)("\u041d\u043e\u043c\u0435\u0440 \u041a\u041a\u041c: " + longState.getKkmNumber()));
        this.log.info((Object)("\u0424\u043b\u0430\u0433\u0438: " + longState.getFlags()));
        this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u041a\u041a\u041c: " + longState.getDate()));
        TreasurerResult<TreasurerType> type = this.api.getKkmType();
        this.model = 0;
        if (type.getError() == 0) {
            this.log.info((Object)"-----------------------------------------------------------");
            this.log.info((Object)("\u041c\u043e\u0434\u0435\u043b\u044c: " + type.getData().getModel()));
            this.log.info((Object)("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: " + type.getData().getName()));
            this.log.info((Object)("\u0412\u0435\u0440\u0441\u0438\u044f: " + type.getData().getVersion()));
            this.log.info((Object)("\u0422\u0438\u043f: " + type.getData().getType()));
            this.log.info((Object)("\u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b: " + type.getData().getProto()));
            this.log.info((Object)("\u0420\u0435\u0436\u0438\u043c: " + type.getData().getMode()));
            this.deviceInfo.setModel(type.getData().getName() + ",id=" + type.getData().getModel());
            this.model = type.getData().getModel();
        } else {
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043a\u043a\u043c: " + m.getMessage(type)));
        }
        this.log.info((Object)"-----------------------------------------------------------");
        this.log.info((Object)"\u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e:");
        this.softwareVersion = this.api.getVersion((byte)1);
        TreasurerVersion mem = this.api.getVersion((byte)2);
        TreasurerVersion boot = this.api.getVersion((byte)3);
        this.log.info((Object)("    \u041f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0440 \u0441 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u043c \u041f\u041e \u041a\u041a\u041c: " + this.softwareVersion));
        this.log.info((Object)("    \u041f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0440 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u044c\u044e: " + mem));
        this.log.info((Object)("    Bootblock \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0440\u0430 \u041a\u041a\u041c: " + boot));
        this.log.info((Object)("    \u041f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0440 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u043e\u043c: " + this.api.getVersion((byte)4)));
        this.log.info((Object)("    Bootblock \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0440\u0430 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430: " + this.api.getVersion((byte)5)));
        this.log.info((Object)"-----------------------------------------------------------");
        this.deviceInfo.setSerial(longState.getFactoryNumber());
        this.deviceInfo.setFirmware("\u041a\u041a\u0422: " + this.softwareVersion);
        this.deviceInfo.setFirmware1("\u0424\u041f: " + mem);
        this.deviceInfo.setFirmware2("Boot: " + boot);
        this.log.info((Object)"-----------------------------------------------------------");
        TreasurerResult<Integer> rest = this.api.getRestSessions();
        if (rest.getError() == 0) {
            this.log.info((Object)("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0441\u0442\u0430\u0432\u0448\u0438\u0445\u0441\u044f \u0441\u043c\u0435\u043d: " + rest.getData()));
            this.deviceInfo.setInfo(rest.getData().toString());
        } else {
            this.log.info((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043e\u0441\u0442\u0430\u0432\u0449\u0438\u0445\u0441\u044f \u0441\u043c\u0435\u043d: " + m.getMessage(rest.getError())));
        }
        this.log.info((Object)"-----------------------------------------------------------");
        this.log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0424\u0420");
        this.api.exitMode();
        this.api.selectMode((byte)4);
        TreasurerResult<byte[]> res = this.api.readTable(2, 1, 34);
        if (0 == res.getError()) {
            this.log.info((Object)("\u041c\u043d\u043e\u0436\u0438\u0442\u0435\u043b\u044c: " + res.getData()[0]));
            if (res.getData()[0] != 3) {
                this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0438\u0442\u0435\u043b\u044f \u0432 3, \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + this.api.writeTable(2, 1, 34, new byte[]{3})));
            }
        }
        if (0 == (res = this.api.readTable(2, 1, 51)).getError()) {
            this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043a\u043e\u043c\u0430\u043d\u0434\u043e\u0439 '\u041f\u0435\u0447\u0430\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0438': " + res.getData()[0]));
            if (res.getData()[0] != 1) {
                this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043a\u043e\u043c\u0430\u043d\u0434\u043e\u0439 '\u041f\u0435\u0447\u0430\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0438' \u0432 1, \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + this.api.writeTable(2, 1, 51, new byte[]{1})));
            }
        }
        if (0 == (res = this.api.readTable(2, 1, 55)).getError()) {
            int width = Integer.parseInt(String.format("%x", res.getData()[0]));
            this.log.info((Object)("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0448\u0438\u0440\u0438\u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u0438, \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432: " + width));
        }
        if (0 == (res = this.api.readTable(2, 1, 61)).getError()) {
            this.log.info((Object)("\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e '\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0442\u044c \u0432\u0440\u0435\u043c\u044f': " + res.getData()[0]));
            if (res.getData()[0] != 0) {
                this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e '\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0442\u044c \u0432\u0440\u0435\u043c\u044f' \u0432 0, \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + this.api.writeTable(2, 1, 61, new byte[]{0})));
            }
        }
        if (0 == (res = this.api.readTable(2, 1, 43)).getError()) {
            this.log.info((Object)("\u0421\u043d\u044f\u0442\u0438\u0435 Z-\u043e\u0442\u0447\u0435\u0442\u0430 \u0432 \u0431\u0443\u0444\u0435\u0440: " + res.getData()[0]));
            if (res.getData()[0] != 2) {
                this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0441\u043d\u044f\u0442\u0438\u0435 Z-\u043e\u0442\u0447\u0435\u0442\u0430 \u0432 2, \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + this.api.writeTable(2, 1, 43, new byte[]{2})));
            }
        }
        if (0 == (res = this.api.readTable(22, 1, 2)).getError()) {
            this.log.info((Object)("\u041f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043d\u044f\u0442\u0438\u044f Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432: " + res.getData()[0]));
            if (res.getData()[0] != 3) {
                this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043d\u044f\u0442\u0438\u044f Z-\u043e\u0442\u0447\u0435\u0442\u0430 \u0432 3(\u043a\u0430\u0436\u0434\u044b\u0435 24 \u0447\u0430\u0441\u0430), \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + this.api.writeTable(22, 1, 2, new byte[]{3})));
            }
        }
        this.log.info((Object)"\u0412\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u044e \u0432\u044b\u0440\u0430\u0432\u043d\u0438\u0432\u0430\u043d\u0438\u0435 \u043f\u043e \u043b\u0435\u0432\u043e\u043c\u0443 \u043a\u0440\u0430\u044e");
        m.addRes(this.api.setAlignment(0));
        this.api.exitMode();
        this.api.selectMode((byte)1);
        this.log.info((Object)"\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0438 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0443 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438");
    }

    private int processError(int error, boolean logActions) throws IOException {
        if (logActions) {
            this.log.info((Object)("\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u0443\u0441\u0442\u0440\u0430\u043d\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0443: " + error));
        }
        if (error == 155) {
            this.log.info((Object)"\u041e\u0442\u043c\u0435\u043d\u044f\u044e \u0447\u0435\u043a");
            int res = this.api.cancelCheck();
            m.addRes(res);
            return res;
        }
        if (error == 136) {
            int result = Helper.processDayReport(this.api, this.control, this);
            this.log.info((Object)"\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0430\u0435\u043c \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c");
            if (result == 0) {
                this.log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0432\u0440\u0435\u043c\u044f \u0424\u0420");
                Date now = new Date();
                Date fr = this.api.getLongState().getDate();
                this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430: " + now + ", \u0432\u0440\u0435\u043c\u044f \u0424\u0420: " + fr));
                if (Math.abs(now.getTime() - fr.getTime()) > 180000L) {
                    this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043d\u0430 3 \u043c\u0438\u043d\u0443\u0442\u044b. \u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0434\u0430\u0442\u0443 \u0424\u0420");
                    int res1 = this.api.setDate(now);
                    m.addRes(res1);
                    this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0432\u0440\u0435\u043c\u044f");
                    res1 = this.api.setTime(now);
                    m.addRes(res1);
                    this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e");
                } else {
                    this.log.info((Object)"\u041a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u044f \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
                }
            } else {
                this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0441\u043c\u0435\u043d\u044b \u0432 \u043f\u0430\u043c\u044f\u0442\u044c. \u041d\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0432\u0440\u0435\u043c\u044f \u0424\u0420");
            }
            return result;
        }
        if (error == 137 || error == 155) {
            this.log.info((Object)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u044e \u043e\u0442\u043c\u0435\u043d\u0443 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
            int res = this.api.cancelCheck();
            m.addRes(res);
            return res;
        }
        if (error == 31 || error == 21) {
            this.processError(136, logActions);
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u0440\u0435\u043c\u044f");
            Date now = new Date();
            int res = this.api.setDate(now);
            m.addRes(res);
            res = this.api.setTime(now);
            m.addRes(res);
            return res;
        }
        if (error == 157) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u0439\u044e \u0432\u043e\u0439\u0442\u0438 \u0432 \u0440\u0435\u0436\u0438\u043c \u0440\u0430\u0431\u043e\u0442\u044b \u0441 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u044c\u044e");
            int res = this.api.selectMode((byte)5);
            m.addRes(res);
            return res;
        }
        this.log.info((Object)("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0430 \u043e\u0448\u0438\u0431\u043a\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442: " + error));
        return -1;
    }

    private int exitMode(boolean logActions) throws IOException {
        Helper.setPresenterParams(this.api, this.model, 0);
        if (logActions) {
            this.log.info((Object)"\u0412\u044b\u0445\u043e\u0434\u0438\u043c \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430");
        }
        TreasurerShortState ass = this.api.getShortState();
        int res = 0;
        if (logActions) {
            this.log.info((Object)("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0440\u0435\u0436\u0438\u043c: " + ass));
        }
        if (ass.getMode() == 1 && ass.getSubmode() == 4) {
            this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0442 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442. \u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c");
            res = this.api.cancelCheck();
            m.addRes(res);
            if (res != 0) {
                this.processError(res, logActions);
                return res;
            }
        }
        for (int i = 0; i < 10; ++i) {
            res = this.api.exitMode();
            if (logActions) {
                m.addRes(res);
            }
            if (res != 102) break;
            this.log.info((Object)("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0440\u0435\u0436\u0438\u043c: " + this.api.getShortState() + ", \u0441\u043f\u043b\u044e 1 \u0441\u0435\u043a"));
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IOException(ex);
            }
        }
        if (res != 0 && this.processError(res, logActions) == 0) {
            this.log.info((Object)"\u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u0432\u044b\u0445\u043e\u0434\u0438\u043c \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430");
            res = this.api.exitMode();
            m.addRes(res);
        }
        return res;
    }

    private int openCheck(Operation operation, byte flag, byte type) throws IOException, Exception {
        int res = 0;
        for (int i = 0; i < 3; ++i) {
            this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
            res = this.api.openCheck(flag, type);
            m.addRes(res);
            if (res == 30) {
                return 0;
            }
            if (res != 0) {
                if (this.processError(res, true) == 0) continue;
                return res;
            }
            return res;
        }
        return res;
    }

    private void notifyError(Operation op, String procedure, int result) throws Exception {
        this.notifyOperationError(op, procedure, m.getMessage(result));
        throw new Exception("Can't print document,proc=" + procedure + ",res=" + result);
    }

    @Override
    public void setDefaultValues() {
        this.log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 '\u043f\u043e-\u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e' \u043e\u0442\u0441\u0443\u0441\u0442\u0432\u0443\u044e\u0442");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printGroup(GroupOperation operation, RenderData data) throws IOException {
        if (this.isSupportedNotFiscalMode() && Boolean.TRUE.equals(operation.getService().isNotFiscal())) {
            this.printNotFiscalGroup(operation, data);
            return;
        }
        int res = 0;
        this.log.info((Object)"Begin------------------------------------------------------");
        long start = System.currentTimeMillis();
        try {
            int paymentTool;
            boolean isBankCard;
            for (int i = 0; i < 2; ++i) {
                res = this.exitMode(true);
                if (res != 0) {
                    this.notifyError((Operation)operation, "exitMode", res);
                }
                this.log.info((Object)"\u0412\u044b\u0431\u0438\u0440\u0430\u0435\u043c \u0440\u0435\u0436\u0438\u043c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438");
                res = this.api.selectMode((byte)1);
                m.addRes(res);
                if (res == 0 || res == 30) break;
                this.processError(res, true);
            }
            if (res != 0 && res != 30) {
                this.notifyError((Operation)operation, "selectMode", res);
            }
            boolean bl = isBankCard = (paymentTool = operation.getPaymentTool()) == 2 || paymentTool == 3;
            if (operation.getSumResult().getCash().getBasicSum() > 0) {
                this.printComplex((Operation)operation, data, false);
            } else if (!operation.getSumResult().getCashLess().isEmpty() && isBankCard) {
                this.printComplex((Operation)operation, data, true);
            } else {
                this.log.info((Object)"\u041d\u0435\u0442 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438. \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043e\u0431\u044b\u0447\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442:");
                String[] str = RenderManager.renderingGroupOperation(DeviceType.TreasurerPrinter, operation, data);
                this.printer.print(str != null && str.length > 0 ? str[0] : "");
                this.printer.scroll(4 + this.scroll);
                this.printer.fullCut();
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430/\u0432\u044b\u0432\u043e\u0434\u0430 \u043f\u0440\u0438 \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430", (Throwable)ex);
            this.notifyOperationError((Operation)operation, null, ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a", (Throwable)ex);
        }
        finally {
            this.log.info((Object)("****** \u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430: " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    @Override
    public PrinterType getType() {
        return PrinterType.KkmOnline;
    }

    @Override
    public boolean isNeedCorrectTime() throws IOException {
        Date now = new Date();
        Date fr = this.api.getLongState().getDate();
        this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430: " + now + ", \u0432\u0440\u0435\u043c\u044f \u0424\u0420: " + fr));
        if (Math.abs(now.getTime() - fr.getTime()) > 180000L) {
            this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043d\u0430 3 \u043c\u0438\u043d\u0443\u0442\u044b.");
            if (now.getTime() - fr.getTime() > 0L) {
                this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u0424\u0420 \u043e\u0442\u0441\u0442\u0430\u0435\u0442. \u0421\u043c\u0435\u043d\u0438\u043c \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0441\u043c\u0435\u043d\u044b");
            } else if (now.getTime() - fr.getTime() < -7200000L) {
                this.log.info((Object)"\u0420\u0430\u0437\u043d\u0438\u0446\u0430 \u0432\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 2\u0445 \u0447\u0430\u0441\u043e\u0432. \u041d\u0435 \u043c\u043e\u0433\u0443 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b");
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public void correctTime() throws IOException, InterruptedException {
        this.log.info((Object)"\u041a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438. \u0417\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0441\u043c\u0435\u043d\u0443");
        int result = Helper.processDayReport(this.api, this.control, this);
        this.log.info((Object)("\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0430\u0435\u043c \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c. Res " + result));
        if (result == 0 || result == 143) {
            this.log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0432\u0440\u0435\u043c\u044f \u0424\u0420");
            Date now = new Date();
            Date fr = this.api.getLongState().getDate();
            this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430: " + now + ", \u0432\u0440\u0435\u043c\u044f \u0424\u0420: " + fr));
            long sleepTime = Math.abs(now.getTime() - fr.getTime());
            if (sleepTime > 180000L) {
                this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043d\u0430 3 \u043c\u0438\u043d\u0443\u0442\u044b. \u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0434\u0430\u0442\u0443 \u0424\u0420");
                Thread.sleep(sleepTime + 10000L);
                now = new Date();
                int res1 = this.api.setDate(now);
                m.addRes(res1);
                this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0432\u0440\u0435\u043c\u044f");
                res1 = this.api.setTime(now);
                m.addRes(res1);
                this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e");
            } else {
                this.log.info((Object)"\u041a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u044f \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
            }
        } else {
            this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0441\u043c\u0435\u043d\u044b \u0432 \u043f\u0430\u043c\u044f\u0442\u044c. \u041d\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0432\u0440\u0435\u043c\u044f \u0424\u0420");
        }
    }

    private void printComplex(Operation operation, RenderData data, boolean isCashless) throws Exception {
        int cash;
        Sum commService;
        this.log.info((Object)"\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f. \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442. \u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        String address = operation.geteCheckAddress();
        int res = this.openCheck(operation, (byte)0, (byte)1);
        m.addRes(res);
        if (res != 0) {
            this.notifyError(operation, "openCheck", res);
        }
        String[] str = RenderManager.renderingOperation(DeviceType.TreasurerKkm, operation, data);
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442:");
        if (str != null && str.length > 0 && !str[0].trim().isEmpty()) {
            this.printer.print(str[0].trim());
        }
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            for (int i = 0; i < this.scroll; ++i) {
                this.api.printText(" ");
            }
        }
        if ((commService = operation.getSumResult().getCommService()) != null) {
            String commServiceName = AppDefaults.getInstance().getProperty("sms.comm", this.bundle.getString("sms.comm"));
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430): " + commServiceName));
            res = this.api.addOperation((byte)0, commService.getBasicSum(), 1000, commService.getBasicSum(), (byte)0, 0, (byte)1, (byte)4, (byte)4, (byte)0, 0, commServiceName);
            m.addRes(res);
        }
        if (address != null) {
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u0435\u043b\u0435\u0444\u043e\u043d/\u0430\u0434\u0440\u0435\u0441 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f");
            int formRes = this.api.formPosition((byte)0);
            m.addRes(formRes);
            int reqRes = this.api.addReqesit((byte)0, 1, 0, TreasurerU.toTlv(1008, address.getBytes("cp866")));
            m.addRes(reqRes);
        }
        this.printTablePart(operation, data);
        int sumChange = KKMUtil.getSumChange(operation);
        if (sumChange > 0) {
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438");
            res = this.api.addOperation((byte)0, sumChange, 1000, sumChange, (byte)0, 0, (byte)1, (byte)4, (byte)1, (byte)0, 0, this.bundle.getString("change"));
            m.addRes(res);
            if (res != 0) {
                this.notifyError(operation, "addOperation", res);
            }
        }
        if (operation.getSumResult().getCash().getBasicSum() > 0) {
            cash = operation.getSumResult().getCash().getBasicSum();
            if (operation.getPaybackType() == 2) {
                cash -= operation.getChange().getSum().getBasicSum();
            }
            this.log.info((Object)("\u0412\u043d\u043e\u0441\u0438\u043c \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u0434\u0435\u043d\u044c\u0433\u0438: " + cash));
            res = this.api.calculationCheck((byte)0, (byte)1, cash);
            m.addRes(res);
            if (res != 0) {
                this.notifyError(operation, "calculationCheck", res);
            }
        } else if (operation.getSumResult().getCashLess().getBasicSum() > 0 && isCashless) {
            cash = operation.getSumResult().getCashLess().getBasicSum();
            this.log.info((Object)("\u0412\u043d\u043e\u0441\u0438\u043c \u0431\u0435\u0437\u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u0434\u0435\u043d\u044c\u0433\u0438: " + cash));
            res = this.api.calculationCheck((byte)0, (byte)2, cash);
            m.addRes(res);
            if (res != 0) {
                this.notifyError(operation, "calculationCheck", res);
            }
        }
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        res = this.api.closeCheck((byte)0, isCashless ? (byte)1 : 2, 0);
        m.addRes(res);
        if (res != 0) {
            this.notifyError(operation, "closeCheck", res);
        }
        if (str != null) {
            for (int i = 1; i < str.length; ++i) {
                if (str[i].trim().isEmpty()) continue;
                String string = str[i].trim();
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0447\u0435\u043a: " + string));
                this.printer.print(string);
                this.printer.scroll(4 + this.scroll);
                this.printer.partialCut();
                ThreadUtil.sleep((long)(i == str.length - 1 ? 0 : 2000));
            }
        }
    }

    private void printCashOnly(Operation operation, RenderData data) throws Exception {
        int i;
        this.log.info((Object)"\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0438 \u0441\u0443\u043c\u043c\u0430 \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f. \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438. \u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        String address = operation.geteCheckAddress();
        int res = this.openCheck(operation, (byte)0, (byte)1);
        m.addRes(res);
        if (res != 0) {
            this.notifyError(operation, "openCheck", res);
        }
        String[] str = RenderManager.renderingOperation(DeviceType.TreasurerKkm, operation, data);
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442:");
        if (str != null && str.length > 0 && !str[0].trim().isEmpty()) {
            this.printer.print(str[0].trim());
        }
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            for (i = 0; i < this.scroll; ++i) {
                this.api.printText(" ");
            }
        }
        if (address != null) {
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u0435\u043b\u0435\u0444\u043e\u043d/\u0430\u0434\u0440\u0435\u0441 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f");
            int formRes = this.api.formPosition((byte)0);
            m.addRes(formRes);
            int reqRes = this.api.addReqesit((byte)0, 1, 0, TreasurerU.toTlv(1008, address.getBytes("cp866")));
            m.addRes(reqRes);
        }
        if (operation.getSumResult().getCash().getBasicSum() > 0) {
            this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u0442\u0440\u043e\u043a\u0443");
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430)");
            int sum = operation.getSumResult().getCash().getBasicSum();
            res = this.api.addOperation((byte)0, sum, 1000, sum, (byte)0, 0, (byte)1, (byte)4, (byte)4, (byte)0, 0, operation.getService().getPrintName());
            m.addRes(res);
        }
        if (operation.getSumResult().getCash().getBasicSum() > 0) {
            this.log.info((Object)("\u0412\u043d\u043e\u0441\u0438\u043c \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u0434\u0435\u043d\u044c\u0433\u0438: " + operation.getSumResult().getCash()));
            res = this.api.calculationCheck((byte)0, (byte)1, operation.getSumResult().getCash().getBasicSum());
            m.addRes(res);
            if (res != 0) {
                this.notifyError(operation, "calculationCheck", res);
            }
        }
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        res = this.api.closeCheck((byte)0, (byte)1, 0);
        m.addRes(res);
        if (res != 0) {
            this.notifyError(operation, "closeCheck", res);
        }
        if (str != null) {
            for (i = 1; i < str.length; ++i) {
                if (str[i].trim().isEmpty()) continue;
                String string = str[i].trim();
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0447\u0435\u043a: " + string));
                this.printer.print(string);
                this.printer.scroll(4 + this.scroll);
                this.printer.partialCut();
                ThreadUtil.sleep((long)(i == str.length - 1 ? 0 : 2000));
            }
        }
    }

    private void printTablePart(Operation operation, RenderData data) throws IOException {
        if (operation instanceof GroupOperation) {
            Sum commService;
            int res;
            GroupOperation group = (GroupOperation)operation;
            int commDep = 1;
            if (data.isUseFiscalDepartments()) {
                commDep = 2;
            }
            if (group.getChildOperations() != null && group.getChildOperations().size() > 0) {
                this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u0443\u044e \u0447\u0430\u0441\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
                for (ChildOperation co : group.getChildOperations()) {
                    this.log.info((Object)("\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e \u043f\u043e\u0434\u0443\u0441\u043b\u0443\u0433\u0443: " + co));
                    int sum = co.getSumOutcome().getBasicSum();
                    res = this.api.addOperation((byte)0, sum, 1000, sum, (byte)0, 0, (byte)1, (byte)4, (byte)4, (byte)0, 0, co.getService().getPrintName());
                    m.addRes(res);
                }
            }
            if ((commService = operation.getSumResult().getCommService()) != null) {
                String commServiceName = AppDefaults.getInstance().getProperty("sms.comm", this.bundle.getString("sms.comm"));
                this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430): " + commServiceName));
                res = this.api.addOperation((byte)0, commService.getBasicSum(), 1000, commService.getBasicSum(), (byte)0, 0, (byte)1, (byte)4, (byte)4, (byte)0, 0, commServiceName);
                m.addRes(res);
            }
            if (operation.getSumResult().getCommission().getBasicSum() > 0) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043a\u043e\u043c\u043c\u0438\u0441\u0438\u044e");
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430)");
                int sum = operation.getSumResult().getCommission().getBasicSum();
                res = this.api.addOperation((byte)0, sum, 1000, sum, (byte)0, 0, (byte)commDep, (byte)4, (byte)4, (byte)0, 0, this.bundle.getString("comission"));
                m.addRes(res);
            }
        } else if (data.isUseFiscalDepartments()) {
            int res;
            int sum;
            if (operation.getSumResult().getOut().getBasicSum() > 0) {
                this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u0442\u0440\u043e\u043a\u0443");
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430)");
                sum = operation.getSumResult().getOut().getBasicSum();
                res = this.api.addOperation((byte)0, sum, 1000, sum, (byte)0, 0, (byte)1, (byte)4, (byte)4, (byte)0, 0, operation.getService().getPrintName());
                m.addRes(res);
            }
            if (operation.getSumResult().getCommission().getBasicSum() > 0) {
                this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u0442\u0440\u043e\u043a\u0443");
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430)");
                sum = operation.getSumResult().getCommission().getBasicSum();
                res = this.api.addOperation((byte)0, sum, 1000, sum, (byte)0, 0, (byte)2, (byte)4, (byte)4, (byte)0, 0, this.bundle.getString("comission"));
                m.addRes(res);
            }
        } else if (operation.getSumResult().getOut().getBasicSum() + operation.getSumResult().getCommission().getBasicSum() > 0) {
            this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u0442\u0440\u043e\u043a\u0443");
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430)");
            int sum = operation.getSumResult().getOut().getBasicSum() + operation.getSumResult().getCommission().getBasicSum();
            int res = this.api.addOperation((byte)0, sum, 1000, sum, (byte)0, 0, (byte)1, (byte)4, (byte)4, (byte)0, 0, operation.getService().getPrintName());
            m.addRes(res);
        }
    }
}

