/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.tfa;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.TfaAnswer;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class TfaConnection {
    private static final byte[] START = new byte[]{BU.c((int)182), 41};
    private static final int TIMEOUT_T1 = 1500;
    private final SerialPort port;
    private Logger log;
    private int readAttempts = 5;
    private int attempts = 3;

    public TfaConnection(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043a\u043e\u043c-\u043f\u043e\u0440\u0442\u0435");
        }
        this.port = port;
        this.log = Logger.getLogger((String)"print");
    }

    public synchronized TfaAnswer sendCommand(int cmd, byte[] data) throws IOException {
        return this.sendCommand(cmd, data, null, true);
    }

    public synchronized TfaAnswer sendCommand(int cmd, byte[] data, Integer timeout) throws IOException {
        return this.sendCommand(cmd, data, timeout, true);
    }

    public synchronized TfaAnswer sendCommand(int cmd, byte[] data, Integer timeout, boolean readAnswer) throws IOException {
        IOException last = null;
        long start = System.currentTimeMillis();
        byte[] message = this.getData(BU.c((int)cmd), data);
        this.log.debug((Object)("message: " + ByteUtils.toString(message)));
        for (int i = 0; i < this.attempts; ++i) {
            try {
                this.log.debug((Object)("\u0426\u0438\u043a\u043b \u043e\u0431\u043c\u0435\u043d\u0430: " + i));
                this.port.flush(Flush.RxTx);
                this.sendData(message);
                if (readAnswer) {
                    TfaAnswer answer = this.readData(timeout == null ? 1500 : timeout);
                    this.log.debug((Object)("*** \u0412\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b+ " + cmd + "(" + String.format("0x%02x", cmd) + "): " + (System.currentTimeMillis() - start) + " ms"));
                    return answer;
                }
                this.log.debug((Object)("*** \u0412\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b- " + cmd + "(" + String.format("0x%02x", cmd) + "): " + (System.currentTimeMillis() - start) + " ms"));
                return null;
            }
            catch (IOException ex) {
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043c\u0435\u043d\u0435: " + ex.getMessage()));
                last = ex;
                this.port.reopen();
                continue;
            }
        }
        throw new IOException(last);
    }

    private void sendData(byte[] data) throws IOException {
        IOException last = null;
        this.port.flush(Flush.RxTx);
        boolean flag = false;
        for (int i = 0; i < this.readAttempts; ++i) {
            try {
                this.port.setTimeout(1500);
                this.log.debug((Object)(">>" + ByteUtils.toString(data)));
                this.port.write(data);
                flag = true;
                break;
            }
            catch (IOException ex) {
                last = ex;
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043c\u0435\u043d\u0435 \u0434\u0430\u043d\u043d\u044b\u043c\u0438[\u0437\u0430\u043f\u0438\u0441\u044c \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b]", (Throwable)ex);
                continue;
            }
        }
        if (!flag) {
            this.log.error((Object)("\u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0437\u0430 " + this.readAttempts + " \u043f\u043e\u043f\u044b\u0442\u043e\u043a, \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u044e \u0441\u0435\u0430\u043d\u0441"));
            throw new IOException("\u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0437\u0430 " + this.readAttempts + " \u043f\u043e\u043f\u044b\u0442\u043e\u043a, \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u044e \u0441\u0435\u0430\u043d\u0441", last);
        }
    }

    private TfaAnswer readData(int timeout) throws IOException {
        this.log.debug((Object)"\u041e\u0436\u0438\u0434\u0430\u0435\u043c START");
        this.port.setTimeout(timeout);
        byte[] ans = new byte[]{0, 0};
        boolean fl = false;
        long start = System.currentTimeMillis();
        for (int j = 0; j < 20; ++j) {
            ans = this.port.read(2);
            if (ans[0] == START[0] && ans[1] == START[1]) {
                this.log.debug((Object)"<<START");
                fl = true;
            } else {
                this.log.debug((Object)("<< \u043c\u0443\u0441\u043e\u0440=" + String.format("0x%02x 0x%02x", ans[0], ans[1])));
            }
            if (System.currentTimeMillis() - start > (long)timeout || fl) break;
        }
        if (ans[0] != START[0] || ans[1] != START[1]) {
            throw new IOException("\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f START, \u043f\u043e\u043b\u0443\u0447\u0435\u043d " + BU.toHexString((byte[])ans));
        }
        this.log.debug((Object)"\u041e\u0436\u0438\u0434\u0430\u0435\u043c length");
        ans = this.port.read(2);
        int length = (BU.c((byte)ans[0]) << 8) + BU.c((byte)ans[1]);
        this.log.debug((Object)("\u0420\u0430\u0437\u043c\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445: " + length));
        this.log.debug((Object)("<<" + BU.toHexString((byte[])ans)));
        if (length < 1) {
            throw new IOException("\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u0430\u043b\u0435\u043d\u044c\u043a\u0438\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445: " + length);
        }
        byte[] check = new byte[length + 2];
        check[0] = ans[0];
        check[1] = ans[1];
        int resultCode = this.port.readByte();
        check[2] = BU.c((int)resultCode);
        this.log.debug((Object)("<<resCode " + resultCode));
        byte[] result = new byte[]{-1};
        if (length > 1) {
            result = this.port.read(length - 1);
            this.log.debug((Object)("<<result " + BU.toHexString((byte[])result)));
            System.arraycopy(result, 0, check, 3, length - 1);
        }
        ans = this.port.read(2);
        this.log.debug((Object)("<<crc " + BU.toHexString((byte[])ans)));
        if (!this.checkCrc(check, ans)) {
            throw new IOException("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u0430");
        }
        if (resultCode == 0 || length == 1) {
            return new TfaAnswer(resultCode, result);
        }
        return new TfaAnswer(result[0], null);
    }

    public void setReadAttempts(int readAttempts) {
        this.readAttempts = readAttempts;
    }

    public synchronized void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    private byte[] getData(byte cmd, byte[] data) {
        int length = data == null ? 1 : data.length + 1;
        byte[] d = new byte[2 + length];
        d[0] = BU.c((int)(length >> 8));
        d[1] = BU.c((int)length);
        d[2] = cmd;
        if (data != null) {
            System.arraycopy(data, 0, d, 3, data.length);
        }
        byte[] result = new byte[d.length + 4];
        int crc = this.makeCrc16CCITT(d);
        System.arraycopy(d, 0, result, 2, d.length);
        result[0] = START[0];
        result[1] = START[1];
        result[result.length - 2] = BU.c((int)crc);
        result[result.length - 1] = BU.c((int)(crc >> 8));
        return result;
    }

    private int makeCrc16CCITT(byte[] data) {
        int crc = 65535;
        if (data == null) {
            return crc;
        }
        int polynomial = 4129;
        for (byte b : data) {
            for (int i = 0; i < 8; ++i) {
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (!(c15 ^ bit)) continue;
                crc ^= polynomial;
            }
        }
        return crc &= 0xFFFF;
    }

    private boolean checkCrc(byte[] data, byte[] inpCrc) {
        if (data == null || inpCrc == null || inpCrc.length != 2) {
            return false;
        }
        int crc = this.makeCrc16CCITT(data);
        return inpCrc[0] == BU.c((int)crc) && inpCrc[1] == BU.c((int)(crc >> 8));
    }
}

