/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.tfa;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.kkm.tfa.TfaConnection;
import ru.softlogic.hardware.device.print.kkm.tfa.TfaU;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.CheckResult;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.FDResult;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.FSState;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.FSValidity;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.OFDConfirmResult;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.PrintParams;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.RegistrationParams;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.SessionParams;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.SessionResult;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.TfaAnswer;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.TfaReportResult;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.TfaResult;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.TfaState;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.TlvReqAnswer;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;
import ru.softlogic.system.util.ArrayUtils;

public class TfaApi
implements SerialDeviceApi {
    public static final String CHARSET = "CP866";
    public static final int OK = 0;
    public static final int VAT_18 = 1;
    public static final int VAT_10 = 2;
    public static final int VAT_18_118 = 3;
    public static final int VAT_10_110 = 4;
    public static final int VAT_0 = 5;
    public static final int VAT_NONE = 6;
    public static final int TM_COMMON = 1;
    public static final int TM_SIMPLIFIED_INCOME = 2;
    public static final int TM_SIMPLIFIED_INCOME_FLOW = 4;
    public static final int TM_SINGLE_IMPUTED_INCOME = 8;
    public static final int TM_SINGLE_AGRICULTURAL = 16;
    public static final int TM_PATENT_SYSTEM = 32;
    public static final int CM_COMING = 1;
    public static final int CM_RETURN_COMING = 2;
    public static final int CM_CONSUMPTION = 3;
    public static final int CM_RETURN_CONSUMPTION = 4;
    public static final int T_CM_FULL_PREPAYMENT = 1;
    public static final int T_CM_FULL_PAYMENT = 4;
    private Map<Boolean, SerialParams[]> serialParams;
    private SerialPort serialPort;
    private TfaConnection conn;

    public TfaApi(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.serialPort = port;
        this.conn = new TfaConnection(port);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)});
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return (SerialParams[])ArrayUtils.arrayMerge((Object[][])new SerialParams[][]{this.serialParams.get(true), this.serialParams.get(false)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        this.conn.setAttempts(1);
        this.conn.setReadAttempts(1);
        for (SerialParams params : this.serialParams.get(preferred)) {
            try {
                this.serialPort.putParams(params);
                this.open();
                this.getModel();
                DeviceType deviceType = this.getDeviceType();
                return deviceType;
            }
            catch (IOException iOException) {
            }
            finally {
                this.close();
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.TfaKkm;
    }

    @Override
    public void open() throws IOException {
        this.serialPort.open();
        this.serialPort.setFlow(Flow.None);
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    public TfaResult<TfaState> getStatus() throws IOException {
        TfaAnswer result = this.conn.sendCommand(1, null);
        if (result.getErrorCode() == 0) {
            TfaState state = new TfaState();
            state.setFactoryNamber(new String(Arrays.copyOf(result.getData(), 12), CHARSET));
            state.setDate(TfaU.getDate(Arrays.copyOfRange(result.getData(), 12, 17)));
            state.setCriticalError(BU.c((byte)result.getData()[17]) == 1);
            state.setPrinterStatus(BU.c((byte)result.getData()[18]));
            return new TfaResult<TfaState>(state);
        }
        return new TfaResult<TfaState>(result.getErrorCode());
    }

    public TfaResult<String> getFactoryNamber() throws IOException {
        return this.getStringAnswer(2);
    }

    public TfaResult<String> getSoftwareVersion() throws IOException {
        return this.getStringAnswer(3);
    }

    public TfaResult<String> getModel() throws IOException {
        return this.getStringAnswer(4);
    }

    public TfaResult<String> getFSFactoryNamber() throws IOException {
        return this.getStringAnswer(5);
    }

    public TfaResult<String> getFSSoftwareVersion() throws IOException {
        return this.getStringAnswer(6);
    }

    public TfaResult<FSValidity> getFSValidity() throws IOException {
        TfaAnswer result = this.conn.sendCommand(7, null);
        if (result.getErrorCode() == 0) {
            FSValidity fsv = new FSValidity();
            fsv.setValidity(TfaU.getDate(Arrays.copyOf(result.getData(), 3)));
            fsv.setAvaliableReregistration(BU.c((byte)result.getData()[3]));
            fsv.setCarriedOutReregistration(BU.c((byte)result.getData()[4]));
            return new TfaResult<FSValidity>(fsv);
        }
        return new TfaResult<FSValidity>(result.getErrorCode());
    }

    public TfaResult<FSState> getFSState() throws IOException {
        TfaAnswer result = this.conn.sendCommand(8, null);
        if (result.getErrorCode() == 0) {
            FSState fss = new FSState();
            fss.setState(result.getData()[0]);
            fss.setCurrentDoc(result.getData()[1]);
            fss.setSendDocData(BU.c((byte)result.getData()[2]) == 1);
            fss.setOpenSession(BU.c((byte)result.getData()[3]) == 1);
            fss.setFlags(result.getData()[4]);
            fss.setLastDocDate(TfaU.getDate(Arrays.copyOfRange(result.getData(), 5, 10)));
            fss.setFsNumber(new String(Arrays.copyOfRange(result.getData(), 10, 26), CHARSET));
            fss.setLastFDNumber(TfaU.cuile(result.getData(), 26));
            return new TfaResult<FSState>(fss);
        }
        return new TfaResult<FSState>(result.getErrorCode());
    }

    public TfaResult<byte[]> getLastErrors() throws IOException {
        TfaAnswer result = this.conn.sendCommand(9, null);
        if (result.getErrorCode() == 0) {
            return new TfaResult<byte[]>(result.getData());
        }
        return new TfaResult<byte[]>(result.getErrorCode());
    }

    public TfaResult<RegistrationParams> getRegistrationParams() throws IOException {
        TfaAnswer result = this.conn.sendCommand(10, null);
        if (result.getErrorCode() == 0) {
            RegistrationParams rp = new RegistrationParams();
            rp.setRnKkt(new String(Arrays.copyOf(result.getData(), 16), CHARSET));
            rp.setInn(new String(Arrays.copyOfRange(result.getData(), 16, 32), CHARSET));
            rp.setKktMode(result.getData()[32]);
            rp.setTaxMode(result.getData()[33]);
            rp.setPaymentAgentMode(result.getData()[34]);
            return new TfaResult<RegistrationParams>(rp);
        }
        return new TfaResult<RegistrationParams>(result.getErrorCode());
    }

    private TfaResult<String> getStringAnswer(int cmd) throws IOException {
        TfaAnswer result = this.conn.sendCommand(cmd, null);
        if (result.getErrorCode() == 0) {
            return new TfaResult<String>(new String(result.getData(), CHARSET));
        }
        return new TfaResult<String>(result.getErrorCode());
    }

    public TfaResult<SessionParams> getSessionParams() throws IOException {
        TfaAnswer result = this.conn.sendCommand(32, null);
        if (result.getErrorCode() == 0) {
            SessionParams sp = new SessionParams();
            sp.setOpen(BU.c((byte)result.getData()[0]) == 1);
            sp.setNumber(TfaU.cusle(result.getData(), 1));
            sp.setCheckNumber(TfaU.cusle(result.getData(), 3));
            return new TfaResult<SessionParams>(sp);
        }
        return new TfaResult<SessionParams>(result.getErrorCode());
    }

    public int startOpenSession() throws IOException {
        return this.conn.sendCommand(33, null).getErrorCode();
    }

    public int startOpenSession(boolean printReport) throws IOException {
        return this.conn.sendCommand(33, new byte[]{BU.c((int)(printReport ? 0 : 1))}).getErrorCode();
    }

    public TfaResult<SessionResult> openSession() throws IOException {
        return this.ocSession(34);
    }

    public int startCloseSession() throws IOException {
        return this.conn.sendCommand(41, null).getErrorCode();
    }

    public int startCloseSession(boolean printReport) throws IOException {
        return this.conn.sendCommand(41, new byte[]{BU.c((int)(printReport ? 0 : 1))}).getErrorCode();
    }

    public TfaResult<SessionResult> closeSession() throws IOException {
        return this.ocSession(42);
    }

    private TfaResult<SessionResult> ocSession(int cmd) throws IOException {
        TfaAnswer result = this.conn.sendCommand(cmd, null);
        if (result.getErrorCode() == 0) {
            SessionResult sr = new SessionResult();
            sr.setNumber(TfaU.cusle(result.getData(), 0));
            sr.setNumberFD(TfaU.cuile(result.getData(), 2));
            sr.setFiscalFlag(TfaU.cuile(result.getData(), 6));
            return new TfaResult<SessionResult>(sr);
        }
        return new TfaResult<SessionResult>(result.getErrorCode());
    }

    public int cancelCurrentFD() throws IOException {
        return this.conn.sendCommand(16, null).getErrorCode();
    }

    public int openCheck() throws IOException {
        return this.conn.sendCommand(35, null).getErrorCode();
    }

    public int addOperation(String name, int price, int count, int vatRate, int calcMethodFlag) throws IOException {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        data.add(TfaU.generateTLV(1030, name.getBytes(CHARSET)));
        data.add(TfaU.generateTLV(1079, TfaU.generateVLNle(price)));
        data.add(TfaU.generateTLV(1023, TfaU.generateFVLNle(count)));
        data.add(TfaU.generateTLV(1199, new byte[]{BU.c((int)vatRate)}));
        data.add(TfaU.generateTLV(1214, new byte[]{BU.c((int)calcMethodFlag)}));
        return this.conn.sendCommand(43, TfaU.generateSTLV(1059, data)).getErrorCode();
    }

    public int addAgentInfo(int pAgent, String aPhone, String agentOpName, String providerPhone, String providerName, String providerInn, String providerAddress, String sPhone) throws IOException {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        data.add(TfaU.generateTLV(1057, new byte[]{BU.c((int)pAgent)}));
        data.add(TfaU.generateTLV(1073, aPhone.replaceAll(",.*", "").replaceAll("\\D", "").getBytes(CHARSET)));
        data.add(TfaU.generateTLV(1044, agentOpName.getBytes(CHARSET)));
        data.add(TfaU.generateTLV(1074, providerPhone.replaceAll("\\D", "").getBytes(CHARSET)));
        data.add(TfaU.generateTLV(1026, providerName.getBytes(CHARSET)));
        String inn = String.format("%-12s", providerInn.replaceAll("\\D", ""));
        data.add(TfaU.generateTLV(1016, inn.replaceAll("\\D", "").getBytes(CHARSET)));
        data.add(TfaU.generateTLV(1005, providerAddress.getBytes(CHARSET)));
        data.add(TfaU.generateTLV(1075, providerPhone.replaceAll("\\D", "").getBytes(CHARSET)));
        data.add(TfaU.generateTLV(1171, sPhone.replaceAll("\\D", "").getBytes(CHARSET)));
        return this.conn.sendCommand(44, TfaU.merge(data)).getErrorCode();
    }

    public int addPaymentData(int taxMode, int cash, int cashless, String mail) throws IOException {
        return this.addPaymentData(BU.c((int)taxMode), cash, cashless, 0, 0, 0, mail);
    }

    public int addPaymentData(int taxMode, int cash, int cashless, int prepay, int postpay, int counterProvision, String mail) throws IOException {
        byte[] m2 = mail == null || mail.trim().isEmpty() ? null : mail.getBytes(CHARSET);
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        data.add(TfaU.generateTLV(1055, new byte[]{BU.c((int)taxMode)}));
        data.add(TfaU.generateTLV(1031, TfaU.generateVLNle(cash)));
        data.add(TfaU.generateTLV(1081, TfaU.generateVLNle(cashless)));
        data.add(TfaU.generateTLV(1215, TfaU.generateVLNle(prepay)));
        data.add(TfaU.generateTLV(1216, TfaU.generateVLNle(postpay)));
        data.add(TfaU.generateTLV(1217, TfaU.generateVLNle(counterProvision)));
        data.add(TfaU.generateTLV(1008, m2));
        return this.conn.sendCommand(45, TfaU.merge(data)).getErrorCode();
    }

    public TfaResult<CheckResult> closeCheck(int calcMethodFlag, long checkTotal, String additionalInfo) throws IOException {
        TfaAnswer result;
        byte[] m2 = additionalInfo == null || additionalInfo.trim().isEmpty() ? null : additionalInfo.getBytes(CHARSET);
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        data.add(new byte[]{BU.c((int)calcMethodFlag)});
        data.add(TfaU.clle(checkTotal, 5));
        if (m2 != null) {
            data.add(m2);
        }
        if ((result = this.conn.sendCommand(36, TfaU.merge(data), 20000)).getErrorCode() == 0) {
            CheckResult cr = new CheckResult();
            cr.setNumber(TfaU.cusle(result.getData(), 0));
            cr.setNumberFD(TfaU.cuile(result.getData(), 2));
            cr.setFiscalFlag(TfaU.cuile(result.getData(), 6));
            return new TfaResult<CheckResult>(cr);
        }
        return new TfaResult<CheckResult>(result.getErrorCode());
    }

    public int openCorrectionCheck() throws IOException {
        return this.conn.sendCommand(37, null).getErrorCode();
    }

    public int addCorrectionOperation(String fio, byte correctionType, byte vatRate, int cash, int cashless, int prepay, int postpay, int counterProvision, String docName, Date docDate, String docNumber) throws IOException {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        ArrayList<byte[]> data2 = new ArrayList<byte[]>();
        data.add(TfaU.generateTLV(1021, fio.getBytes(CHARSET)));
        data.add(TfaU.generateTLV(1173, new byte[]{correctionType}));
        data2.add(TfaU.generateTLV(1177, docName.getBytes(CHARSET)));
        data2.add(TfaU.generateTLV(1178, TfaU.generateUT(docDate)));
        data2.add(TfaU.generateTLV(1179, docNumber.getBytes(CHARSET)));
        data.add(TfaU.generateSTLV(1174, data2));
        data.add(TfaU.generateTLV(1055, new byte[]{vatRate}));
        data.add(TfaU.generateTLV(1031, TfaU.generateVLNle(cash)));
        data.add(TfaU.generateTLV(1081, TfaU.generateVLNle(cashless)));
        data.add(TfaU.generateTLV(1215, TfaU.generateVLNle(prepay)));
        data.add(TfaU.generateTLV(1216, TfaU.generateVLNle(postpay)));
        data.add(TfaU.generateTLV(1217, TfaU.generateVLNle(counterProvision)));
        return this.conn.sendCommand(46, TfaU.merge(data)).getErrorCode();
    }

    public TfaResult<CheckResult> closeCorrectionCheck(byte calcMethodFlag, byte vatRate, int price) throws IOException {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        data.add(new byte[]{calcMethodFlag});
        data.add(new byte[]{vatRate});
        data.add(TfaU.generateVLNle(price));
        TfaAnswer result = this.conn.sendCommand(38, TfaU.merge(data));
        if (result.getErrorCode() == 0) {
            CheckResult cr = new CheckResult();
            cr.setNumber(TfaU.cusle(result.getData(), 0));
            cr.setNumberFD(TfaU.cuile(result.getData(), 2));
            cr.setFiscalFlag(TfaU.cuile(result.getData(), 6));
            return new TfaResult<CheckResult>(cr);
        }
        return new TfaResult<CheckResult>(result.getErrorCode());
    }

    public int startSettlementStatusReport() throws IOException {
        return this.conn.sendCommand(39, null).getErrorCode();
    }

    public TfaResult<TfaReportResult> generateSettlementStatusReport() throws IOException {
        TfaAnswer result = this.conn.sendCommand(40, null);
        if (result.getErrorCode() == 0) {
            TfaReportResult rr = new TfaReportResult();
            rr.setNumberFD(TfaU.cuile(result.getData(), 0));
            rr.setFiscalFlag(TfaU.cuile(result.getData(), 4));
            rr.setUnconfirmedDocCount(TfaU.cuile(result.getData(), 8));
            rr.setFirstUnconfirmedDocDate(TfaU.getDate(Arrays.copyOfRange(result.getData(), 9, 12)));
            return new TfaResult<TfaReportResult>(rr);
        }
        return new TfaResult<TfaReportResult>(result.getErrorCode());
    }

    public TfaResult<FDResult> getFD(long numberFD) throws IOException {
        TfaAnswer result = this.conn.sendCommand(48, TfaU.clle(numberFD, 4));
        if (result.getErrorCode() == 0) {
            FDResult fdr = new FDResult();
            fdr.setType(result.getData()[0]);
            fdr.setCheckOFD(result.getData()[1] == 1);
            fdr.setFdData(Arrays.copyOfRange(result.getData(), 2, result.getData().length));
            return new TfaResult<FDResult>(fdr);
        }
        return new TfaResult<FDResult>(result.getErrorCode());
    }

    public int printFD(long numberFD) throws IOException {
        return this.conn.sendCommand(57, TfaU.clle(numberFD, 4)).getErrorCode();
    }

    public TfaResult<OFDConfirmResult> printConfirmOFD(long numberFD) throws IOException {
        TfaAnswer result = this.conn.sendCommand(49, TfaU.clle(numberFD, 4));
        if (result.getErrorCode() == 0) {
            OFDConfirmResult ofdcr = new OFDConfirmResult();
            ofdcr.setConfirmDate(TfaU.getDate(Arrays.copyOfRange(result.getData(), 0, 5)));
            ofdcr.setFiscalFlagOFD(Arrays.copyOfRange(result.getData(), 2, 20));
            ofdcr.setNumberFD(TfaU.cuile(result.getData(), 20));
            return new TfaResult<OFDConfirmResult>(ofdcr);
        }
        return new TfaResult<OFDConfirmResult>(result.getErrorCode());
    }

    public TfaResult<Integer> getUnconfirmFD() throws IOException {
        TfaAnswer result = this.conn.sendCommand(50, null);
        if (result.getErrorCode() == 0) {
            return new TfaResult<Integer>(0, TfaU.cusle(result.getData(), 0));
        }
        return new TfaResult<Integer>(result.getErrorCode());
    }

    public TfaResult<TlvReqAnswer> requestFdTlv(long numberFd) throws IOException {
        TfaAnswer result = this.conn.sendCommand(53, TfaU.clle(numberFd, 4));
        if (result.getErrorCode() == 0) {
            TlvReqAnswer ans = new TlvReqAnswer();
            ans.setTypeFd(BU.csle((byte[])result.getData(), (int)0));
            ans.setLengthFd(BU.csle((byte[])result.getData(), (int)2));
            return new TfaResult<TlvReqAnswer>(ans);
        }
        return new TfaResult<TlvReqAnswer>(result.getErrorCode());
    }

    public int printText(int fontParams, int alignment, String text) throws IOException {
        byte[] data = new byte[text.length() + 2];
        data[0] = BU.c((int)fontParams);
        data[1] = BU.c((int)alignment);
        System.arraycopy(text.getBytes(CHARSET), 0, data, 2, text.length());
        return this.conn.sendCommand(97, data).getErrorCode();
    }

    public int cut() throws IOException {
        return this.conn.sendCommand(98, null).getErrorCode();
    }

    public TfaResult<Date> getDate() throws IOException {
        TfaAnswer result = this.conn.sendCommand(115, null);
        if (result.getErrorCode() == 0) {
            return new TfaResult<Date>(TfaU.getDate(Arrays.copyOfRange(result.getData(), 4, 9)));
        }
        return new TfaResult<Date>(result.getErrorCode());
    }

    public int setDate(Date date) throws IOException {
        return this.conn.sendCommand(114, TfaU.getDate(date)).getErrorCode();
    }

    public TfaResult<PrintParams> getPrintParams() throws IOException {
        TfaAnswer result = this.conn.sendCommand(121, null);
        if (result.getErrorCode() == 0) {
            PrintParams pp = new PrintParams();
            pp.setFontSize(result.getData()[4]);
            pp.setRetract(result.getData()[9] == 1);
            pp.setAdditionalText(new String(Arrays.copyOfRange(result.getData(), 14, result.getData().length), CHARSET));
            return new TfaResult<PrintParams>(pp);
        }
        return new TfaResult<PrintParams>(result.getErrorCode());
    }

    public int setPrintParams(int fontSize, boolean retract, String additionalText) throws IOException {
        byte[] at = additionalText == null || additionalText.trim().isEmpty() ? null : additionalText.getBytes(CHARSET);
        int r = retract ? 1 : 0;
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        data.add(TfaU.generateTLV(30015, new byte[]{BU.c((int)fontSize)}));
        data.add(TfaU.generateTLV(30018, new byte[]{BU.c((int)r)}));
        data.add(TfaU.generateTLV(30017, at));
        return this.conn.sendCommand(120, TfaU.merge(data)).getErrorCode();
    }

    public SerialPort getPort() {
        return this.serialPort;
    }

    public int scroll(int cnt) throws IOException {
        int res = 0;
        for (int i = 0; i < cnt; ++i) {
            res = this.printText(0, 0, " ");
        }
        return res;
    }
}

