/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.shtrih;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.Tags;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.api.BasePrinterApi;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.hardware.proto.shtihm.Api;
import ru.softlogic.hardware.proto.shtihm.Info;
import ru.softlogic.hardware.proto.shtihm.Result;
import ru.softlogic.hardware.proto.shtihm.Status;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.ThreadUtil;

public class ShtrihPrinter
extends BasePrinterApi {
    private Api api;
    private Logger log;
    protected Map<Tags, String> tags;
    private Info info;

    public ShtrihPrinter(SerialPort port) {
        this(new Api(port));
    }

    public ShtrihPrinter(Api api) {
        if (api == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Api");
        }
        this.api = api;
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.tags = new EnumMap<Tags, String>(Tags.class);
        this.tags.put(Tags.BoldBegin, "");
        this.tags.put(Tags.BoldEnd, "");
        this.tags.put(Tags.UnderLineBegin, "");
        this.tags.put(Tags.UnderLineEnd, "");
        this.tags.put(Tags.AlignCenter, "");
        this.tags.put(Tags.AlignLeft, "");
        this.tags.put(Tags.AlignRight, "");
        this.tags.put(Tags.SmallBegin, "");
        this.tags.put(Tags.SmallEnd, "");
        this.tags.put(Tags.Br, "\n");
    }

    @Override
    public void init(PosPrinterOptions options) throws IOException {
        this.log.info((Object)("\u0417\u0430\u0445\u0432\u0430\u0442\u0438\u0442\u044c \u0447\u0435\u043a: " + this.api.outCheck(true)));
    }

    @Override
    public void print(String text) throws IOException {
        this.print(text, 0);
    }

    @Override
    public String getFirmware() {
        return "n/a";
    }

    public void print(String text, int total) throws IOException {
        if (total < 0) {
            throw new IllegalArgumentException("Total \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c");
        }
        if (text != null && !text.isEmpty()) {
            if (this.info == null) {
                this.info = this.api.getInfo().getData();
            }
            for (Tags tag : Tags.values()) {
                String data = this.tags.get((Object)tag);
                text = text.replace(tag.getString(), data == null ? "" : data);
            }
            Matcher m2 = Pattern.compile(".{1,40}").matcher(text);
            int i = 0;
            while (m2.find()) {
                String prn = m2.group(0);
                if (prn.length() < 40) {
                    prn = prn.trim();
                }
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u044e \u0441\u0442\u0440\u043e\u043a\u0443: " + prn + ", res=" + this.api.printString(prn, false)));
                ++i;
            }
            this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d\u043e \u0441\u0442\u0440\u043e\u043a: " + i));
            if (this.info != null && this.info.getModel() == 15) {
                this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u043d\u0430 " + (22 - i - total)));
                for (int j = 0; j < 22 - i - total; ++j) {
                    this.api.printString("          ", false);
                }
            }
        }
    }

    @Override
    public void scroll(int scroll) throws IOException {
        this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u043d\u0430 " + scroll));
        if (scroll > 0) {
            for (int j = 0; j < scroll; ++j) {
                this.api.printString("          ", false);
            }
        }
    }

    @Override
    public void fullCut() throws IOException {
        this.api.cut(true);
        ThreadUtil.sleep((long)700L);
        this.log.info((Object)("\u0412\u044b\u0434\u0430\u0447\u0430 \u0447\u0435\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u0441 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u043c: " + this.api.outCheck(false)));
    }

    @Override
    public void partialCut() throws IOException {
        this.api.cut(false);
        ThreadUtil.sleep((long)700L);
        this.log.info((Object)("\u0412\u044b\u0434\u0430\u0447\u0430 \u0447\u0435\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u0441 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u043c: " + this.api.outCheck(false)));
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        Result<Status> yr = this.api.getShortStatus();
        PrinterStatus printerStatus = new PrinterStatus();
        if (yr.isOk()) {
            Status status = yr.getData();
            printerStatus.setPaperNearEnd((status.getFlags() & 2) == 0);
            printerStatus.setPaperEnd((status.getFlags() & 0x80) == 0);
        } else {
            this.log.error((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430: " + yr.isOk()));
            printerStatus.setError(true);
        }
        return printerStatus;
    }

    @Override
    public int getModelId() throws IOException {
        return 0;
    }

    @Override
    public Port getConnection() {
        return this.api.getPort();
    }

    @Override
    public String getVendor() {
        return "\u0428\u0442\u0440\u0438\u0445-\u041c";
    }

    @Override
    public String getModel() {
        return "n/a";
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void dispense(int steps) throws IOException {
    }
}

