/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.shtrih;

import java.io.IOException;
import java.util.Date;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.kkm.BaseKkm;
import ru.softlogic.hardware.device.print.kkm.KkmControl;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.kkm.shtrih.ShtrihPrinter;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderFactory;
import ru.softlogic.hardware.device.print.render2.RenderManager;
import ru.softlogic.hardware.device.print.render2.mc.MoneyCollectionRender;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.hardware.proto.shtihm.Api;
import ru.softlogic.hardware.proto.shtihm.Helper;
import ru.softlogic.hardware.proto.shtihm.Info;
import ru.softlogic.hardware.proto.shtihm.LongStatus;
import ru.softlogic.hardware.proto.shtihm.Result;
import ru.softlogic.hardware.proto.shtihm.Status;
import ru.softlogic.hardware.proto.shtihm.m;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.connector.ZReportInfo;
import ru.softlogic.system.util.ThreadUtil;

public class ShtrihKkm
extends BaseKkm {
    protected Api api;
    private ShtrihPrinter shtrihPrinter;
    protected Logger log;
    private ResourceBundle bundle;
    private Info kkmInfo;
    private LongStatus longStatus;
    private DeviceInfo deviceInfo;
    private KkmOptions options;
    private int scroll;
    private Status lastStatus;
    private LongStatus lastLongStatus;
    private boolean globalError;
    private KkmControl control;

    public ShtrihKkm(SerialPort port, KkmOptions options, KkmControl control) {
        super(DeviceType.ShtrihKkm, port, options);
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        if (options == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 KkmOptions");
        }
        if (control == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 KkmControl");
        }
        this.options = options;
        this.api = new Api(port);
        this.control = control;
        this.shtrihPrinter = new ShtrihPrinter(this.api);
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        if (options.getAdminPassword() != null && options.getAdminPassword().matches("^\\d+$")) {
            this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0430\u0440\u043e\u043b\u044c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430: " + options.getAdminPassword()));
            this.api.setAdministratorPassword(Integer.parseInt(options.getAdminPassword()));
        } else {
            this.log.info((Object)"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043f\u0430\u0440\u043e\u043b\u044c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430 \u043f\u043e-\u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        }
        if (options.getOperatorPassword() != null && options.getOperatorPassword().matches("^\\d+$")) {
            this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0430\u0440\u043e\u043b\u044c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: " + options.getOperatorPassword()));
            this.api.setOperatorPassword(Integer.parseInt(options.getOperatorPassword()));
        } else {
            this.log.info((Object)"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043f\u0430\u0440\u043e\u043b\u044c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u043f\u043e-\u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        }
        this.bundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.print.kkm.kkm");
        this.deviceInfo = new DeviceInfo(DeviceType.ShtrihKkm);
        this.deviceInfo.setVendor("\u0428\u0442\u0440\u0438\u0445-\u041c");
        this.deviceInfo.setPort(port.getName());
        if (options.getScroll() != null && options.getScroll() > 0) {
            this.scroll = options.getScroll();
        }
    }

    private Info getKkmInfo() throws IOException {
        if (this.kkmInfo == null) {
            Result<Info> yr = this.api.getInfo();
            if (yr.isOk()) {
                this.kkmInfo = yr.getData();
                this.log.info((Object)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u041a\u041a\u041c:");
                this.log.info((Object)("    \u041c\u043e\u0434\u0435\u043b\u044c: " + this.kkmInfo.getModel()));
                this.log.info((Object)("    \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: " + this.kkmInfo.getName()));
                this.log.info((Object)("    \u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b: " + this.kkmInfo.getProto() + "." + this.kkmInfo.getSubproto()));
                this.log.info((Object)("    \u0422\u0438\u043f: " + this.kkmInfo.getType() + "." + this.kkmInfo.getSubtype()));
                this.deviceInfo.setModel(this.kkmInfo.getName() + ",id=" + this.kkmInfo.getModel());
                this.deviceInfo.setProto(this.kkmInfo.getProto() + "." + this.kkmInfo.getSubproto());
            } else {
                this.log.error((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043a\u043a\u043c: " + yr.getError()));
            }
        }
        return this.kkmInfo;
    }

    private LongStatus getLongStatus() throws IOException {
        if (this.longStatus == null) {
            Result<LongStatus> yr = this.api.getLongStatus();
            if (yr.isOk()) {
                this.longStatus = yr.getData();
                this.log.info((Object)"\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441:");
                this.log.info((Object)("    \u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438     : " + this.longStatus.getSoftwareVersionFm()));
                this.log.info((Object)("    \u0421\u0431\u043e\u0440\u043a\u0430 \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438     : " + this.longStatus.getSoftwareBuildFm()));
                this.log.info((Object)("    \u0414\u0430\u0442\u0430 \u0441\u0431\u043e\u0440\u043a\u0438 \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438: " + this.longStatus.getSoftwareDateBuildFm()));
                this.log.info((Object)("    \u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430     : " + this.longStatus.getSoftwareVersionFr()));
                this.log.info((Object)("    \u0421\u0431\u043e\u0440\u043a\u0430 \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430     : " + this.longStatus.getSoftwareBuildFr()));
                this.log.info((Object)("    \u0414\u0430\u0442\u0430 \u0441\u0431\u043e\u0440\u043a\u0438 \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430: " + this.longStatus.getSoftwareDateBuildFr()));
                this.log.info((Object)("    \u0418\u041d\u041d: " + this.longStatus.getInn()));
                this.log.info((Object)("    \u0417\u0430\u0432\u043e\u0434\u0441\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440: " + this.longStatus.getNumber()));
                this.log.info((Object)("    \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0432 \u0424\u041f: " + this.longStatus.getAvaliableRecordsFm()));
                this.deviceInfo.setSerial(Integer.toString(this.longStatus.getNumber()));
                this.deviceInfo.setFirmware("\u041a\u041a\u0422: " + this.longStatus.getSoftwareVersionFr() + "/" + this.longStatus.getSoftwareBuildFr() + " \u043e\u0442 " + this.longStatus.getSoftwareDateBuildFr());
                this.deviceInfo.setFirmware1("\u0424\u041f: " + this.longStatus.getSoftwareVersionFm() + "/" + this.longStatus.getSoftwareBuildFm() + " \u043e\u0442 " + this.longStatus.getSoftwareDateBuildFm());
                this.deviceInfo.setInfo(Integer.toString(this.longStatus.getAvaliableRecordsFm()));
            } else {
                this.log.error((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u043a\u043a\u043c: " + yr.getError()));
            }
        }
        return this.longStatus;
    }

    @Override
    public ReportResult formReportX() throws IOException {
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u044f\u0442\u044c X-\u043e\u0442\u0447\u0435\u0442");
        int resX = this.api.reportX();
        m.addRes(resX);
        if (resX == 0 && this.getKkmInfo().getModel() == 15) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u0440\u0435\u0437\u0430\u0442\u044c \u0447\u0435\u043a");
            int res = this.api.cut(true);
            m.addRes(res);
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0432\u044b\u0434\u0430\u0442\u044c \u0447\u0435\u043a");
            res = this.api.outCheck(false);
            m.addRes(res);
        }
        return new ReportResult(resX, resX != 0, m.get(resX));
    }

    @Override
    public ReportResult formReportZ() throws IOException {
        int res;
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u044f\u0442\u044c Z-\u043e\u0442\u0447\u0435\u0442");
        ZReportInfo zReport = this.api.readZReportInfo();
        int resZ = this.api.reportZ();
        m.addRes(resZ);
        if (resZ == 0) {
            if (this.getKkmInfo().getModel() == 15) {
                this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u0440\u0435\u0437\u0430\u0442\u044c \u0447\u0435\u043a");
                res = this.api.cut(true);
                m.addRes(res);
                this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0432\u044b\u0434\u0430\u0442\u044c \u0447\u0435\u043a");
                res = this.api.outCheck(false);
                m.addRes(res);
            }
            this.notifyZReportInfo(zReport);
        }
        if (resZ == 0 || resZ == 22) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u043e\u0432\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u043c\u0435\u043d\u0443");
            res = this.api.openSession();
            m.addRes(res);
        }
        return new ReportResult(resZ, resZ != 0, m.get(resZ));
    }

    @Override
    public ReportResult formReportZMem() throws IOException {
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u044f\u0442\u044c Z-\u043e\u0442\u0447\u0435\u0442 \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
        int resZ = this.api.printReportsFromMemory();
        m.addRes(resZ);
        if (resZ == 0 && this.getKkmInfo().getModel() == 15) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u0440\u0435\u0437\u0430\u0442\u044c \u0447\u0435\u043a");
            int res = this.api.cut(true);
            m.addRes(res);
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0432\u044b\u0434\u0430\u0442\u044c \u0447\u0435\u043a");
            res = this.api.outCheck(false);
            m.addRes(res);
        }
        return new ReportResult(resZ, resZ != 0, m.get(resZ));
    }

    @Override
    public void print(Operation operation, RenderData data) throws IOException {
        block20: {
            if (this.isSupportedNotFiscalMode() && Boolean.TRUE.equals(operation.getService().isNotFiscal())) {
                this.printNotFiscal(operation, data);
                return;
            }
            if (operation == null) {
                throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Operation");
            }
            this.validate();
            this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0447\u0435\u043a \u043f\u0440\u043e\u0434\u0430\u0436\u0438");
            SumResult sr = operation.getSumResult();
            int stringCount = 5;
            int operationCount = 2;
            try {
                if (sr.getCash().getBasicSum() > 0 && !operation.isCopy() && sr.getCashLess().isEmpty()) {
                    String[] str;
                    int res;
                    this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u0435\u043c \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0447\u0435\u043a");
                    this.openCheck(operation);
                    if (data.isUseFiscalDepartments()) {
                        if (operation.getSumResult().getOut().getBasicSum() > 0) {
                            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0442\u043e\u0432\u0430\u0440\u0430: " + operation.getSumResult().getOut().getBasicSum()));
                            res = this.api.addOperation(128, operation.getService().getPrintName(), operation.getSumResult().getOut().getBasicSum(), 1000, 1);
                            if (res == 166) {
                                this.globalError = true;
                                this.log.info((Object)"\u0421\u0442\u0430\u0432\u043b\u044e \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u0443\u044e \u043e\u0448\u0438\u0431\u043a\u0443");
                            }
                            m.addResEx(res);
                            stringCount += operationCount;
                        }
                        if (operation.getSumResult().getCommission().getBasicSum() > 0) {
                            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0442\u043e\u0432\u0430\u0440\u0430: " + operation.getSumResult().getChange().getBasicSum()));
                            res = this.api.addOperation(128, this.bundle.getString("comission"), operation.getSumResult().getCommission().getBasicSum(), 1000, 2);
                            m.addResEx(res);
                            stringCount += operationCount;
                        }
                    } else if (operation.getSumResult().getOut().getBasicSum() + operation.getSumResult().getCommission().getBasicSum() > 0) {
                        this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0442\u043e\u0432\u0430\u0440\u0430: " + operation.getSumResult().getOut().getBasicSum()));
                        res = this.api.addOperation(128, operation.getService().getPrintName(), operation.getSumResult().getOut().getBasicSum() + operation.getSumResult().getCommission().getBasicSum(), 1000, 1);
                        m.addResEx(res);
                        stringCount += operationCount;
                    }
                    if (operation.getSumResult().getChange().getBasicSum() > 0) {
                        this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438: " + operation.getSumResult().getChange().getBasicSum()));
                        res = this.api.addOperation(128, this.bundle.getString("change"), operation.getSumResult().getChange().getBasicSum(), 1000, 1);
                        m.addResEx(res);
                        stringCount += operationCount;
                    }
                    this.shtrihPrinter.print((str = RenderManager.renderingOperation(DeviceType.ShtrihKkm, operation, data)) != null && str.length > 0 ? str[0] : "", stringCount);
                    if (this.scroll > 0) {
                        this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
                        this.shtrihPrinter.scroll(this.scroll);
                    }
                    this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
                    res = this.api.closeCheck(sr.getCash().getBasicSum(), sr.getCashLess().getBasicSum());
                    m.addResEx(res);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.api.outCheck(true);
                    this.log.info((Object)"\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
                    break block20;
                }
                if (sr.getCash().getBasicSum() > 0 && !operation.isCopy() && !sr.getCashLess().isEmpty()) {
                    this.log.info((Object)"\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0438 \u0441\u0443\u043c\u043c\u0430 \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f. \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438. \u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                    this.openCheck(operation);
                    this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0442\u043e\u0432\u0430\u0440\u0430: " + sr.getCash()));
                    int res = this.api.addOperation(128, operation.getService().getPrintName(), sr.getCash().getBasicSum(), 1000, 1);
                    m.addResEx(res);
                    this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u043d\u0435\u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                    res = this.api.openText();
                    m.addRes(res);
                    String[] str = RenderManager.renderingOperation(DeviceType.ShtrihPrinter, operation, data);
                    this.shtrihPrinter.print(str != null && str.length > 0 ? str[0] : "");
                    if (this.scroll > 0) {
                        this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
                        this.shtrihPrinter.scroll(this.scroll);
                    }
                    this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u043d\u0435\u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                    res = this.api.closeText();
                    m.addRes(res);
                    this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
                    res = this.api.closeCheck(sr.getCash().getBasicSum(), 0);
                    m.addRes(res);
                    this.api.outCheck(true);
                    this.log.info((Object)"\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
                    if (str != null && str.length > 1 && !str[1].trim().isEmpty()) {
                        ThreadUtil.sleep((long)3000L);
                        this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0432\u0442\u043e\u0440\u043e\u0439 \u0447\u0435\u043a: " + str[1].trim()));
                        this.shtrihPrinter.print(str[1].trim());
                        this.shtrihPrinter.scroll(4 + this.scroll);
                        this.shtrihPrinter.partialCut();
                    }
                } else {
                    this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u0435\u043c \u043d\u0435\u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0447\u0435\u043a");
                    String[] str = RenderManager.renderingOperation(DeviceType.ShtrihPrinter, operation, data);
                    this.log.info((Object)"\u041f\u043e\u0441\u044b\u043b\u0430\u044e \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c");
                    this.shtrihPrinter.print(str != null && str.length > 0 ? str[0] : "", stringCount);
                    this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + (4 + this.scroll)));
                    this.shtrihPrinter.scroll(4 + this.scroll);
                    ThreadUtil.sleep((long)1000L);
                    this.log.info((Object)"\u041e\u0442\u0440\u0435\u0437\u0430\u044e");
                    this.shtrihPrinter.partialCut();
                    this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u044c \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
                }
            }
            catch (IOException ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430/\u0432\u044b\u0432\u043e\u0434\u0430 \u043f\u0440\u0438 \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430", (Throwable)ex);
                this.notifyOperationError(operation, null, ex.getMessage());
                throw ex;
            }
            catch (Exception ex) {
                this.log.error((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a", (Throwable)ex);
            }
        }
    }

    @Override
    public void print(MoneyCollection moneyCollection, RenderData data) throws IOException {
        MoneyCollectionRender mcr = RenderFactory.createMoneyCollectionRender(DeviceType.ShtrihKkm, data.getRenderName());
        String[] res = RenderManager.renderingMoneyCollection(DeviceType.ShtrihPrinter, moneyCollection, data);
        if (res != null && res.length > 0) {
            this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0447\u0435\u043a\u043e\u0432 " + res.length));
            for (int i = 0; i < res.length; ++i) {
                String str;
                if (i != 0) {
                    ThreadUtil.sleep((long)3000L);
                }
                if ((str = res[i]) == null || str.trim().isEmpty()) continue;
                this.shtrihPrinter.print(str);
                this.shtrihPrinter.scroll(4 + this.scroll);
                ThreadUtil.sleep((long)1000L);
                this.shtrihPrinter.partialCut();
            }
        }
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        Result<Short> res;
        this.validate();
        PrinterStatus status = new PrinterStatus();
        Result<Status> yr = this.api.getShortStatus();
        if (yr.isOk()) {
            Status ss = yr.getData();
            if (this.lastStatus == null || !this.lastStatus.equals(ss)) {
                this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441: " + ss));
                this.lastStatus = ss;
            }
            if (ss.getMode() == 3) {
                if (this.closeReportZToMem().getResult() != 0) {
                    this.log.info((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043d\u044f\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
                    this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043e\u0442\u0447\u0435\u0442\u044b \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
                    this.formReportZMem();
                    this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0442\u0435\u043a\u0443\u0449\u0443\u044e \u0441\u043c\u0435\u043d\u0443");
                    this.formReportZ();
                } else {
                    this.log.info((Object)"\u041e\u0442\u0447\u0435\u0442 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c \u0441\u043d\u044f\u0442 \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
                }
                yr = this.api.getShortStatus();
                if (yr.isOk()) {
                    ss = yr.getData();
                }
            }
            status.setPaperNearEnd((ss.getFlags() & 2) == 0);
            status.setPaperEnd(ss.getSubMode() == 1 || ss.getSubMode() == 2);
            if (ss.getMode() == 3 || ss.getMode() == 5 || ss.getMode() == 6) {
                status.setOnline(false);
            }
            if (this.api.checkNumber() == null) {
                status.setOnline(false);
            }
        } else {
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430: " + m.get(yr)));
            status.setError(true);
        }
        Result<LongStatus> ls = this.api.getLongStatus();
        if (ls.isOk() && (this.lastLongStatus == null || !this.lastLongStatus.equals(ls.getData()))) {
            this.log.info((Object)ls.getData());
            this.lastLongStatus = ls.getData();
        }
        if ((res = this.api.checkNumber()).getError() == 113) {
            this.log.info((Object)"\u0411\u043b\u043e\u043a\u0438\u0440\u0443\u044e \u0424\u0420 \u043f\u043e \u043e\u0448\u0438\u0431\u043a\u0435 \u043e\u0442\u0440\u0435\u0437\u0447\u0438\u043a\u0430");
            status.setError(true);
        }
        if (this.globalError) {
            status.setError(this.globalError);
        }
        return status;
    }

    @Override
    public short nextCheckNumber() {
        try {
            Result<Short> cn = this.api.checkNumber();
            if (cn.isOk()) {
                return cn.getData();
            }
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0447\u0435\u043a\u0430: " + m.get(cn)));
        }
        catch (IOException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043d\u043e\u043c\u0435\u0440\u0430 \u0447\u0435\u043a\u0430");
        }
        return 0;
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public boolean isOpen() {
        return this.api.getPort().isOpen();
    }

    @Override
    public DeviceInfo getInfo() {
        return this.deviceInfo;
    }

    private void openCheck(Operation operation) throws IOException, Exception {
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0447\u0435\u043a");
        int res = this.api.openCheck(0);
        m.addRes(res);
        if (res != 0) {
            if (res == 78) {
                this.log.info((Object)"\u0421\u043c\u0435\u043d\u0430 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u043b\u0430 24 \u0447\u0430\u0441\u0430");
                int res2 = this.closeReportZToMem().getResult();
                m.addRes(res2);
                if (res2 == 0) {
                    this.log.info((Object)"\u0421\u043c\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0430 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c. \u041f\u0440\u043e\u0431\u0443\u0435\u043c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0437\u0430\u043d\u043e\u0432\u043e");
                    res = this.api.openCheck(0);
                    m.addResEx(res);
                } else {
                    this.log.error((Object)"\u0424\u0420 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0441\u043d\u044f\u0442\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
                }
            } else {
                this.notifyError(operation, "openCheck", res);
            }
        }
    }

    private void validate() throws IOException {
        Result<Status> yr = this.api.getShortStatus();
        if (yr.isOk()) {
            Status ss = yr.getData();
            this.log.debug((Object)("\u0421\u0442\u0430\u0442\u0443\u0441: " + ss));
            if (ss.getSubMode() == 3) {
                this.log.info((Object)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u044f \u043f\u0435\u0447\u0430\u0442\u0438");
                this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 '\u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0447\u0430\u0442\u0438': " + this.api.continuePrint()));
            }
            if ((ss.getMode() & 0xFF) == 8) {
                this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442. \u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e");
                this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 '\u043e\u0442\u043c\u0435\u043d\u044b \u0447\u0435\u043a\u0430': " + this.api.cancelCheck()));
            }
        }
    }

    @Override
    public void init() throws IOException {
        this.getKkmInfo();
        this.getLongStatus();
    }

    private void notifyError(Operation op, String procedure, int result) throws IOException {
        String add = "";
        if (result == 115) {
            Result<Status> yr = this.api.getShortStatus();
            if (yr.isOk()) {
                add = "[mode=" + yr.getData().getMode() + "." + yr.getData().getSubMode() + "]";
            } else {
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430: " + yr.getData()));
            }
        }
        this.notifyOperationError(op, procedure, m.get(result) + add);
    }

    @Override
    public void setDefaultValues() {
        this.log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 '\u043f\u043e-\u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e' \u043e\u0442\u0441\u0443\u0441\u0442\u0432\u0443\u044e\u0442");
    }

    @Override
    public void printGroup(GroupOperation operation, RenderData data) throws IOException {
        block13: {
            if (operation == null) {
                throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Operation");
            }
            if (this.isSupportedNotFiscalMode() && Boolean.TRUE.equals(operation.getService().isNotFiscal())) {
                this.printNotFiscal((Operation)operation, data);
                return;
            }
            this.validate();
            this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0447\u0435\u043a \u043f\u0440\u043e\u0434\u0430\u0436\u0438");
            SumResult sr = operation.getSumResult();
            int stringCount = 5;
            int operationCount = 2;
            try {
                if (sr.getCash().getBasicSum() > 0) {
                    String[] str;
                    int res;
                    this.openCheck((Operation)operation);
                    if (operation.getChildOperations() != null && !operation.getChildOperations().isEmpty()) {
                        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u0443\u044e \u0447\u0430\u0441\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
                        for (ChildOperation co : operation.getChildOperations()) {
                            this.log.info((Object)("\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e \u043f\u043e\u0434\u0443\u0441\u043b\u0443\u0433\u0443: " + co));
                            res = this.api.addOperation(128, co.getService().getPrintName(), co.getSumOutcome().getBasicSum(), 1000, 1);
                            m.addResEx(res);
                            stringCount += operationCount;
                        }
                    }
                    if (operation.getSumResult().getCommission().getBasicSum() > 0) {
                        this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u043a\u043e\u043c\u0438\u0441\u0438\u0438: " + operation.getSumResult().getChange().getBasicSum()));
                        res = this.api.addOperation(128, this.bundle.getString("comission"), operation.getSumResult().getCommission().getBasicSum(), 1000, 2);
                        m.addResEx(res);
                        stringCount += operationCount;
                    }
                    if (operation.getSumResult().getChange().getBasicSum() > 0) {
                        this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438: " + operation.getSumResult().getChange().getBasicSum()));
                        res = this.api.addOperation(128, this.bundle.getString("change"), operation.getSumResult().getChange().getBasicSum(), 1000, 1);
                        m.addResEx(res);
                        stringCount += operationCount;
                    }
                    this.shtrihPrinter.print((str = RenderManager.renderingGroupOperation(DeviceType.ShtrihPrinter, operation, data)) != null && str.length > 0 ? str[0] : "", stringCount);
                    if (this.scroll > 0) {
                        this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
                        this.shtrihPrinter.scroll(this.scroll);
                    }
                    this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
                    res = this.api.closeCheck(sr.getCash().getBasicSum(), sr.getCashLess().getBasicSum());
                    m.addResEx(res);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.api.outCheck(true);
                    this.log.info((Object)"\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
                    break block13;
                }
                String[] str = RenderManager.renderingOperation(DeviceType.ShtrihPrinter, (Operation)operation, data);
                this.shtrihPrinter.print(str != null && str.length > 0 ? str[0] : "", stringCount);
                this.shtrihPrinter.scroll(4 + this.scroll);
                ThreadUtil.sleep((long)1000L);
                this.shtrihPrinter.partialCut();
            }
            catch (IOException ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430/\u0432\u044b\u0432\u043e\u0434\u0430 \u043f\u0440\u0438 \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430", (Throwable)ex);
                this.notifyOperationError((Operation)operation, null, ex.getMessage());
                throw ex;
            }
            catch (Exception ex) {
                this.log.error((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a", (Throwable)ex);
            }
        }
    }

    @Override
    public ReportResult closeReportZToMem() throws IOException {
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u043e\u0442\u0447\u0435\u0442 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
        ZReportInfo zReport = this.api.readZReportInfo();
        int res = this.api.putReportToMemory();
        m.addRes(res);
        if (res == 55) {
            this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u044c Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
            if (this.control.isPrintZreportWhileBufferIsNotSupported()) {
                this.log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u044b \u043d\u0430 \u0431\u0443\u043c\u0430\u0433\u0443");
                this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e Z-\u043e\u0442\u0447\u0435\u0442 \u043d\u0430 \u0431\u0443\u043c\u0430\u0433\u0443");
                int resZ = this.api.reportZ();
                m.addRes(resZ);
                this.log.info((Object)"\u0416\u0434\u0435\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0430 4.0");
                Helper.waitUntil(this.api, 4, 0);
                this.log.info((Object)"\u0413\u043e\u0442\u043e\u0432\u043e");
                if (resZ == 0) {
                    this.notifyZReportInfo(zReport);
                }
                return new ReportResult(resZ, resZ != 0, m.get(resZ));
            }
            return new ReportResult(res, res != 0, m.get(res));
        }
        if (res == 75) {
            this.log.info((Object)"\u0411\u0443\u0444\u0444\u0435\u0440 Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d");
            if (this.control.isPrintZreportWhileBufferIsFull()) {
                this.log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u044b \u043d\u0430 \u0431\u0443\u043c\u0430\u0433\u0443");
                this.log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e \u043e\u0442\u0447\u0435\u0442\u044b \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
                int resZ = this.api.printReportsFromMemory();
                m.addRes(resZ);
                this.log.info((Object)"\u0416\u0434\u0435\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0430 4.0");
                Helper.waitUntil(this.api, 4, 0);
                this.log.info((Object)"\u0413\u043e\u0442\u043e\u0432\u043e, \u0441\u043d\u0438\u043c\u0430\u044e Z-\u043e\u0442\u0447\u0435\u0442\u044b \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
                resZ = this.api.putReportToMemory();
                m.addRes(res);
                this.log.info((Object)"\u0416\u0434\u0435\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0430 4.0");
                Helper.waitUntil(this.api, 4, 0);
                this.log.info((Object)"\u0413\u043e\u0442\u043e\u0432\u043e");
                if (resZ == 0) {
                    this.notifyZReportInfo(zReport);
                }
                return new ReportResult(resZ, resZ != 0, m.get(resZ));
            }
            return new ReportResult(res, res != 0, m.get(res));
        }
        if (res == 0) {
            this.log.info((Object)"\u041e\u0436\u0438\u0434\u0430\u0435\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0430 4.0");
            Helper.waitUntil(this.api, 4, 0);
            Date date = new Date();
            this.log.info((Object)("\u041b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f: " + date));
            Result<LongStatus> ls = this.api.getLongStatus();
            if (ls.isOk()) {
                this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u043a\u043a\u043c: " + ls.getData().getDate()));
                if (Math.abs(ls.getData().getDate().getTime() - date.getTime()) > 300000L) {
                    this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043d\u0430 5 \u043c\u0438\u043d\u0443\u0442, \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u0443\u044e");
                    this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0432\u0440\u0435\u043c\u044f: " + this.api.seTime(date)));
                    this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0434\u0430\u0442\u0443: " + this.api.setDate(date)));
                    this.log.info((Object)("\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0430\u044e \u0434\u0430\u0442\u0443: " + this.api.dateCommit(date)));
                } else {
                    this.log.info((Object)"\u041a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
                }
            } else {
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430: " + m.get(ls)));
            }
            this.notifyZReportInfo(zReport);
            return new ReportResult(res, res != 0, m.get(res));
        }
        this.log.info((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0443");
        return new ReportResult(res, res != 0, m.get(res));
    }

    @Override
    public ReportResult formReportDateRange(Date start, Date finish, boolean shortReport, String password) throws IOException {
        int res = this.api.fpReportByDateRange(start, finish, shortReport ? 0 : 1, password);
        return new ReportResult(res, res != 0, m.get(res));
    }

    @Override
    public void print(CustomData customData, RenderData renderData) throws IOException {
        String[] res = RenderManager.renderingCustomData(DeviceType.ShtrihPrinter, customData, renderData);
        if (res != null && res.length > 0) {
            this.shtrihPrinter.print(res[0]);
            this.shtrihPrinter.scroll(4 + this.scroll);
            this.shtrihPrinter.fullCut();
        } else {
            this.log.error((Object)"\u041d\u0435\u0447\u0435\u0433\u043e \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c");
        }
    }

    @Override
    public PrinterType getType() {
        return PrinterType.Kkm;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isNeedCorrectTime() throws IOException {
        Date date = new Date();
        this.log.info((Object)("\u041b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f: " + date));
        Result<LongStatus> ls = this.api.getLongStatus();
        if (ls.isOk()) {
            this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u043a\u043a\u043c: " + ls.getData().getDate()));
            if (Math.abs(ls.getData().getDate().getTime() - date.getTime()) > 180000L) {
                this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043d\u0430 3 \u043c\u0438\u043d\u0443\u0442\u044b.");
                if (date.getTime() - ls.getData().getDate().getTime() > 0L) {
                    this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u0424\u0420 \u043e\u0442\u0441\u0442\u0430\u0435\u0442. \u0421\u043c\u0435\u043d\u0438\u043c \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0441\u043c\u0435\u043d\u044b");
                    return false;
                } else {
                    if (date.getTime() - ls.getData().getDate().getTime() >= -7200000L) return true;
                    this.log.info((Object)"\u0420\u0430\u0437\u043d\u0438\u0446\u0430 \u0432\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 2\u0445 \u0447\u0430\u0441\u043e\u0432. \u041d\u0435 \u043c\u043e\u0433\u0443 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b");
                }
                return false;
            } else {
                this.log.info((Object)"\u041a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
            }
            return false;
        } else {
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430: " + m.get(ls)));
        }
        return false;
    }

    @Override
    public void correctTime() throws IOException, InterruptedException {
        this.log.info((Object)"\u041a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438. \u0417\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0441\u043c\u0435\u043d\u0443");
        ZReportInfo zReport = this.api.readZReportInfo();
        int res = this.api.putReportToMemory();
        m.addRes(res);
        if (res == 55) {
            this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u044c Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
            if (this.control.isPrintZreportWhileBufferIsNotSupported()) {
                this.log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u044b \u043d\u0430 \u0431\u0443\u043c\u0430\u0433\u0443");
                this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e Z-\u043e\u0442\u0447\u0435\u0442 \u043d\u0430 \u0431\u0443\u043c\u0430\u0433\u0443");
                int resZ = this.api.reportZ();
                m.addRes(resZ);
                this.log.info((Object)"\u0416\u0434\u0435\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0430 4.0");
                Helper.waitUntil(this.api, 4, 0);
                this.log.info((Object)"\u0413\u043e\u0442\u043e\u0432\u043e");
                if (resZ == 0) {
                    this.notifyZReportInfo(zReport);
                    this.correctFrTime();
                }
            }
        } else if (res == 75) {
            this.log.info((Object)"\u0411\u0443\u0444\u0444\u0435\u0440 Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d");
            if (this.control.isPrintZreportWhileBufferIsFull()) {
                this.log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u044b \u043d\u0430 \u0431\u0443\u043c\u0430\u0433\u0443");
                this.log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e \u043e\u0442\u0447\u0435\u0442\u044b \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
                int resZ = this.api.printReportsFromMemory();
                m.addRes(resZ);
                this.log.info((Object)"\u0416\u0434\u0435\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0430 4.0");
                Helper.waitUntil(this.api, 4, 0);
                this.log.info((Object)"\u0413\u043e\u0442\u043e\u0432\u043e, \u0441\u043d\u0438\u043c\u0430\u044e Z-\u043e\u0442\u0447\u0435\u0442\u044b \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
                resZ = this.api.putReportToMemory();
                m.addRes(res);
                this.log.info((Object)"\u0416\u0434\u0435\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0430 4.0");
                Helper.waitUntil(this.api, 4, 0);
                this.log.info((Object)"\u0413\u043e\u0442\u043e\u0432\u043e");
                if (resZ == 0) {
                    this.notifyZReportInfo(zReport);
                    this.correctFrTime();
                }
            }
        } else if (res == 0) {
            this.log.info((Object)"\u041e\u0436\u0438\u0434\u0430\u0435\u043c \u0441\u0442\u0430\u0442\u0443\u0441\u0430 4.0");
            Helper.waitUntil(this.api, 4, 0);
            this.notifyZReportInfo(zReport);
            this.correctFrTime();
        }
    }

    private void correctFrTime() throws IOException, InterruptedException {
        Date date = new Date();
        this.log.info((Object)("\u041b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f: " + date));
        Result<LongStatus> ls = this.api.getLongStatus();
        if (ls.isOk()) {
            this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u043a\u043a\u043c: " + ls.getData().getDate()));
            long sleepTime = Math.abs(ls.getData().getDate().getTime() - date.getTime());
            if (sleepTime > 180000L) {
                this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043d\u0430 3 \u043c\u0438\u043d\u0443\u0442\u044b. \u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0434\u0430\u0442\u0443 \u0424\u0420");
                Thread.sleep(sleepTime + 10000L);
                date = new Date();
                this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0432\u0440\u0435\u043c\u044f: " + this.api.seTime(date)));
                this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0434\u0430\u0442\u0443: " + this.api.setDate(date)));
                this.log.info((Object)("\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0430\u044e \u0434\u0430\u0442\u0443: " + this.api.dateCommit(date)));
            } else {
                this.log.info((Object)"\u041a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
            }
        } else {
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430: " + m.get(ls)));
        }
    }
}

