/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.rpsytem;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.kkm.rpsytem.Connection;
import ru.softlogic.hardware.device.print.kkm.rpsytem.Err;
import ru.softlogic.hardware.device.print.kkm.rpsytem.LongStatus;
import ru.softlogic.hardware.device.print.kkm.rpsytem.R;
import ru.softlogic.hardware.device.print.kkm.rpsytem.Result;
import ru.softlogic.hardware.device.print.kkm.rpsytem.RpSystemResultException;
import ru.softlogic.hardware.device.print.kkm.rpsytem.ShortStatus;
import ru.softlogic.hardware.utils.StringUtils;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;
import ru.softlogic.system.util.ArrayUtils;

public class Api
implements SerialDeviceApi {
    private SerialPort serialPort;
    private Map<Boolean, SerialParams[]> serialParams;
    private Connection conn;
    private byte[] oPassword;
    private byte[] aPassword;
    private Logger log;

    public Api(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.serialPort = port;
        this.conn = new Connection(port);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(2400, DataBits.Eight, StopBits.One, Parity.None)});
        this.setAdministratorPassword(30);
        this.setOperatorPassword(30);
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    public final void setOperatorPassword(int password) {
        this.oPassword = this.getPassword(password);
    }

    public final void setAdministratorPassword(int password) {
        this.aPassword = this.getPassword(password);
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return (SerialParams[])ArrayUtils.arrayMerge((Object[][])new SerialParams[][]{this.serialParams.get(true), this.serialParams.get(false)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        this.conn.setAttempts(3);
        this.conn.setAttemptsTimeout(100);
        for (SerialParams params : this.serialParams.get(preferred)) {
            this.log.info((Object)("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: " + params));
            try {
                this.serialPort.putParams(params);
                this.open();
                if (!this.isConnected()) continue;
                DeviceType deviceType = DeviceType.RpSystemKkm;
                return deviceType;
            }
            catch (IOException iOException) {
            }
            finally {
                this.close();
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    public int seTime(Date date) throws IOException {
        if (date == null) {
            throw new IllegalArgumentException("\u0414\u0430\u0442\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        return this.conn.sendCommand(33, this.aPassword, new byte[]{(byte)hour, (byte)minute, (byte)second}).getCode();
    }

    public int setDate(Date date) throws IOException {
        if (date == null) {
            throw new IllegalArgumentException("\u0414\u0430\u0442\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int day = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1) % 100;
        return this.conn.sendCommand(34, this.aPassword, new byte[]{(byte)day, (byte)(month + 1), (byte)year}).getCode();
    }

    public int dateCommit(Date date) throws IOException {
        if (date == null) {
            throw new IllegalArgumentException("\u0414\u0430\u0442\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int day = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1) % 100;
        return this.conn.sendCommand(35, this.aPassword, new byte[]{(byte)day, (byte)(month + 1), (byte)year}).getCode();
    }

    public int cashOut(int sum) throws IOException {
        byte[] data = new byte[5];
        BU.sile((byte[])data, (int)0, (int)sum);
        data[4] = 0;
        return this.conn.sendCommand(81, this.aPassword, data).getCode();
    }

    public Result<Long> getCashReg(int num) throws IOException {
        R res = this.conn.sendCommand(26, this.aPassword, new byte[]{(byte)num});
        if (res.getCode() == 0) {
            byte[] b = res.getData();
            return new Result<Long>(res.getCode(), (long)(BU.c((byte)b[1]) + (BU.c((byte)b[2]) << 8) + (BU.c((byte)b[3]) << 16) + (BU.c((int)(b[4] & 0xFF)) << 24)) + ((long)BU.c((byte)b[5]) << 32) + ((long)BU.c((byte)b[6]) << 40));
        }
        return new Result<Long>(res.getCode());
    }

    public SerialPort getPort() {
        return this.serialPort;
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.RpSystemKkm;
    }

    @Override
    public void open() throws IOException {
        if (!this.serialPort.isOpen()) {
            this.serialPort.open();
        }
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    public Result<LongStatus> getLongStatus() throws IOException {
        R res = this.conn.sendCommand(17, this.oPassword, null);
        if (res.getCode() != 0) {
            return new Result<LongStatus>(res.getCode());
        }
        if (res.getData() == null || res.getData().length < 65) {
            throw new IOException("\u0414\u0430\u043d\u043d\u044b\u0435 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u044b");
        }
        byte[] data = res.getData();
        LongStatus longStatus = new LongStatus();
        ShortStatus shortStatus = new ShortStatus();
        longStatus.setSoftwareVersionFr(String.format("%d.%d", BU.c((byte)data[0]), BU.c((byte)data[1])));
        longStatus.setSoftwareBuildFr(BU.csle((byte[])data, (int)2));
        longStatus.setSoftwareDateBuildFr(String.format("%d.%d.%d", BU.c((byte)data[4]), BU.c((byte)data[5]), BU.c((byte)data[6]) + 2000));
        shortStatus.setState(BU.c((byte)data[12]));
        shortStatus.setFnLifeState(BU.c((byte)data[13]));
        shortStatus.setFnEndDate(BU.c((byte)data[15]), BU.c((byte)data[16]), BU.c((byte)data[17]));
        shortStatus.setFnFlags(BU.c((byte)data[18]));
        shortStatus.setPrinterState(data[19]);
        longStatus.setShortStatus(shortStatus);
        longStatus.setCheckNumber(BU.c((byte)data[11]) + (BU.c((byte)data[12]) << 8));
        Date date = Api.getDate(data[22], data[23] - 1, data[24] + 2000, data[25], data[26], data[27]);
        longStatus.setDate(date);
        longStatus.setNumber(BU.cile((byte[])data, (int)30));
        return new Result<LongStatus>(res.getCode(), longStatus);
    }

    public int reportX() throws IOException {
        return this.conn.sendCommand(66, this.aPassword, null, 2000, 10000).getCode();
    }

    public int reportZ() throws IOException {
        return this.conn.sendCommand(65, this.aPassword, null, 2000, 10000).getCode();
    }

    public int cut(boolean fullCut) throws IOException {
        byte data = (byte)(!fullCut ? 1 : 0);
        return this.conn.sendCommand(37, this.oPassword, new byte[]{data}).getCode();
    }

    public int openSession() throws IOException {
        return this.conn.sendCommand(224, this.oPassword, null).getCode();
    }

    public int printString(String str, boolean bold) throws IOException {
        if (str == null) {
            return 0;
        }
        if (bold) {
            str = StringUtils.getStringByLen(str, 20);
            byte[] data = new byte[1 + str.length()];
            data[0] = 2;
            byte[] bytes = str.getBytes("cp1251");
            System.arraycopy(bytes, 0, data, 1, bytes.length);
            return this.conn.sendCommand(18, this.oPassword, data).getCode();
        }
        str = StringUtils.getStringByLen(str, 40);
        byte[] data = new byte[1 + str.length()];
        data[0] = 2;
        byte[] bytes = str.getBytes("cp1251");
        System.arraycopy(bytes, 0, data, 1, bytes.length);
        return this.conn.sendCommand(23, this.oPassword, data).getCode();
    }

    public int continuePrint() throws IOException {
        return this.conn.sendCommand(140, this.oPassword, null).getCode();
    }

    public int cancelCheck() throws IOException {
        return this.conn.sendCommand(136, this.oPassword, null).getCode();
    }

    public R getOperationRegistry(int number) throws IOException {
        if (number < 0 || number > 255) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c 0..255");
        }
        return this.conn.sendCommand(27, this.oPassword, new byte[]{(byte)number});
    }

    public R readTable(int idTable, int idRow, int idField) throws IOException {
        if (idTable < 0 || idTable > 255) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 255");
        }
        if (idRow < 0 || idRow > 65536) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u0440\u044f\u0434\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 65536");
        }
        if (idField < 0 || idField > 255) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u043f\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 255");
        }
        byte[] data = new byte[4];
        data[0] = BU.c((int)idTable);
        BU.ssle((byte[])data, (int)1, (int)idRow);
        data[3] = BU.c((int)idField);
        return this.conn.sendCommand(43551, this.aPassword, data);
    }

    public int writeTable(int idTable, int idRow, int idField, int type, byte[] value) throws IOException {
        if (!this.isCorrectType(type, value)) {
            throw new IllegalArgumentException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
        }
        if (idTable < 0 || idTable > 255) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 255");
        }
        if (idRow < 0 || idRow > 65536) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u0440\u044f\u0434\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 65536");
        }
        if (idField < 0 || idField > 255) {
            throw new IllegalArgumentException("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u043f\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043e\u0442 0 \u0434\u043e 255");
        }
        byte[] data = new byte[value.length + 5];
        data[0] = BU.c((int)idTable);
        BU.ssle((byte[])data, (int)1, (int)idRow);
        data[3] = BU.c((int)idField);
        data[4] = BU.c((int)type);
        System.arraycopy(value, 0, data, 5, value.length);
        return this.conn.sendCommand(43550, this.aPassword, data).getCode();
    }

    public int writeTable(int idTable, int idRow, int idField, int type, int value) throws IOException {
        return this.writeTable(idTable, idRow, idField, type, new byte[]{(byte)value});
    }

    public int openCheck(int type) throws IOException {
        if (type < 0 || type > 4) {
            throw new IllegalArgumentException("\u0422\u0438\u043f \u043e\u0442\u043a\u0440\u044b\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435\u0432\u0435\u0440\u0435\u043d");
        }
        return this.conn.sendCommand(141, this.oPassword, new byte[]{(byte)type}).getCode();
    }

    public int closeCheck(int cash, int cashbackcard) throws IOException {
        byte[] data = new byte[37];
        BU.sile((byte[])data, (int)0, (int)cash);
        data[4] = 0;
        BU.sile((byte[])data, (int)5, (int)cashbackcard);
        data[9] = 0;
        data[10] = 0;
        data[11] = 0;
        data[12] = 0;
        data[13] = 0;
        data[14] = 0;
        data[15] = 0;
        data[16] = 0;
        data[17] = 0;
        data[18] = 0;
        data[19] = 0;
        data[20] = 0;
        data[21] = 0;
        data[22] = 0;
        data[23] = 0;
        data[24] = 0;
        data[25] = 0;
        data[26] = 0;
        data[27] = 0;
        data[28] = 0;
        data[29] = 0;
        data[30] = 0;
        data[31] = 0;
        data[32] = 0;
        data[33] = 0;
        data[34] = 0;
        data[35] = 1;
        data[36] = 0;
        return this.conn.sendCommand(142, this.oPassword, data).getCode();
    }

    public int addOperation(int type, String name, int price, int count) throws IOException {
        if (type < 128 || type > 130) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
        }
        if (name == null || name.isEmpty()) {
            name = "\u043d/\u0443";
        }
        name = StringUtils.getStringByLen(name, 40);
        byte[] bname = null;
        try {
            bname = name.getBytes("cp1251");
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] data = new byte[15 + (bname == null ? 0 : bname.length)];
        BU.sile((byte[])data, (int)0, (int)count);
        data[4] = 0;
        BU.sile((byte[])data, (int)5, (int)price);
        data[9] = 0;
        data[10] = 1;
        data[11] = 4;
        data[12] = 0;
        data[13] = 0;
        data[14] = 0;
        if (bname != null) {
            System.arraycopy(bname, 0, data, 15, bname.length);
        }
        return this.conn.sendCommand(type, this.oPassword, data).getCode();
    }

    private static Date getDate(int day, int month, int year, int hour, int min, int sec) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000 + year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        return cal.getTime();
    }

    private byte[] getPassword(int password) {
        byte[] pass = new byte[4];
        BU.sile((byte[])pass, (int)0, (int)password);
        return pass;
    }

    public boolean isConnected() {
        try {
            byte[] data = new byte[]{-86, -86, 85};
            R res = this.conn.sendCommand(253, this.oPassword, data);
            byte[] answer = res.getData();
            Err.addResEx(res.getCode());
            return answer[0] == data[0] && answer[1] == (data[0] ^ data[1]) && answer[2] == (data[0] ^ data[2]);
        }
        catch (IOException | RpSystemResultException ex) {
            return false;
        }
    }

    public void rePrint() {
        try {
            this.conn.sendCommand(140, this.oPassword, this.oPassword);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isCorrectType(int type, byte[] data) {
        if (data == null) {
            return false;
        }
        int len = data.length;
        switch (type) {
            case 1: 
            case 2: {
                return type == len;
            }
            case 3: {
                return len == 4;
            }
            case 4: {
                return data.length != 0;
            }
        }
        return false;
    }
}

