/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.leokas;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.hardware.device.print.kkm.leokas.LeoFile;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;

public class ZRInfo
implements Serializable {
    static final long serialVersionUID = 5722375100861848133L;
    private int lastErrorCode;
    private Date lastZRDate;
    private final List<LeoFile> reports = new ArrayList<LeoFile>();

    public Date getLastZRDate() {
        return this.lastZRDate;
    }

    public boolean isError() {
        return this.lastErrorCode != 0;
    }

    public List<LeoFile> getReports() {
        return this.reports;
    }

    public void update(int errorCode, Date d) {
        this.lastErrorCode = errorCode;
        this.lastZRDate = d;
        this.flush();
    }

    public String toString() {
        return "ZRInfo{lastZRDate=" + this.lastZRDate + ", lastErrorCode=" + this.lastErrorCode + ", reportCount=" + this.reports.size() + '}';
    }

    public static ZRInfo readData() {
        Logger log = Logger.getLogger((String)"print");
        log.setAdditivity(false);
        log.info((Object)"*************** \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0447\u0442\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0441\u043d\u044f\u0442\u0438\u044f Z-\u043e\u0442\u0447\u0435\u0442\u0430 ***************");
        ZRInfo z = null;
        String zrInfoPath = SystemProp.getTerminalDir() + File.separator + "data" + File.separator + "kkm" + File.separator + "zrinfo.obj";
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(FileUtil.checkFile((String)zrInfoPath)));){
            Object obj = ois.readObject();
            if (obj instanceof ZRInfo) {
                z = (ZRInfo)obj;
            }
        }
        catch (IOException | ClassNotFoundException | FileUtilException ex) {
            log.error((Object)ex, ex);
        }
        if (z == null) {
            z = new ZRInfo();
        }
        log.info((Object)"********************* \u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b \u0447\u0442\u0435\u043d\u0438\u0435 *********************");
        return z;
    }

    public void flush() {
        try (FileOutputStream fos = new FileOutputStream(FileUtil.checkFile((String)(SystemProp.getTerminalDir() + File.separator + "data" + File.separator + "kkm" + File.separator + "zrinfo.obj")));
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            fos.getChannel().force(true);
            oos.writeObject(this);
            fos.flush();
            fos.getFD().sync();
        }
        catch (Exception ex) {
            Logger log = Logger.getLogger((String)"print");
            log.setAdditivity(false);
            log.error((Object)ex, (Throwable)ex);
        }
    }
}

