/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.leokas;

import ru.softlogic.hardware.device.print.kkm.leokas.Msg;

public class Status {
    public static final int LOCKED = 1;
    public static final int SHIFT_OPEN = 2;
    public static final int FISC_DOC_OPEN = 8;
    public static final int DOC_OPEN = 16;
    public static final int OPER_REG = 32;
    public static final int FISCALIZED = 2048;
    public static final int PAPER_NEAR_END = 4096;
    public static final int PAPER_END = 8192;
    public static final int COVER_OPEN = 16384;
    public static final int BUSY = 32768;
    private final int flags;

    public Status(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isOperatorReg() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isPaperEnd() {
        return (this.flags & 0x2000) != 0;
    }

    public boolean isPaperNearEnd() {
        return (this.flags & 0x1000) != 0;
    }

    public boolean isCoverOpen() {
        return (this.flags & 0x4000) != 0;
    }

    public boolean isDocOpen() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isFiscDocOpen() {
        return (this.flags & 8) != 0;
    }

    public boolean isShiftOpen() {
        return (this.flags & 2) != 0;
    }

    public boolean isLocked() {
        return (this.flags & 1) != 0;
    }

    public String asStr() {
        return Msg.getStatus(this.flags);
    }

    public String toString() {
        return "Status{flags=" + this.flags + '}';
    }
}

