/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.leokas;

import java.util.ResourceBundle;

public final class Msg {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(Msg.class.getPackage().getName() + ".messages");

    private Msg() {
    }

    public static String getResult(int error) {
        String key = "result." + error;
        try {
            return BUNDLE.getString(key);
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static String getAnswerType(int type) {
        String key = "ans." + type;
        try {
            return BUNDLE.getString(key);
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static String getStatus(int flags) {
        return Msg.getAttributes("status.flag.", flags);
    }

    public static String getStatusEx(int flags) {
        return Msg.getAttributes("exstatus.flag.", flags);
    }

    private static String getAttributes(String prefix, int flags) {
        int mask = 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            if ((flags & mask) != 0) {
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(Msg.getFlagName(prefix, i));
            }
            mask <<= 1;
        }
        return sb.toString() + String.format("|0x%04X", flags);
    }

    private static String getFlagName(String prefix, int bitNum) {
        try {
            return BUNDLE.getString(prefix + bitNum);
        }
        catch (Exception ex) {
            return "";
        }
    }
}

