/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.leokas;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.kkm.leokas.Api;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.system.util.ArrayUtils;

public class LeoApi
implements SerialDeviceApi {
    private final SerialPort port;
    private final Map<Boolean, SerialParams[]> serialParams;
    private final Api api;

    public LeoApi(SerialPort port) {
        this.port = port;
        this.api = new Api(port);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None)});
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return (SerialParams[])ArrayUtils.arrayMerge((Object[][])new SerialParams[][]{this.serialParams.get(true), this.serialParams.get(false)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        for (SerialParams params : this.serialParams.get(preferred)) {
            try {
                this.port.putParams(params);
                this.api.open();
                this.api.getStatus();
                DeviceType deviceType = null;
                return deviceType;
            }
            catch (IOException iOException) {
            }
            finally {
                this.api.close();
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.port.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.LeokasPrinter;
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void close() {
        this.api.close();
    }
}

