/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.leokas;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.kkm.leokas.Result;
import ru.softlogic.hardware.device.print.kkm.leokas.Status;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Connector {
    private final SerialPort port;
    private int sync = 0;
    private final Logger log = Logger.getLogger((String)"print");
    private int attempts = 3;
    private int timeout = 1000;
    private Status lastStatus;

    public Connector(SerialPort port) {
        this.port = port;
    }

    public Result send(int cmd) throws IOException {
        return this.send(cmd, null, null);
    }

    public Result send(int cmd, int timeout) throws IOException {
        return this.send(cmd, null, timeout);
    }

    public Result send(int cmd, byte[] data) throws IOException {
        return this.send(cmd, data, null);
    }

    public Result send(int cmd, byte[] data, Integer timeout) throws IOException {
        this.sync = (this.sync + 1) % 4095;
        byte[] req = this.formRequest(cmd, data);
        this.port.setTimeout(timeout != null ? timeout : this.timeout);
        for (int i = 0; i < this.attempts; ++i) {
            try {
                this.port.flush(Flush.RxTx);
                this.log.debug((Object)(">>" + BU.toString((byte[])req)));
                this.port.write(req);
                byte[] hdr = this.port.read(3);
                int len = BU.csle((byte[])hdr, (int)1);
                if (hdr[0] < 0 || hdr[0] > 4) {
                    throw new IOException("Wrong answer header:" + BU.toString((byte[])hdr) + ", value must be in range 0..4");
                }
                if (len < 10 || len > 2000) {
                    throw new IOException("Wrong answer header:" + BU.toString((byte[])hdr) + ", len=" + len);
                }
                byte[] oth = this.port.read(len - 3);
                byte[] ans = new byte[len];
                System.arraycopy(hdr, 0, ans, 0, hdr.length);
                System.arraycopy(oth, 0, ans, 3, oth.length);
                this.log.debug((Object)("    <<" + BU.toString((byte[])ans)));
                byte crc = this.calcCrc(ans);
                if (crc != ans[len - 1]) {
                    throw new IOException("Answer has wrong crc: " + BU.toString((byte[])ans));
                }
                int status = BU.csle((byte[])ans, (int)5);
                int error = BU.csle((byte[])ans, (int)7);
                if (error == 124) {
                    throw new IOException("Wrong request checksum");
                }
                byte[] ansData = null;
                if (len - 10 > 0) {
                    ansData = new byte[len - 10];
                    System.arraycopy(ans, 9, ansData, 0, ansData.length);
                }
                this.lastStatus = new Status(status);
                Result res = new Result(status, error, ansData);
                this.log.debug((Object)("      " + res));
                return res;
            }
            catch (IOException ex) {
                this.log.error((Object)("I/O Error on " + i + " attempt"), (Throwable)ex);
                if (i != this.attempts - 1) continue;
                throw ex;
            }
        }
        return null;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Status getLastStatus() {
        return this.lastStatus;
    }

    private byte[] formRequest(int cmd, byte[] data) {
        byte[] req = new byte[6 + (data != null ? data.length : 0)];
        req[0] = BU.c((int)cmd);
        req[1] = BU.c((int)req.length);
        req[2] = BU.c((int)(req.length >> 8));
        req[3] = BU.c((int)this.sync);
        req[4] = BU.c((int)(this.sync >> 8));
        if (data != null) {
            System.arraycopy(data, 0, req, 5, data.length);
        }
        req[req.length - 1] = this.calcCrc(req);
        return req;
    }

    private byte calcCrc(byte[] msg) {
        byte res = msg[0];
        for (int i = 1; i < msg.length - 1; ++i) {
            res = BU.c((int)(res ^ msg[i]));
        }
        return res;
    }
}

