/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.leokas;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.kkm.leokas.Connector;
import ru.softlogic.hardware.device.print.kkm.leokas.LeoFile;
import ru.softlogic.hardware.device.print.kkm.leokas.LeoU;
import ru.softlogic.hardware.device.print.kkm.leokas.PaymentTool;
import ru.softlogic.hardware.device.print.kkm.leokas.ReportType;
import ru.softlogic.hardware.device.print.kkm.leokas.Result;
import ru.softlogic.hardware.device.print.kkm.leokas.Status;
import ru.softlogic.hardware.utils.StringUtils;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Api {
    private static final String ENCODING = "cp1251";
    private final SerialPort port;
    private final Logger log = Logger.getLogger((String)"print");
    private final Connector conn;

    public Api(SerialPort port) {
        if (port == null) {
            throw new NullPointerException("Port is null");
        }
        this.port = port;
        this.conn = new Connector(port);
    }

    public void open() throws IOException {
        this.port.open();
    }

    public void close() {
        this.port.close();
    }

    public int addOperation(long goodCode, int qty, int price) throws IOException {
        if (goodCode < 0L || qty < 0 || price < 0) {
            throw new IllegalArgumentException("Params must be positive");
        }
        byte[] data = new byte[16];
        BU.sile8((byte[])data, (int)0, (long)goodCode);
        BU.sile((byte[])data, (int)8, (int)qty);
        BU.sile((byte[])data, (int)12, (int)price);
        return this.conn.send(2, data).getError();
    }

    public int addRecepientData(int type, String data) throws IOException {
        byte[] rawData = new byte[64];
        rawData[0] = (byte)type;
        String n = StringUtils.getStringByLen(data, 63);
        n = n.replaceFirst("\\s*$", "\u0000");
        System.arraycopy(n.getBytes(ENCODING), 0, rawData, 1, n.length());
        return this.conn.send(119, rawData, 2000).getError();
    }

    public int addOperation(long goodCode, int price, int tax, long bankCode, int bankMFO, String bankName, String recpCode, String recpName) throws IOException {
        if (goodCode < 0L || price < 0) {
            throw new IllegalArgumentException("Params must be positive");
        }
        byte[] data = new byte[128];
        BU.sile8((byte[])data, (int)0, (long)goodCode);
        BU.sile((byte[])data, (int)8, (int)price);
        data[12] = BU.c((int)tax);
        BU.sile8((byte[])data, (int)13, (long)bankCode);
        BU.sile((byte[])data, (int)21, (int)bankMFO);
        String bankName48 = StringUtils.getStringByLen(bankName, 48).replaceFirst("\\s*$", "\u0000");
        String recpCode10 = StringUtils.getStringByLen(recpCode, 10).replaceFirst("\\s*$", "\u0000");
        String recpName45 = StringUtils.getStringByLen(recpName, 45).replaceFirst("\\s*$", "\u0000");
        System.arraycopy(bankName48.getBytes(ENCODING), 0, data, 25, bankName48.length());
        System.arraycopy(recpCode10.getBytes(ENCODING), 0, data, 73, recpCode10.length());
        System.arraycopy(recpName45.getBytes(ENCODING), 0, data, 83, recpName45.length());
        return this.conn.send(118, data, 2000).getError();
    }

    public int addOperation(long goodCode, int qty, int price, int group, int taxId, String unit, String name) throws IOException {
        if (goodCode < 0L || qty < 0 || price < 0) {
            throw new IllegalArgumentException("Params must be positive");
        }
        String u = StringUtils.getStringByLen(unit, 3);
        String n = StringUtils.getStringByLen(name, 70);
        byte[] data = new byte[91];
        BU.sile8((byte[])data, (int)0, (long)goodCode);
        BU.sile((byte[])data, (int)8, (int)qty);
        BU.sile((byte[])data, (int)12, (int)price);
        data[16] = BU.c((int)group);
        data[17] = BU.c((int)taxId);
        System.arraycopy(u.getBytes(ENCODING), 0, data, 18, u.length());
        System.arraycopy(n.getBytes(ENCODING), 0, data, 21, n.length());
        return this.conn.send(3, data, 2000).getError();
    }

    public int regUser(int userId, int passwd) throws IOException {
        if (userId < 0 || userId > 16) {
            throw new IllegalArgumentException("User id must be in range 0..16");
        }
        byte[] data = new byte[5];
        data[0] = BU.c((int)userId);
        BU.ssle((byte[])data, (int)1, (int)passwd);
        return this.conn.send(23, data).getError();
    }

    public int openShift() throws IOException {
        return this.conn.send(18).getError();
    }

    public Status getStatus() throws IOException {
        return new Status(this.conn.send(99).getStatus());
    }

    public void getBlockTime() throws IOException {
        this.conn.send(40);
    }

    public int getFreeZCnt() throws IOException {
        return BU.csle((byte[])this.conn.send(98).getData(), (int)0);
    }

    public int openDoc() throws IOException {
        return this.conn.send(10).getError();
    }

    public int prgPtks(long num, int passw) throws IOException {
        byte[] data = new byte[13];
        data[0] = 64;
        BU.sile((byte[])data, (int)1, (int)passw);
        BU.sile8((byte[])data, (int)5, (long)num);
        return this.conn.send(4, data).getError();
    }

    public int closeDoc() throws IOException {
        return this.conn.send(12).getError();
    }

    public int getProcNumber() throws IOException {
        Result res = this.conn.send(248);
        this.log.info((Object)new String(res.getData()));
        return res.getError();
    }

    public int printLine(String text) throws IOException {
        String s = StringUtils.getStringByLen(text, 64);
        byte[] data = new byte[1 + s.length()];
        data[0] = 0;
        System.arraycopy(s.getBytes(ENCODING), 0, data, 1, s.length());
        return this.conn.send(11, data).getError();
    }

    public int printLine44(String text) throws IOException {
        String s = StringUtils.getStringByLen(text, 44);
        return this.conn.send(13, s.getBytes(ENCODING)).getError();
    }

    public int printLine64(String text) throws IOException {
        String s = StringUtils.getStringByLen(text, 64);
        return this.conn.send(43, s.getBytes(ENCODING)).getError();
    }

    public int openReceipt() throws IOException {
        return this.conn.send(8).getError();
    }

    public int closeReceipt() throws IOException {
        return this.conn.send(9).getError();
    }

    public int cancelReceipt() throws IOException {
        return this.conn.send(25).getError();
    }

    public Result readTable(int tableId, int rowId) throws IOException {
        byte[] data = new byte[5];
        data[0] = BU.c((int)tableId);
        BU.sile((byte[])data, (int)1, (int)rowId);
        return this.conn.send(5, data);
    }

    public int setDateTime(int year, int month, int day, int hour, int min, int sec) throws IOException {
        byte[] data = new byte[]{BU.c((int)day), BU.c((int)(month + 1)), BU.c((int)(year - 2000)), 0, BU.c((int)hour), BU.c((int)min), BU.c((int)sec), 0};
        return this.conn.send(35, data).getError();
    }

    public int payment(PaymentTool paymentTool, int sum) throws IOException {
        byte[] data = new byte[5];
        data[0] = BU.c((int)paymentTool.getCode());
        BU.sile((byte[])data, (int)1, (int)sum);
        return this.conn.send(15, data).getError();
    }

    public int beep(int freq, int durable) throws IOException {
        if (freq < 0 || durable < 0) {
            throw new IllegalArgumentException("Params must be positive");
        }
        byte[] data = new byte[4];
        BU.ssle((byte[])data, (int)0, (int)freq);
        BU.ssle((byte[])data, (int)2, (int)durable);
        return this.conn.send(2, data).getError();
    }

    public int printReport(ReportType reportType) throws IOException {
        return this.conn.send(16, new byte[]{BU.c((int)reportType.getCode())}).getError();
    }

    public Result printReportWithResult(ReportType reportType) throws IOException {
        return this.conn.send(16, new byte[]{BU.c((int)reportType.getCode())});
    }

    public Status getLastStatus() {
        return this.conn.getLastStatus();
    }

    public LeoFile fileFindFirst(String mask) throws IOException {
        return this.fileFindFirst(0, 0, mask);
    }

    public LeoFile fileFindFirst(int passw, int drive, String mask) throws IOException {
        byte[] data = new byte[70];
        data[0] = 10;
        BU.sile((byte[])data, (int)1, (int)passw);
        data[5] = BU.c((int)drive);
        mask = mask == null || mask.isEmpty() ? "*" : mask;
        System.arraycopy(LeoU.convert(mask, 64), 0, data, 6, 64);
        Result r = this.conn.send(42, data);
        if (r == null) {
            return null;
        }
        if (r.getError() == 703) {
            return null;
        }
        return LeoU.parse(r.getData());
    }

    public List<LeoFile> getFiles() throws IOException {
        return this.getFiles("*");
    }

    public List<LeoFile> getFiles(String mask) throws IOException {
        ArrayList<LeoFile> files = new ArrayList<LeoFile>();
        LeoFile lf = this.fileFindFirst(mask);
        if (lf != null) {
            files.add(lf);
            while ((lf = this.fileFindNext()) != null) {
                files.add(lf);
            }
        }
        return files;
    }

    public LeoFile fileFindNext() throws IOException {
        return this.fileFindNext(0);
    }

    public LeoFile fileFindNext(int passw) throws IOException {
        byte[] data = new byte[5];
        data[0] = 11;
        BU.sile((byte[])data, (int)1, (int)passw);
        Result r = this.conn.send(42, data);
        if (r == null) {
            return null;
        }
        if (r.getError() == 703) {
            return null;
        }
        return LeoU.parse(r.getData());
    }

    public File copy(String srcFileName, String destPath, int len) throws IOException {
        Result res = this.getCWD(0, 0);
        String path = null;
        if (res.getError() != 0) {
            return null;
        }
        path = LeoU.convertString(res.getData());
        byte[] read = this.read(path + "\\" + srcFileName, len);
        File dest = new File(destPath + "/" + srcFileName);
        try (FileOutputStream fos = new FileOutputStream(dest);){
            fos.write(read);
            fos.flush();
        }
        catch (FileNotFoundException ex) {
            this.log.error((Object)ex);
            return null;
        }
        return dest;
    }

    public Result getCWD(int drive, int passw) throws IOException {
        byte[] data = new byte[6];
        data[0] = 3;
        BU.sile((byte[])data, (int)1, (int)passw);
        data[5] = BU.c((int)drive);
        return this.conn.send(42, data);
    }

    public Result getFileLength(int drive, int passw, String filePath) throws IOException {
        byte[] data = new byte[70];
        data[0] = 7;
        BU.sile((byte[])data, (int)1, (int)passw);
        data[5] = BU.c((int)drive);
        System.arraycopy(StringUtils.getStringByLen(filePath, 64).getBytes(), 0, data, 6, 64);
        return this.conn.send(42, data);
    }

    public byte[] read(String path, int len) throws IOException {
        return this.read(0, 0, path, len);
    }

    public byte[] read(int drive, int passw, String path, int len) throws IOException {
        int rest;
        Result r;
        byte[] res = new byte[len];
        int blockCnt = len / 128;
        for (int i = 0; i < blockCnt; ++i) {
            r = this.read(drive, passw, path, (long)i * 128L, 128L);
            if (r.getData() != null) {
                System.arraycopy(r.getData(), 0, res, i * 128, r.getData().length);
            }
            if (r.getError() != 0) break;
        }
        if ((rest = len - blockCnt * 128) != 0 && (r = this.read(drive, passw, path, (long)blockCnt * 128L, 128L)).getData() != null) {
            System.arraycopy(r.getData(), 0, res, blockCnt * 128, r.getData().length);
        }
        return res;
    }

    public Result read(int drive, int passw, String path, long offset, long len) throws IOException {
        byte[] data = new byte[78];
        data[0] = 4;
        BU.sile((byte[])data, (int)1, (int)passw);
        data[5] = BU.c((int)drive);
        System.arraycopy(StringUtils.getStringByLen(path, 64).getBytes(), 0, data, 6, 64);
        BU.sile((byte[])data, (int)70, (int)((int)offset));
        BU.sile((byte[])data, (int)74, (int)((int)len));
        return this.conn.send(42, data);
    }
}

