/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.iskra;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.Tags;
import ru.softlogic.hardware.device.print.kkm.iskra.IskraApi;
import ru.softlogic.hardware.device.print.kkm.iskra.IskraApiListener;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.api.BasePrinterApi;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;

public class IskraPrinter
extends BasePrinterApi {
    private IskraApi api;
    private Logger log;
    protected Map<Tags, String> tags;
    private byte[] printerStatus;

    public IskraPrinter(SerialPort port, String password) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043f\u043e\u0440\u0442\u0435");
        }
        this.api = new IskraApi(port, password);
        this.api.addListener(new LocalApiListener());
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.tags = new EnumMap<Tags, String>(Tags.class);
        this.tags.put(Tags.BoldBegin, "");
        this.tags.put(Tags.BoldEnd, "");
        this.tags.put(Tags.UnderLineBegin, "");
        this.tags.put(Tags.UnderLineEnd, "");
        this.tags.put(Tags.AlignCenter, "");
        this.tags.put(Tags.AlignLeft, "");
        this.tags.put(Tags.AlignRight, "");
        this.tags.put(Tags.SmallBegin, "");
        this.tags.put(Tags.SmallEnd, "");
        this.tags.put(Tags.Br, "\n");
    }

    @Override
    public void init(PosPrinterOptions options) throws IOException {
        this.api.openTextDocument();
    }

    @Override
    public void print(String text) throws IOException {
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442");
        if (text != null && !text.isEmpty()) {
            for (Tags tag : Tags.values()) {
                String data = this.tags.get((Object)tag);
                text = text.replace(tag.getString(), data == null ? "" : data);
            }
            Matcher m2 = Pattern.compile(".{1,40}").matcher(text);
            while (m2.find()) {
                String prn = m2.group(0);
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u0442\u0440\u043e\u043a\u0443 " + prn));
                if (prn.length() < 40) {
                    prn = prn.trim();
                }
                int res = this.api.printString(prn);
                this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0435\u0447\u0430\u0442\u0438 \u0441\u0442\u0440\u043e\u043a\u0438: " + res));
            }
        }
        this.log.info((Object)"\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b \u043f\u0435\u0447\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442\u0430");
    }

    @Override
    public void scroll(int scroll) throws IOException {
        for (int i = 0; i < scroll; ++i) {
            this.api.printString("");
        }
    }

    @Override
    public void fullCut() throws IOException {
        this.api.closeTextDocument();
    }

    @Override
    public void partialCut() throws IOException {
        this.api.closeTextDocument();
    }

    @Override
    public String getFirmware() {
        return "n/a";
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        PrinterStatus ps = new PrinterStatus();
        this.api.getDocuments();
        if (this.printerStatus == null || this.printerStatus.length < 5) {
            ps.setOnline(false);
        } else {
            if ((this.printerStatus[0] & 8) > 0) {
                ps.setOnline(false);
            }
            if ((this.printerStatus[3] & 8) > 0) {
                ps.setPaperNearEnd(true);
            }
            if ((this.printerStatus[3] & 0x40) > 0) {
                ps.setPaperEnd(true);
            }
            if ((this.printerStatus[1] & 0x40) > 0) {
                ps.setError(true);
            }
        }
        return ps;
    }

    @Override
    public int getModelId() throws IOException {
        return 0;
    }

    @Override
    public Port getConnection() {
        return this.api.getPort();
    }

    @Override
    public String getVendor() {
        return "\u0418\u0441\u043a\u0440\u0430";
    }

    @Override
    public String getModel() {
        return "\u041f\u0440\u0438\u043c-21\u041a";
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void dispense(int steps) throws IOException {
    }

    static /* synthetic */ byte[] access$202(IskraPrinter x0, byte[] x1) {
        x0.printerStatus = x1;
        return x1;
    }

    private class LocalApiListener
    implements IskraApiListener {
        private LocalApiListener() {
        }

        @Override
        public void onStatus(int constantStatus, int currentStatus, byte[] printStatus) {
            IskraPrinter.this.log.debug((Object)("\u041d\u043e\u0432\u043e\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043f\u0435\u0447\u0430\u0442\u0430\u044e\u0449\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430: " + Arrays.toString(printStatus)));
            IskraPrinter.access$202(IskraPrinter.this, printStatus);
        }
    }
}

