/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.iskra;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.Tags;
import ru.softlogic.hardware.device.print.kkm.BaseKkm;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.kkm.iskra.Documents;
import ru.softlogic.hardware.device.print.kkm.iskra.Information;
import ru.softlogic.hardware.device.print.kkm.iskra.IskraApi;
import ru.softlogic.hardware.device.print.kkm.iskra.IskraApiListener;
import ru.softlogic.hardware.device.print.kkm.iskra.IskraPrinter;
import ru.softlogic.hardware.device.print.kkm.iskra.PaymentInstrument;
import ru.softlogic.hardware.device.print.kkm.iskra.Resources;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderManager;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.ThreadUtil;

public class IskraKkm
extends BaseKkm {
    private SerialPort port;
    private IskraApi api;
    private IskraPrinter printer;
    private Logger log;
    private ResourceBundle bundle;
    private DeviceInfo deviceInfo;
    private int constantStatus;
    private int currentStatus;
    private byte[] printerStatus;
    private Map<Tags, String> tags;
    private String path;
    private List<Short> numbers;
    private String software;
    private boolean globalError;
    private KkmOptions options;

    public IskraKkm(SerialPort port, String path, KkmOptions options) {
        super(DeviceType.IskraKkm, port, options);
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.port = port;
        this.path = path;
        this.options = options;
        this.api = new IskraApi(port, options.getAdminPassword());
        this.api.addListener(new LocalApiListener());
        this.printer = new IskraPrinter(port, options.getAdminPassword());
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.bundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.print.kkm.kkm");
        this.deviceInfo = new DeviceInfo(DeviceType.IskraKkm);
        this.deviceInfo.setVendor("\u0418\u0441\u043a\u0440\u0430");
        this.deviceInfo.setPort(port.getName());
        this.tags = new EnumMap<Tags, String>(Tags.class);
        this.tags.put(Tags.BoldBegin, "");
        this.tags.put(Tags.BoldEnd, "");
        this.tags.put(Tags.UnderLineBegin, "");
        this.tags.put(Tags.UnderLineEnd, "");
        this.tags.put(Tags.AlignCenter, "");
        this.tags.put(Tags.AlignLeft, "");
        this.tags.put(Tags.AlignRight, "");
        this.tags.put(Tags.SmallBegin, "");
        this.tags.put(Tags.SmallEnd, "");
        this.tags.put(Tags.Br, "\n");
        this.numbers = this.getNumbers();
    }

    @Override
    public ReportResult formReportX() throws IOException {
        this.log.info((Object)"\u0424\u043e\u0440\u043c\u0438\u0440\u0443\u044e X-\u043e\u0442\u0447\u0435\u0442");
        int res = this.api.reportX();
        this.addRes(res);
        return new ReportResult(res, res != 0, this.getMessage(res));
    }

    @Override
    public ReportResult formReportZ() throws IOException {
        this.log.info((Object)"\u0424\u043e\u0440\u043c\u0438\u0440\u0443\u044e Z-\u043e\u0442\u0447\u0435\u0442");
        int res = this.api.reportZ();
        this.addRes(res);
        ReportResult rr = new ReportResult(res, res != 0, this.getMessage(res));
        if (res == 0) {
            this.log.info((Object)("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043d\u043e\u043c\u0435\u0440\u0430\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432: " + this.api.getResources()));
        }
        return rr;
    }

    @Override
    public ReportResult formReportZMem() throws IOException {
        if (this.numbers != null) {
            this.log.info((Object)("\u0418\u043c\u0435\u044e\u0442\u0441\u044f \u043d\u043e\u043c\u0435\u0440\u0430 \u043e\u0442\u0447\u0435\u0442\u043e\u0432: " + this.numbers));
            Iterator<Short> it = this.numbers.iterator();
            while (it.hasNext()) {
                Short n = it.next();
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043e\u0442\u0447\u0435\u0442: " + n));
                int res = this.api.printReportsFromMemory(n);
                this.addRes(res);
                if (res != 0) {
                    return new ReportResult(res, res != 0, this.getMessage(res));
                }
                this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e, \u0443\u0434\u0430\u043b\u044f\u044e \u043d\u043e\u043c\u0435\u0440 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430");
                it.remove();
                this.log.info((Object)"\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043d\u0430 \u0434\u0438\u0441\u043a");
                this.updateData();
            }
            return new ReportResult(0, false, this.getMessage(0));
        }
        Resources resources = this.api.getResources();
        if (resources.getError() == 0) {
            this.log.info((Object)("\u041d\u043e\u043c\u0435\u0440 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0439 \u0441\u043c\u0435\u043d\u044b: " + resources.getzReportLastNumber()));
            for (int i = resources.getzReportLastNumber(); i > resources.getzReportLastNumber() - 5 && i > 0; --i) {
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043e\u0442\u0447\u0435\u0442 : " + i));
                int res = this.api.printReportsFromMemory((short)i);
                this.addRes(res);
                if (res == 0) continue;
                return new ReportResult(res, res != 0, this.getMessage(res));
            }
            this.log.info((Object)"\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043d\u0430 \u0434\u0438\u0441\u043a");
            this.numbers = new LinkedList<Short>();
            this.updateData();
            return new ReportResult(0, false, this.getMessage(0));
        }
        return new ReportResult(resources.getError(), resources.getError() != 0, this.getMessage(resources.getError()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Operation operation, RenderData data) throws IOException {
        if (this.isSupportedNotFiscalMode() && Boolean.TRUE.equals(operation.getService().isNotFiscal())) {
            this.printNotFiscal(operation, data);
            return;
        }
        this.log.info((Object)"Begin------------------------------------------------------");
        try {
            int res;
            this.validateState();
            SumResult sr = operation.getSumResult();
            if (this.options != null && this.options.getPresenterMode() != null) {
                if (this.options.getPresenterMode() == 1) {
                    this.log.info((Object)"\u0417\u0430\u0431\u0438\u0440\u0430\u0435\u043c \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u0447\u0435\u043a");
                    res = this.api.managementPresenter((short)0, (short)0, (short)1);
                    this.addRes(res);
                } else if (this.options.getPresenterMode() == 2) {
                    this.log.info((Object)"\u0412\u044b\u043f\u043b\u0435\u0432\u044b\u0432\u0430\u0435\u043c \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u0447\u0435\u043a");
                    res = this.api.managementPresenter((short)1, (short)0, (short)1);
                    this.addRes(res);
                }
            }
            if (sr.getCash().getBasicSum() > 0 && !operation.isCopy()) {
                String[] str;
                String text;
                res = this.openCheck(operation, (byte)0);
                this.addRes(res);
                if (res != 0) {
                    this.notifyError(operation, "openCheck", res);
                }
                if (data.isUseFiscalDepartments()) {
                    if (operation.getSumResult().getOut().getBasicSum() > 0) {
                        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430)");
                        res = this.api.addOperation(operation.getService().getPrintName(), operation.getService().getId(), operation.getSumResult().getOut().getBasicSum(), 1000, (byte)1);
                        this.addRes(res);
                        if (res != 0) {
                            this.notifyError(operation, "addOperation", res);
                        }
                    }
                    if (operation.getSumResult().getCommission().getBasicSum() > 0) {
                        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044f)");
                        res = this.api.addOperation(this.bundle.getString("comission"), 0, operation.getSumResult().getCommission().getBasicSum(), 1000, (byte)2);
                        this.addRes(res);
                        if (res != 0) {
                            this.notifyError(operation, "addOperation", res);
                        }
                    }
                } else if (operation.getSumResult().getOut().getBasicSum() + operation.getSumResult().getCommission().getBasicSum() > 0) {
                    this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430+\u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044f)");
                    res = this.api.addOperation(operation.getService().getPrintName(), operation.getService().getId(), operation.getSumResult().getOut().getBasicSum() + operation.getSumResult().getCommission().getBasicSum(), 1000, (byte)1);
                    this.addRes(res);
                    if (res != 0) {
                        this.notifyError(operation, "addOperation", res);
                    }
                }
                if (operation.getSumResult().getChange().getBasicSum() > 0) {
                    this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u043a\u0430\u0440\u0442\u0430 \u0441\u0434\u0430\u0447\u0438)");
                    res = this.api.addOperation(this.bundle.getString("change"), 0, operation.getSumResult().getChange().getBasicSum(), 1000, (byte)1);
                    this.addRes(res);
                    if (res != 0) {
                        this.notifyError(operation, "addOperation", res);
                    }
                }
                this.log.info((Object)"\u0420\u0430\u0441\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u044e \u0438\u0442\u043e\u0433 \u0447\u0435\u043a\u0430");
                res = this.api.calcTotal();
                this.addRes(res);
                if (res != 0) {
                    this.notifyError(operation, "calcTotal", res);
                }
                if (sr.getCash().getBasicSum() > 0) {
                    this.log.info((Object)("\u0412\u043d\u043e\u0441\u0438\u043c \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u0434\u0435\u043d\u044c\u0433\u0438: " + sr.getCash()));
                    res = this.api.addCash((byte)0, sr.getCash().getBasicSum(), "");
                    this.addRes(res);
                    if (res != 0) {
                        this.notifyError(operation, "addCash", res);
                    }
                }
                if (sr.getCashLess().getBasicSum() > 0) {
                    this.log.info((Object)("\u0412\u043d\u043e\u0441\u0438\u043c \u0431\u0435\u0437\u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u0434\u0435\u043d\u044c\u0433\u0438: " + sr.getCashLess()));
                    res = this.api.addCash((byte)1, sr.getCashLess().getBasicSum(), "");
                    this.addRes(res);
                    if (res != 0) {
                        this.notifyError(operation, "addCashless", res);
                    }
                }
                String string = text = (str = RenderManager.renderingOperation(DeviceType.IskraKkm, operation, data)) != null && str.length > 0 ? str[0] : "";
                if (text != null && !text.isEmpty()) {
                    for (Tags tag : Tags.values()) {
                        String d = this.tags.get((Object)tag);
                        text = text.replace(tag.getString(), d == null ? "" : d);
                    }
                    Matcher m2 = Pattern.compile(".{1,40}").matcher(text);
                    while (m2.find()) {
                        String prn = m2.group(0);
                        this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u0442\u0440\u043e\u043a\u0443 " + prn));
                        if (prn.length() < 40) {
                            prn = prn.trim();
                        }
                        res = this.api.addString(prn);
                        this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0435\u0447\u0430\u0442\u0438 \u0441\u0442\u0440\u043e\u043a\u0438: " + res));
                    }
                }
                if (this.options != null && this.options.getScroll() != null && this.options.getScroll() > 0) {
                    this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.options.getScroll()));
                    for (int i = 0; i < this.options.getScroll(); ++i) {
                        this.api.addString(" ");
                    }
                }
                this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                res = this.api.closeCheck();
                this.addRes(res);
                if (res != 0) {
                    this.notifyError(operation, "closeCheck", res);
                }
            } else {
                String[] str = RenderManager.renderingOperation(DeviceType.IskraPrinter, operation, data);
                this.printer.print(str != null && str.length > 0 ? str[0] : "");
                this.printer.scroll(4);
                this.printer.fullCut();
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430/\u0432\u044b\u0432\u043e\u0434\u0430 \u043f\u0440\u0438 \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430", (Throwable)ex);
            this.notifyOperationError(operation, null, ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a", (Throwable)ex);
        }
        finally {
            this.log.info((Object)"End--------------------------------------------------------");
        }
    }

    @Override
    public void print(MoneyCollection moneyCollection, RenderData data) throws IOException {
        this.printer.init(new PosPrinterOptions());
        String[] res = RenderManager.renderingMoneyCollection(DeviceType.IskraKkm, moneyCollection, data);
        if (res != null && res.length > 0) {
            this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0447\u0435\u043a\u043e\u0432 " + res.length));
            for (int i = 0; i < res.length; ++i) {
                String str;
                if (i != 0) {
                    ThreadUtil.sleep((long)3000L);
                }
                if ((str = res[i]) == null || str.trim().isEmpty()) continue;
                this.printer.print(str);
                this.printer.fullCut();
            }
        }
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        this.api.ping();
        PrinterStatus ps = new PrinterStatus();
        if ((this.constantStatus & 1) > 0) {
            ps.setError(true);
        }
        if ((this.constantStatus & 2) > 0) {
            ps.setError(true);
        }
        if ((this.constantStatus & 2) > 0) {
            ps.setError(true);
        }
        if ((this.constantStatus & 0x20) > 0) {
            ps.setError(true);
        }
        if ((this.currentStatus & 0x80) > 0) {
            ps.setError(true);
        }
        if ((this.currentStatus & 0x200) > 0) {
            ps.setError(true);
        }
        if ((this.printerStatus[0] & 8) > 0) {
            ps.setOnline(false);
        }
        if ((this.printerStatus[3] & 8) > 0) {
            ps.setPaperNearEnd(true);
            if ("1.2LPC21 01-08-04".equals(this.software)) {
                ps.setError(true);
            }
        }
        if ((this.printerStatus[3] & 0x40) > 0) {
            ps.setPaperEnd(true);
        }
        if ((this.printerStatus[1] & 0x40) > 0) {
            ps.setError(true);
        }
        if (this.globalError) {
            ps.setError(true);
        }
        return ps;
    }

    @Override
    public short nextCheckNumber() {
        try {
            Documents doc = this.api.getDocuments();
            return (short)(doc.getCheckNo() + 1 & 0xFFFF);
        }
        catch (IOException ex) {
            return 0;
        }
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void init() throws IOException {
        this.validateState();
        this.log.info((Object)("\u0424\u0430\u0439\u043b \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u043c\u0435\u043d: " + this.path));
        this.log.info((Object)("\u0421\u043f\u0438\u0441\u043e\u043a \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0445 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c \u0441\u043c\u0435\u043d: " + this.numbers));
        this.log.info((Object)("\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0441\u0435\u0441\u0441\u0438\u044e: " + this.getMessage(this.api.beginSession())));
        short[] res = this.api.getDocumentParams();
        this.log.info((Object)("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432: " + Arrays.toString(res)));
        boolean changeDocs = false;
        if ((res[0] & 2) == 0) {
            this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0444\u043b\u0430\u0433: \u041d\u0435 \u0432\u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c \u043f\u0443\u0441\u0442\u0443\u044e \u0441\u0442\u0440\u043e\u043a\u0443 \u043c\u0435\u0436\u0434\u0443 \u043f\u0440\u043e\u0434\u0430\u0436\u0430\u043c\u0438");
            res[0] = (short)(res[0] | 2);
            changeDocs = true;
        }
        if ((res[0] & 4) == 0) {
            this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0444\u043b\u0430\u0433: \u041d\u0435 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u044b\u0435 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0438 \u0432 z-\u043e\u0442\u0447\u0435\u0442\u0435");
            res[0] = (short)(res[0] | 4);
            changeDocs = true;
        }
        if ((res[0] & 0x20) == 0) {
            this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0444\u043b\u0430\u0433: \u041d\u0435 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043e \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u0445");
            res[0] = (short)(res[0] | 0x20);
            changeDocs = true;
        }
        if ((res[0] & 0x40) == 0) {
            this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0444\u043b\u0430\u0433: \u041d\u0435 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0435\u0441\u043b\u0438 \u043e\u043d\u043e \u0440\u0430\u0432\u043d\u043e 1");
            res[0] = (short)(res[0] | 0x40);
            changeDocs = true;
        }
        if ((res[0] & 0x100) == 0) {
            this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0444\u043b\u0430\u0433: \u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043c\u0435\u043d\u044b \u043f\u0435\u0440\u0432\u044b\u043c \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u043c");
            res[0] = (short)(res[0] | 0x100);
            changeDocs = true;
        }
        if ((res[1] & 1) == 0) {
            this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0444\u043b\u0430\u0433: \u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0441\u043c\u0435\u043d\u044b");
            res[1] = (short)(res[1] | 1);
            changeDocs = true;
        }
        if ((res[1] & 0x100) == 0) {
            this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0444\u043b\u0430\u0433: \u041f\u0435\u0447\u0430\u0442\u044c z-\u043e\u0442\u0447\u0435\u0442\u0430 \u043f\u043e \u043e\u0442\u0434\u0435\u043b\u0430\u043c");
            res[1] = (short)(res[1] | 0x100);
            changeDocs = true;
        }
        if ((res[1] & 0x800) != 0) {
            this.log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e \u0444\u043b\u0430\u0433: \u041f\u0435\u0447\u0430\u0442\u044c \u0447\u0435\u043a \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u043c\u0435\u043d\u044b");
            res[1] = (short)(res[1] & 0xFFFFF7FF);
            changeDocs = true;
        }
        if (res[2] != 0) {
            this.log.info((Object)"\u041c\u0435\u043d\u044f\u044e \u043c\u0435\u0436\u0441\u0442\u0440\u043e\u0447\u043d\u044b\u0439 \u043e\u0442\u0441\u0442\u0443\u043f");
            changeDocs = true;
        }
        boolean changeSections = false;
        Map<Integer, String> sections = this.api.getSections();
        this.log.info((Object)("\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0442\u0434\u0435\u043b\u043e\u0432: " + sections));
        if (sections == null || !"\u041e\u041f\u0415\u0420\u0410\u0426\u0418\u0418".equals(sections.get(1)) || !"\u041a\u041e\u041c\u0418\u0421\u0421\u0418\u042f".equals(sections.get(2))) {
            this.log.info((Object)"\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0439 \u043e\u0442\u0434\u0435\u043b\u043e\u0432");
            changeSections = true;
        }
        boolean changeInstruments = false;
        this.log.info((Object)("\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0445 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u043e\u0442\u0434\u0435\u043b\u043e\u0432: " + sections));
        PaymentInstrument pi00 = this.api.getPaymentInstrument(0);
        this.log.info((Object)("\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 0: " + pi00));
        if (!"\u041d\u0410\u041b\u0418\u0427\u041d\u042b\u0415:".equals(pi00.getName()) || pi00.getSdacha() != 1 || pi00.getMask() != 7) {
            this.log.info((Object)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u044f \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u0430");
            changeInstruments = true;
        }
        PaymentInstrument pi01 = this.api.getPaymentInstrument(1);
        this.log.info((Object)("\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 1: " + pi01));
        if (!"\u041a\u0410\u0420\u0422\u0410 \u0421\u0414\u0410\u0427\u0418:".equals(pi01.getName()) || pi01.getSdacha() != 0 || pi01.getMask() != 7) {
            this.log.info((Object)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u044f \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u0430");
            changeInstruments = true;
        }
        if (changeDocs || changeSections || changeInstruments) {
            int r;
            if ((this.currentStatus & 0x800) > 0) {
                this.log.info((Object)"\u0421\u043c\u0435\u043d\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0430. \u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0441\u043c\u0435\u043d\u0443 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
                r = this.api.putReportToMemory();
                this.addRes(r);
            }
            if (changeDocs) {
                this.log.info((Object)"\u0417\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u043d\u043e\u0432\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
                r = this.api.setDocumentParams(res[0], res[1], (short)0);
                this.addRes(r);
            }
            if (changeSections) {
                this.log.info((Object)"\u0417\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u043d\u043e\u0432\u044b\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u043e\u0442\u0434\u0435\u043b\u043e\u0432");
                HashMap<Integer, String> prog = new HashMap<Integer, String>();
                prog.put(1, "\u041e\u041f\u0415\u0420\u0410\u0426\u0418\u0418");
                prog.put(2, "\u041a\u041e\u041c\u0418\u0421\u0421\u0418\u042f");
                int r2 = this.api.setSections(prog);
                this.addRes(r2);
            }
            if (changeInstruments) {
                this.log.info((Object)"\u0417\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u043d\u043e\u0432\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0445 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432, \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u0441 \u043a\u043e\u0434\u043e\u043c 0(\u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435)");
                pi00 = new PaymentInstrument();
                pi00.setId(0);
                pi00.setName("\u041d\u0410\u041b\u0418\u0427\u041d\u042b\u0415:");
                pi00.setTwoLines(0);
                pi00.setSdacha(1);
                pi00.setCurrency(0);
                pi00.setMask(7);
                pi00.setCourse(100);
                int r3 = this.api.setPaymentInstrument(pi00);
                this.addRes(r3);
                this.log.info((Object)"\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u0441 \u043a\u043e\u0434\u043e\u043c 1(\u043a\u0430\u0440\u0442\u0430 \u0441\u0434\u0430\u0447\u0438)");
                pi01 = new PaymentInstrument();
                pi01.setId(1);
                pi01.setName("\u041a\u0410\u0420\u0422\u0410 \u0421\u0414\u0410\u0427\u0418:");
                pi01.setTwoLines(0);
                pi01.setSdacha(0);
                pi01.setCurrency(0);
                pi01.setMask(7);
                pi01.setCourse(100);
                r3 = this.api.setPaymentInstrument(pi01);
                this.addRes(r3);
            }
        }
        Information information = this.api.getInformation();
        this.log.info((Object)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u041a\u041a\u041c:");
        this.log.info((Object)("    \u041c\u043e\u0434\u0435\u043b\u044c: " + information.getModel()));
        this.log.info((Object)("    \u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e: " + information.getSoftware()));
        this.log.info((Object)("    \u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440: " + information.getRegisrationNumber()));
        this.log.info((Object)("    \u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u041a\u041a\u041c: " + information.getKkmSerial()));
        this.log.info((Object)("    \u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0424\u041f: " + information.getMemSerial()));
        this.log.info((Object)("    \u0418\u041d\u041d: " + information.getInn()));
        this.deviceInfo.setModel(information.getModel());
        this.deviceInfo.setFirmware(information.getSoftware());
        this.deviceInfo.setSerial("kkm=" + information.getKkmSerial() + "/mem=" + information.getMemSerial());
        this.software = information.getSoftware();
        Resources resources = this.api.getResources();
        if (resources.getError() == 0) {
            this.log.info((Object)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u0445:");
            this.log.info((Object)("    \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0441\u0442\u0430\u0432\u0448\u0438\u0445\u0441\u044f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0439: " + resources.getRegistrationRest()));
            this.log.info((Object)("    \u041d\u043e\u043c\u0435\u0440 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e Z-\u043e\u0442\u0447\u0435\u0442\u0430: " + resources.getzReportLastNumber()));
            this.log.info((Object)("    \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432: " + resources.getzReportRest()));
        } else {
            this.log.error((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u0445");
            this.addRes(resources.getError());
        }
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public boolean isOpen() {
        return this.port.isOpen();
    }

    @Override
    public DeviceInfo getInfo() {
        return this.deviceInfo;
    }

    private void addRes(int result) {
        this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + result + ", message=" + this.getMessage(result)));
    }

    private String getMessage(int error) {
        ResourceBundle b = ResourceBundle.getBundle("ru.softlogic.hardware.device.print.kkm.iskra.messages");
        try {
            return b.getString(String.format("%d", error));
        }
        catch (Throwable ex) {
            return b.getString("undefined");
        }
    }

    private void notifyError(Operation op, String procedure, int result) throws Exception {
        this.notifyOperationError(op, procedure, this.getMessage(result));
        throw new Exception("Can't print document,proc=" + procedure + ",res=" + result);
    }

    private int processError(int error) throws IOException {
        this.log.info((Object)("\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u0443\u0441\u0442\u0440\u0430\u043d\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0443: " + error));
        if (error == 21) {
            return this.closeReportZToMem().getResult();
        }
        if (error == 7) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443 '\u043d\u0430\u0447\u0430\u043b\u043e \u0441\u0435\u0430\u043d\u0441\u0430'");
            int res = this.api.beginSession();
            this.addRes(res);
            return res;
        }
        if (error == 37) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443 '\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u043c\u0435\u043d\u0443'");
            int res = this.api.openShift();
            this.addRes(res);
            return res;
        }
        if (error == 55) {
            this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0424\u0420\u0430");
            this.globalError = true;
        }
        return error;
    }

    private void validateState() throws IOException {
        this.api.ping();
        if ((this.currentStatus & 7) > 0) {
            this.api.cancelCheck();
        }
    }

    private int openCheck(Operation operation, byte type) throws IOException {
        int res = 0;
        for (int i = 0; i < 3; ++i) {
            this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
            res = this.api.openCheck(type);
            this.addRes(res);
            if (res == 0) {
                return res;
            }
            if ((res = this.processError(res)) == 0) continue;
            return res;
        }
        return res;
    }

    @Override
    public void setDefaultValues() {
        this.log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 '\u043f\u043e-\u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e' \u043e\u0442\u0441\u0443\u0441\u0442\u0432\u0443\u044e\u0442");
    }

    @Override
    public void printGroup(GroupOperation operation, RenderData renderData) throws IOException {
        this.print((Operation)operation, renderData);
    }

    @Override
    public ReportResult closeReportZToMem() throws IOException {
        this.log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e Z-\u043e\u0442\u0447\u0435\u0442 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
        int res = this.api.putReportToMemory();
        this.addRes(res);
        Resources resources = this.api.getResources();
        this.log.info((Object)("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043d\u043e\u043c\u0435\u0440\u0430\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432: " + resources));
        if (resources.getError() == 0) {
            this.addNumber((short)resources.getzReportLastNumber());
        }
        return new ReportResult(res, res != 0, this.getMessage(res));
    }

    @Override
    public ReportResult formReportDateRange(Date start, Date finish, boolean shortReport, String password) throws IOException {
        int res = this.api.fiscalReportByDateRange(start, finish, shortReport ? 5 : 4);
        return new ReportResult(res, res != 0, this.getMessage(res));
    }

    @Override
    public void print(CustomData data, RenderData renderData) throws IOException {
        String[] str = RenderManager.renderingCustomData(DeviceType.IskraKkm, data, renderData);
        if (str != null && str.length > 0) {
            this.printer.init(new PosPrinterOptions());
            this.printer.print(str[0]);
            this.printer.scroll(4 + (this.options.getScroll() == null ? 0 : this.options.getScroll()));
            this.printer.fullCut();
        } else {
            this.log.info((Object)"\u041d\u0435\u0447\u0435\u0433\u043e \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c");
        }
    }

    @Override
    public boolean isNeedCorrectTime() throws IOException {
        return false;
    }

    @Override
    public void correctTime() throws IOException, InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Short> getNumbers() {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(this.path));
            Object obj = ois.readObject();
            if (obj instanceof Short[]) {
                LinkedList<Short> data = new LinkedList<Short>();
                data.addAll(Arrays.asList((Short[])obj));
                LinkedList<Short> linkedList = data;
                return linkedList;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private void addNumber(short number) {
        this.log.info((Object)("\u041f\u0440\u043e\u0431\u0443\u044e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u043c\u0435\u043d\u0443 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c: " + number));
        if (this.numbers == null) {
            this.numbers = new LinkedList<Short>();
        }
        if (number > 0) {
            for (Short val : this.numbers) {
                if (val != number) continue;
                this.log.info((Object)"\u041d\u043e\u043c\u0435\u0440 \u0442\u0430\u043a\u043e\u0433\u043e \u043e\u0442\u0447\u0435\u0442\u0430 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0432 \u0441\u043c\u0435\u043d\u0435");
                return;
            }
            this.numbers.add(number);
            this.updateData();
        } else {
            this.log.info((Object)"\u041d\u043e\u043c\u0435\u0440 \u0441\u043c\u0435\u043d\u044b \u043d\u0435\u0432\u0435\u0440\u0435\u043d");
        }
    }

    private void updateData() {
        ObjectOutputStream oos = null;
        try {
            FileUtil.checkFile((String)this.path);
            oos = new ObjectOutputStream(new FileOutputStream(this.path));
            oos.writeObject(this.numbers.toArray(new Short[this.numbers.size()]));
            this.log.info((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0443\u0441\u043f\u0435\u0449\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d");
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445", (Throwable)ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public PrinterType getType() {
        return PrinterType.Kkm;
    }

    static /* synthetic */ byte[] access$402(IskraKkm x0, byte[] x1) {
        x0.printerStatus = x1;
        return x1;
    }

    private class LocalApiListener
    implements IskraApiListener {
        private LocalApiListener() {
        }

        @Override
        public void onStatus(int constantStatus, int currentStatus, byte[] printerStatus) {
            if (IskraKkm.this.constantStatus != constantStatus) {
                IskraKkm.this.log.info((Object)("\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u041a\u041a\u041c =" + constantStatus));
                IskraKkm.this.constantStatus = constantStatus;
            }
            if (IskraKkm.this.currentStatus != currentStatus) {
                IskraKkm.this.log.info((Object)("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u041a\u041a\u041c =" + currentStatus));
                IskraKkm.this.currentStatus = currentStatus;
            }
            if (!Arrays.equals(printerStatus, IskraKkm.this.printerStatus)) {
                IskraKkm.this.log.info((Object)("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 =" + Arrays.toString(printerStatus)));
                IskraKkm.access$402(IskraKkm.this, printerStatus);
            }
        }
    }
}

