/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.iskra;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.kkm.iskra.IskraFieldFormatter;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;

public class IskraConnection {
    private static final byte STX = 2;
    private static final byte ETX = 3;
    private static final byte ACK = 6;
    private static final byte CAN = 24;
    private static final byte NAK = 21;
    private static final byte SPL = 28;
    private static final int MAX_LEN = 512;
    private static final int DEFAULT_TIMEOUT = 800;
    private final SerialPort port;
    private byte nextByte = (byte)33;
    private int attempts = 5;
    private SimpleDateFormat date;
    private SimpleDateFormat time;
    private Logger log;
    private boolean debugIO;
    private String password;

    public IskraConnection(SerialPort port, String password) {
        this.port = port;
        if (password != null && !password.isEmpty() && !password.matches("[a-zA-Z0-9]{4}")) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 4 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432. \u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b a..z, A..Z, 0-9. \u041f\u0435\u0440\u0435\u0434\u0430\u043d\u043e:" + password + ".");
        }
        this.password = password != null && !password.isEmpty() ? password : "AERF";
        this.date = new SimpleDateFormat("ddMMyy");
        this.time = new SimpleDateFormat("HHmm");
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    public void setAttempts(int attempts) {
        if (attempts < 1 || attempts > 20) {
            throw new IllegalArgumentException("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043a\u0435 \u043e\u0442 1 \u0434\u043e 20");
        }
        this.attempts = attempts;
    }

    public void setDebugIO(boolean debugIO) {
        this.debugIO = debugIO;
    }

    public synchronized List<byte[]> execute(int cmd, List<byte[]> fields, boolean addTimeStamp, Integer readTimeout) throws IOException {
        Object last = null;
        byte[] message = this.formMessage((byte)(cmd & 0xFF), fields, addTimeStamp);
        this.debugIO(">>message", message);
        this.port.flush(Flush.RxTx);
        this.writeData(message);
        List<Byte> data = this.readData(message, readTimeout != null ? readTimeout : 800);
        LinkedList<byte[]> result = new LinkedList<byte[]>();
        int lastIndex = -1;
        for (int i = 0; i < data.size(); ++i) {
            if (data.get(i) != 28) continue;
            if (lastIndex > 0) {
                result.add(ByteUtils.convert(data.subList(lastIndex + 1, i)));
            }
            lastIndex = i;
        }
        return result;
    }

    private void writeData(byte[] data) throws IOException {
        IOException last = null;
        this.port.setTimeout(500);
        for (int i = 0; i < this.attempts; ++i) {
            try {
                this.port.write(data);
                return;
            }
            catch (IOException ex) {
                last = ex;
                continue;
            }
        }
        throw new IOException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u043a\u043e\u043c\u0430\u043d\u0434\u0443 \u0432 \u043f\u043e\u0440\u0442 \u0437\u0430 " + this.attempts + " \u043f\u043e\u043f\u044b\u0442\u043e\u043a", last);
    }

    private List<Byte> readData(byte[] data, int timeout) throws IOException {
        IOException last = null;
        for (int i = 0; i < this.attempts; ++i) {
            try {
                int rb;
                int cnt;
                block12: {
                    this.port.setTimeout(timeout);
                    cnt = 0;
                    do {
                        try {
                            if (this.port.readByte() != 2) continue;
                            break block12;
                        }
                        catch (IOException ex) {
                            if (this.commandExec()) {
                                this.log.info((Object)"\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f. \u0416\u0434\u0435\u043c...");
                                this.port.write((byte)21);
                                continue;
                            }
                            this.log.info((Object)"\u041d\u0435\u0442 \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 \u043a\u043a\u043c. \u0421\u0431\u043e\u0439");
                            throw ex;
                        }
                    } while (++cnt != 10);
                    throw new IOException("\u041d\u0430\u0447\u0430\u043b\u043e \u0441\u043e\u043e\u0431\u0448\u0435\u043d\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u043f\u043e\u0442\u043e\u043a\u0435 \u0438\u0437 " + cnt + " \u0431\u0430\u0439\u0442");
                }
                LinkedList<Byte> answer = new LinkedList<Byte>();
                answer.add((byte)2);
                cnt = 0;
                while ((rb = this.port.readByte()) != 3) {
                    answer.add((byte)(rb & 0xFF));
                    if (++cnt != 512) continue;
                    throw new IOException("\u041a\u043e\u043d\u0435\u0446 \u0441\u043e\u043e\u0431\u0448\u0435\u043d\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043f\u043e\u0442\u043e\u043a\u0435 \u0438\u0437 " + cnt + " \u0431\u0430\u0439\u0442");
                }
                answer.add((byte)3);
                ByteUtils.add(answer, this.port.read(4));
                this.debugIO("rawout>>", answer);
                if (!this.checkCrc(answer)) {
                    this.log.info((Object)"\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 CRC");
                    this.port.write((byte)21);
                    continue;
                }
                if (answer.size() < 9) {
                    this.log.info((Object)"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439 \u043e\u0442\u0432\u0435\u0442");
                    this.writeData(data);
                    continue;
                }
                if (data[5] != (Byte)answer.get(1)) {
                    this.log.info((Object)"\u041e\u0442\u043b\u0438\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0431\u0430\u0439\u0442 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442");
                    this.port.setTimeout(5);
                    this.port.read(1024);
                    this.writeData(data);
                    continue;
                }
                if ((Byte)answer.get(1) == 32 && (Byte)answer.get(2) == 48 && (Byte)answer.get(3) == 48) {
                    this.log.info((Object)"\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0437\u0430\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435\u0432\u0435\u0440\u043d\u0430. \u041f\u043e\u0441\u044b\u043b\u0430\u044e \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e");
                    this.writeData(data);
                    continue;
                }
                return answer;
            }
            catch (IOException ex) {
                last = ex;
            }
        }
        throw new IOException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u0437\u0430 " + this.attempts + " \u043f\u043e\u043f\u044b\u0442\u043e\u043a", last);
    }

    public long parceHexField(String str) {
        if (str == null) {
            throw new IllegalArgumentException("\u0421\u0442\u0440\u043e\u043a\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430");
        }
        if (str.length() > 10) {
            throw new IllegalArgumentException("\u0414\u043b\u0438\u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0438 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043d\u0435 \u0431\u043e\u043b\u0435\u0435 10 \u0431\u0430\u0439\u0442");
        }
        if (str.length() % 2 == 1) {
            throw new IllegalArgumentException("\u0414\u043b\u0438\u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0438 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0447\u0435\u0442\u043d\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = str.length(); i > 0; i -= 2) {
            sb.append(str.substring(i - 2, i));
        }
        return Long.parseLong(sb.toString(), 16);
    }

    public byte[] getBytesFromHexField(String str) {
        if (str == null) {
            throw new IllegalArgumentException("\u0421\u0442\u0440\u043e\u043a\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430");
        }
        if (str.length() > 10) {
            throw new IllegalArgumentException("\u0414\u043b\u0438\u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0438 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043d\u0435 \u0431\u043e\u043b\u0435\u0435 10 \u0431\u0430\u0439\u0442");
        }
        if (str.length() % 2 == 1) {
            throw new IllegalArgumentException("\u0414\u043b\u0438\u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0438 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0447\u0435\u0442\u043d\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c");
        }
        LinkedList<Byte> bytes = new LinkedList<Byte>();
        for (int i = 0; i < str.length(); i += 2) {
            bytes.add(Byte.parseByte(str.substring(i, i + 2), 16));
        }
        return ByteUtils.convert(bytes);
    }

    private boolean commandExec() throws IOException {
        this.port.write(new byte[]{16, 48});
        int res = this.port.readByte();
        if ((res & 0x93) == 18) {
            return (res & 8) > 0;
        }
        return false;
    }

    private void addCrc(List<Byte> data) {
        short bcc = 0;
        for (Byte b : data) {
            bcc = (short)(bcc + (b & 0xFF));
        }
        ByteUtils.add(data, IskraFieldFormatter.getHexField(bcc));
    }

    private boolean checkCrc(List<Byte> data) {
        short bcc = 0;
        for (int i = 0; i < data.size() - 4; ++i) {
            bcc = (short)(bcc + (data.get(i) & 0xFF));
        }
        byte[] bcc2 = IskraFieldFormatter.getHexField(bcc);
        int l = data.size();
        return data.get(l - 4) == bcc2[0] && data.get(l - 3) == bcc2[1] && data.get(l - 2) == bcc2[2] && data.get(l - 1) == bcc2[3];
    }

    private void debugIO(String name, byte[] message) {
        if (this.debugIO) {
            this.log.info((Object)"========================");
            this.log.info((Object)name);
            for (int i = 0; i < message.length; ++i) {
                this.log.info((Object)String.format("%02d   %02d   %c  0x%02x", i, message[i] & 0xFF, message[i] & 0xFF, message[i] & 0xFF));
            }
        }
    }

    private void debugIO(String name, List<Byte> message) {
        if (this.debugIO) {
            this.log.info((Object)"========================");
            this.log.info((Object)name);
            for (int i = 0; i < message.size(); ++i) {
                this.log.info((Object)String.format("%02d   %02d   %c  0x%02x", i, message.get(i) & 0xFF, message.get(i) & 0xFF, message.get(i) & 0xFF));
            }
        }
    }

    private byte getRandomByte() {
        this.nextByte = (this.nextByte & 0xFF) > 250 ? (byte)32 : (byte)(this.nextByte + 1);
        return this.nextByte;
    }

    private byte[] formMessage(byte cmd, List<byte[]> fields, boolean addTimeStamp) {
        LinkedList<Byte> bytes = new LinkedList<Byte>();
        bytes.add((byte)2);
        ByteUtils.add(bytes, this.password.getBytes());
        bytes.add(this.getRandomByte());
        ByteUtils.add(bytes, String.format("%02X", cmd).getBytes());
        if (addTimeStamp) {
            Date d = new Date();
            bytes.add((byte)28);
            ByteUtils.add(bytes, this.date.format(d).getBytes());
            bytes.add((byte)28);
            ByteUtils.add(bytes, this.time.format(d).getBytes());
        }
        if (fields != null) {
            for (byte[] field : fields) {
                bytes.add((byte)28);
                ByteUtils.add(bytes, field);
            }
        }
        bytes.add((byte)28);
        bytes.add((byte)3);
        this.addCrc(bytes);
        return ByteUtils.convert(bytes);
    }
}

