/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.helpmicro;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.kkm.helpmicro.HelpMicroConnectionListener;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.SerialPort;

public class HelpMicroConnection {
    private static final int DEFAULT_TIMEOUT = 2000;
    private SerialPort port;
    private Set<HelpMicroConnectionListener> listeners;
    private Random rnd;
    private Logger log;
    private Byte lastByte;

    public HelpMicroConnection(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.port = port;
        port.setTimeout(2000);
        this.listeners = new HashSet<HelpMicroConnectionListener>();
        this.rnd = new Random();
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    public void addListener(HelpMicroConnectionListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public byte[] sendCommand(byte[] command, int ansLen) throws IOException {
        if (command == null || command.length == 0) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u0434\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u043c\u0430\u043d\u0434\u044b");
        }
        if (ansLen < 0) {
            throw new IllegalArgumentException("\u0414\u043b\u0438\u043d\u0430 \u043e\u0442\u0432\u0435\u0442 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043d\u0435\u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0439");
        }
        this.port.write(command);
        return this.port.read(ansLen);
    }

    public void exec(int procId, List<Object> params) throws IOException {
        LinkedList<Byte> data = new LinkedList<Byte>();
        data.add((byte)0);
        data.add((byte)(procId & 0xFF));
        data.add((byte)14);
        data.add((byte)17);
        data.add((byte)this.calcParamsLen(params));
        this.addParams(data, params);
        data.add((byte)9);
        this.log.debug((Object)(">> " + ByteUtils.toString(data)));
        this.port.write(HelpMicroConnection.pack(data));
    }

    private int readByte() throws IOException {
        if (this.lastByte != null) {
            byte res = this.lastByte;
            this.lastByte = null;
            return res;
        }
        int data = this.port.readByte();
        this.log.debug((Object)("<< " + String.format("0x%02x", data)));
        if (data == 27) {
            int nextByte = this.port.readByte();
            this.log.debug((Object)("<< " + String.format("0x%02x", nextByte)));
            if (nextByte == 1) {
                return 27;
            }
            if (nextByte == 2) {
                return 17;
            }
            if (nextByte == 3) {
                return 19;
            }
            this.lastByte = (byte)(nextByte & 0xFF);
            return data;
        }
        return data;
    }

    private byte[] readBytes(int size) throws IOException {
        byte[] res = new byte[size];
        for (int i = 0; i < size; ++i) {
            res[i] = (byte)(this.readByte() & 0xFF);
        }
        return res;
    }

    public int getAnswerWithSync(Integer timeout) throws IOException {
        this.port.setTimeout(timeout == null ? 2000 : timeout);
        byte[] sync = new byte[2];
        this.rnd.nextBytes(sync);
        this.log.debug((Object)("sync=" + ByteUtils.toString(sync)));
        this.port.write(HelpMicroConnection.pack(new byte[]{7, sync[0], sync[1], 9}));
        int res = 0;
        for (int i = 0; i < 200; ++i) {
            int lex = this.readByte();
            this.log.debug((Object)("lex=" + String.format("%x", lex)));
            if (lex == 27) {
                this.log.debug((Object)"ESC-\u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
                switch (this.readByte()) {
                    case 97: {
                        this.notifyStatus(this.readByte());
                        break;
                    }
                    case 81: {
                        this.notifyCrc(this.readBytes(2));
                        break;
                    }
                    case 98: {
                        this.notifySerial(this.readBytes(8));
                    }
                }
                continue;
            }
            if (lex == 224) {
                this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430");
                res = this.readByte();
                continue;
            }
            if (lex == 16) {
                this.log.debug((Object)"\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043a\u0430\u043d\u0430\u043b\u0430");
                int version = this.readByte() + (this.readByte() << 8) + (this.readByte() << 16) + (this.readByte() << 24);
                this.notifyChannel(version, this.readByte());
                continue;
            }
            if (lex == 19) {
                this.log.debug((Object)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
                int len2 = this.readByte();
                int len1 = this.readByte();
                byte[] mask = this.readBytes(len1);
                byte[] record = this.readBytes(len2);
                this.notifyInfo(mask, record);
                continue;
            }
            if (lex == 0) {
                this.log.debug((Object)("\u0427\u0438\u0441\u043b\u043e \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u044b\u0445 \u043a\u043e\u043c\u0430\u043d\u0434: " + (this.readByte() + (this.readByte() << 8))));
                continue;
            }
            if (lex == 1) {
                this.log.debug((Object)"\u0421\u0438\u043d\u0445\u0440\u043e\u043f\u0430\u043a\u0435\u0442");
                byte[] sync1 = this.readBytes(2);
                if (sync1[0] == sync[0] && sync1[1] == sync[1]) {
                    this.log.debug((Object)"\u0423\u0441\u043f\u0435\u0445. \u0417\u0430\u0432\u0435\u0440\u0448\u0430\u044e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443");
                    break;
                }
                this.log.error((Object)"\u041f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u043d\u0435\u0432\u0435\u0440\u043d\u0443\u044e \u0441\u0438\u043d\u0445\u0440\u043e\u043f\u043e\u0441\u044b\u043b\u043a\u0443");
                continue;
            }
            this.log.debug((Object)"\u041e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u043b\u0435\u043a\u0441\u0435\u043c\u044b");
        }
        return res;
    }

    private void addParams(List<Byte> data, List<Object> params) throws IOException {
        if (params == null || params.isEmpty()) {
            return;
        }
        for (Object obj : params) {
            if (obj instanceof Byte) {
                data.add((Byte)obj);
                continue;
            }
            if (obj instanceof Short) {
                short val = (Short)obj;
                data.add((byte)(val & 0xFF));
                data.add((byte)(val >> 8 & 0xFF));
                continue;
            }
            if (obj instanceof Integer) {
                int val = (Integer)obj;
                data.add((byte)(val & 0xFF));
                data.add((byte)(val >> 8 & 0xFF));
                data.add((byte)(val >> 16 & 0xFF));
                data.add((byte)(val >> 24 & 0xFF));
                continue;
            }
            if (obj instanceof Long) {
                long val = (Long)obj;
                data.add((byte)(val & 0xFFL));
                data.add((byte)(val >> 8 & 0xFFL));
                data.add((byte)(val >> 16 & 0xFFL));
                data.add((byte)(val >> 24 & 0xFFL));
                data.add((byte)(val >> 32 & 0xFFL));
                data.add((byte)(val >> 40 & 0xFFL));
                continue;
            }
            if (obj instanceof String) {
                for (byte b : ((String)obj).getBytes("866")) {
                    data.add(b);
                }
                continue;
            }
            throw new IOException("\u0422\u0438\u043f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 " + obj.getClass().getSimpleName() + " \u043d\u0435 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c");
        }
    }

    private int calcParamsLen(List<Object> params) throws IOException {
        if (params == null || params.isEmpty()) {
            return 0;
        }
        int len = 0;
        for (Object obj : params) {
            if (obj instanceof Byte) {
                ++len;
                continue;
            }
            if (obj instanceof Short) {
                len += 2;
                continue;
            }
            if (obj instanceof Integer) {
                len += 4;
                continue;
            }
            if (obj instanceof Long) {
                len += 6;
                continue;
            }
            if (obj instanceof String) {
                len += ((String)obj).length();
                continue;
            }
            throw new IOException("\u0422\u0438\u043f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 " + obj.getClass().getSimpleName() + " \u043d\u0435 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c");
        }
        return len;
    }

    public static byte[] pack(byte[] data) {
        if (data == null) {
            return data;
        }
        LinkedList<Byte> res = new LinkedList<Byte>();
        for (byte b : data) {
            if (b == 17) {
                res.add((byte)27);
                res.add((byte)2);
                continue;
            }
            if (b == 19) {
                res.add((byte)27);
                res.add((byte)3);
                continue;
            }
            if (b == 27) {
                res.add((byte)27);
                res.add((byte)1);
                continue;
            }
            res.add(b);
        }
        return ByteUtils.convert(res);
    }

    public static byte[] pack(List<Byte> data) {
        if (data == null) {
            return new byte[0];
        }
        LinkedList<Byte> res = new LinkedList<Byte>();
        for (byte b : data) {
            if (b == 17) {
                res.add((byte)27);
                res.add((byte)2);
                continue;
            }
            if (b == 19) {
                res.add((byte)27);
                res.add((byte)3);
                continue;
            }
            if (b == 27) {
                res.add((byte)27);
                res.add((byte)1);
                continue;
            }
            res.add(b);
        }
        return ByteUtils.convert(res);
    }

    public static byte[] unpack(byte[] data) {
        if (data == null) {
            return data;
        }
        LinkedList<Byte> res = new LinkedList<Byte>();
        for (int i = 0; i < data.length; ++i) {
            if ((data[i] & 0xFF) == 27 && i + 1 < data.length) {
                if (data[i + 1] == 1) {
                    res.add((byte)27);
                    ++i;
                    continue;
                }
                if (data[i + 1] == 2) {
                    res.add((byte)17);
                    ++i;
                    continue;
                }
                if (data[i + 1] == 3) {
                    res.add((byte)19);
                    ++i;
                    continue;
                }
                res.add(data[i]);
                continue;
            }
            res.add(data[i]);
        }
        return ByteUtils.convert(res);
    }

    public static byte[] unpack(List<Byte> data) {
        if (data == null) {
            return new byte[0];
        }
        LinkedList<Byte> res = new LinkedList<Byte>();
        for (int i = 0; i < data.size(); ++i) {
            if ((data.get(i) & 0xFF) == 27 && i + 1 < data.size()) {
                if (data.get(i + 1) == 1) {
                    res.add((byte)27);
                    ++i;
                    continue;
                }
                if (data.get(i + 1) == 2) {
                    res.add((byte)17);
                    ++i;
                    continue;
                }
                if (data.get(i + 1) == 3) {
                    res.add((byte)19);
                    ++i;
                    continue;
                }
                res.add(data.get(i));
                continue;
            }
            res.add(data.get(i));
        }
        return ByteUtils.convert(res);
    }

    private void notifyStatus(int status) {
        for (HelpMicroConnectionListener l : this.listeners) {
            l.onStatus(status);
        }
    }

    private void notifyCrc(byte[] crc) {
        for (HelpMicroConnectionListener l : this.listeners) {
            l.onCrc(crc);
        }
    }

    private void notifySerial(byte[] serial) {
        for (HelpMicroConnectionListener l : this.listeners) {
            l.onSerial(serial);
        }
    }

    private void notifyChannel(int version, int online) {
        for (HelpMicroConnectionListener l : this.listeners) {
            l.onChannel(version, online);
        }
    }

    private void notifyInfo(byte[] mask, byte[] record) {
        for (HelpMicroConnectionListener l : this.listeners) {
            l.onInfo(mask, record);
        }
    }
}

