/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.helpmicro;

import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.kkm.helpmicro.HelpMicroConnection;
import ru.softlogic.hardware.device.print.kkm.helpmicro.HelpMicroConnectionListener;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.hardware.utils.StringUtils;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.system.util.ArrayUtils;

public class HelpMicroApi
implements SerialDeviceApi,
HelpMicroConnectionListener {
    public static final byte LANG_UA = 0;
    private SerialPort port;
    private Map<Boolean, SerialParams[]> serialParams;
    private HelpMicroConnection connection;
    private int status;
    private byte[] mask;
    private byte[] record;
    private Logger log;

    public HelpMicroApi(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u0441\u044c \u0432 SerialPort");
        }
        this.port = port;
        this.port.setTimeout(2000);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)});
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.connection = new HelpMicroConnection(port);
        this.connection.addListener(this);
    }

    public int resetKkm(short maxPLU, short maxFil, short checkNumber, byte lang) throws IOException {
        this.log.info((Object)("\u0421\u0431\u0440\u043e\u0441 \u041a\u041a\u041c, max-plu=" + maxPLU + ",max-fil=" + maxFil + ",check-number=" + checkNumber + ",lang=" + lang));
        Calendar cal = Calendar.getInstance();
        int time = 0;
        time |= cal.get(13);
        time |= cal.get(12) << 8;
        time |= cal.get(11) << 16;
        int date = 0;
        date |= cal.get(5);
        date |= cal.get(2) + 1 << 8;
        date |= cal.get(1) - 2000 << 16;
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(maxPLU);
        params.add(maxFil);
        params.add(checkNumber);
        params.add(time);
        params.add(date);
        params.add(lang);
        this.connection.exec(92, params);
        return this.connection.getAnswerWithSync(null);
    }

    public void registerKassir(short kassir, int password) throws IOException {
        this.log.info((Object)("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u0443\u044e \u043a\u0430\u0441\u0441\u0438\u0440\u0430=" + kassir + ", \u043f\u0430\u0440\u043e\u043b\u044c=" + password));
        byte[] command = new byte[]{1, (byte)(kassir & 0xFF), (byte)(kassir >> 8 & 0xFF), (byte)(password & 0xFF), (byte)(password >> 8 & 0xFF), (byte)(password >> 16 & 0xFF), (byte)(password >> 24 & 0xFF), 9};
        this.log.debug((Object)(">> " + ByteUtils.toString(command)));
        command = HelpMicroConnection.pack(command);
        this.port.write(command);
    }

    public void openSession() throws IOException {
        this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u0435\u0441\u0441\u0438\u0438");
        this.port.flush(Flush.RxTx);
        this.port.write(new byte[]{27, 65});
    }

    public void closeSession() throws IOException {
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u0435\u0441\u0441\u0438\u0438");
        this.port.write(new byte[]{27, 67});
    }

    public void clearBuffers() throws IOException {
        this.log.info((Object)"\u0421\u0431\u0440\u043e\u0441 \u0431\u0443\u0444\u0444\u0435\u0440\u043e\u0432");
        this.port.write(new byte[]{17});
        this.port.write(new byte[]{27, 66});
    }

    public int ring(short len, short tone) throws IOException {
        this.log.info((Object)("\u0417\u0432\u0443\u043a\u043e\u0432\u043e\u0439 \u0441\u0438\u0433\u043d\u0430\u043b len=" + len + ", tone=" + tone));
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(len);
        params.add(tone);
        this.connection.exec(31, params);
        return this.connection.getAnswerWithSync(null);
    }

    public int openShift() throws IOException {
        this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043c\u0435\u043d\u044b");
        this.connection.exec(37, null);
        return 0;
    }

    public int openCheck() throws IOException {
        this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0447\u0435\u043a\u0430");
        this.connection.exec(32, null);
        return this.connection.getAnswerWithSync(null);
    }

    public int closeCheck() throws IOException {
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0447\u0435\u043a\u0430");
        this.connection.exec(33, null);
        return this.connection.getAnswerWithSync(10000);
    }

    public int cancelCheck() throws IOException {
        this.log.info((Object)"\u041e\u0442\u043c\u0435\u043d\u0430 \u0447\u0435\u043a\u0430");
        this.connection.exec(35, null);
        return this.connection.getAnswerWithSync(null);
    }

    public int addCommentToCheck(String comment) throws IOException {
        this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f \u0432 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0447\u0435\u043a: " + comment));
        comment = StringUtils.getStringByLen(comment, 40);
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(comment);
        this.connection.exec(38, params);
        return this.connection.getAnswerWithSync(null);
    }

    public int addFullSaleToCheck(int id, int price, int count, byte path, byte group, byte tax, String name) throws IOException {
        this.log.info((Object)("\u041f\u0440\u043e\u0434\u0430\u0436\u0430 \u0442\u043e\u0432\u0430\u0440\u0430: name=" + name + ",price=" + price + ",count=" + count));
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(new Long(id));
        params.add(price);
        params.add(count);
        params.add(path);
        params.add(group);
        params.add(tax);
        params.add(StringUtils.getStringByLen(name, 46));
        this.connection.exec(79, params);
        return this.connection.getAnswerWithSync(null);
    }

    public int payCheck(byte type, int sum, int client) throws IOException {
        this.log.info((Object)("\u0412\u043d\u0435\u0441\u0435\u043d\u0438\u0435 \u0434\u0435\u043d\u0435\u0433: type=" + type + ",sum=" + sum));
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(type);
        params.add(new Long(sum));
        params.add(client);
        this.connection.exec(42, params);
        return this.connection.getAnswerWithSync(null);
    }

    public int openText() throws IOException {
        this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
        this.connection.exec(81, null);
        return this.connection.getAnswerWithSync(null);
    }

    public int closeText() throws IOException {
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
        this.connection.exec(82, null);
        return this.connection.getAnswerWithSync(null);
    }

    public int printText(String text) throws IOException {
        this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f: " + text));
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(StringUtils.getStringByLen(text, 40));
        this.connection.exec(83, params);
        return this.connection.getAnswerWithSync(null);
    }

    public int doReportX() throws IOException {
        this.log.info((Object)"X-\u043e\u0442\u0447\u0435\u0442");
        LinkedList<Object> params = new LinkedList<Object>();
        params.add((byte)10);
        this.connection.exec(84, params);
        return this.connection.getAnswerWithSync(5000);
    }

    public int doReportZ() throws IOException {
        this.log.info((Object)"Z-\u043e\u0442\u0447\u0435\u0442");
        LinkedList<Object> params = new LinkedList<Object>();
        params.add((byte)0);
        this.connection.exec(84, params);
        return this.connection.getAnswerWithSync(10000);
    }

    public int doReportZToMem() throws IOException {
        this.log.info((Object)"Z-\u043e\u0442\u0447\u0435\u0442 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
        LinkedList<Object> params = new LinkedList<Object>();
        params.add((byte)51);
        params.add((short)0);
        this.connection.exec(89, params);
        return this.connection.getAnswerWithSync(10000);
    }

    public int doReportZFromMem() throws IOException {
        this.log.info((Object)"Z-\u043e\u0442\u0447\u0435\u0442 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
        LinkedList<Object> params = new LinkedList<Object>();
        params.add((byte)52);
        params.add((short)0);
        this.connection.exec(89, params);
        return this.connection.getAnswerWithSync(10000);
    }

    public int getLastCheckInfo() throws IOException {
        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u043d\u043e\u043c\u0435\u0440\u0430 \u0447\u0435\u043a\u0430");
        this.connection.exec(99, null);
        int res = this.connection.getAnswerWithSync(null);
        if (res == 0 && this.record != null && this.record.length == 13) {
            return this.record[6] + (this.record[7] << 8) + 1;
        }
        throw new IOException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0447\u0435\u043a\u0430: " + res);
    }

    public int getPrinterStatus() throws IOException {
        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u043f\u0435\u0447\u0430\u0442\u0430\u044e\u0449\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
        this.connection.exec(126, null);
        int res = this.connection.getAnswerWithSync(null);
        if (res == 0 && this.record != null && this.record.length == 4) {
            return this.record[0] + (this.record[1] << 8) + (this.record[2] << 16) + (this.record[3] << 24);
        }
        throw new IOException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430: " + res);
    }

    public int getStatus() throws IOException {
        this.connection.getAnswerWithSync(null);
        return this.status;
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return (SerialParams[])ArrayUtils.arrayMerge((Object[][])new SerialParams[][]{this.serialParams.get(true), this.serialParams.get(false)});
    }

    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.port.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.HelpMicroKkm;
    }

    @Override
    public void open() throws IOException {
        this.port.open();
        this.port.setFlow(Flow.XonXoff);
    }

    @Override
    public void close() {
        this.port.close();
    }

    @Override
    public void onStatus(int status) {
        if (this.status != status) {
            this.status = status;
            this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: " + String.format("0x%02x", status)));
        }
    }

    @Override
    public void onCrc(byte[] crc) {
        this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 crc: " + ByteUtils.toString(crc)));
    }

    @Override
    public void onSerial(byte[] serial) {
        this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d serial: " + ByteUtils.toString(serial)));
    }

    @Override
    public void onChannel(int version, int online) {
        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 channel: version=" + version + ", online=" + online));
    }

    @Override
    public void onInfo(byte[] mask, byte[] record) {
        this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f: mask=" + ByteUtils.toString(mask) + ", record=" + ByteUtils.toString(record)));
        this.mask = mask;
        this.record = record;
    }
}

