/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.comepay.report;

import java.util.Arrays;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayUtil;
import ru.softlogic.hardware.device.print.kkm.comepay.report.SumTax;

public class SessionReg {
    private SumTax[] money;
    private int[] oper;
    private int[] docCount;
    private int userDoc;

    public SumTax[] getMoney() {
        return this.money;
    }

    public void setMoney(SumTax[] money) {
        this.money = money;
    }

    public int[] getOper() {
        return this.oper;
    }

    public void setOper(int[] oper) {
        this.oper = oper;
    }

    public int[] getDocCount() {
        return this.docCount;
    }

    public void setDocCount(int[] docCount) {
        this.docCount = docCount;
    }

    public int getUserDoc() {
        return this.userDoc;
    }

    public void setUserDoc(int userDoc) {
        this.userDoc = userDoc;
    }

    public static SessionReg parse(byte[] src, int sidx) throws Exception {
        if (src == null) {
            throw new NullPointerException("SessionReg bytes");
        }
        SessionReg sr = new SessionReg();
        SumTax[] money = new SumTax[4];
        for (int i = 0; i < 4; ++i) {
            money[i] = SumTax.parse(src, sidx + i * 40);
        }
        sr.setMoney(money);
        int[] oper = new int[4];
        for (int i = 0; i < 4; ++i) {
            oper[i] = ComepayUtil.parseShort(src, sidx + 160 + i * 2);
        }
        sr.setOper(oper);
        int[] docCount = new int[4];
        for (int i = 0; i < 4; ++i) {
            docCount[i] = ComepayUtil.parseShort(src, sidx + 168 + i * 2);
        }
        sr.setDocCount(docCount);
        sr.setUserDoc(ComepayUtil.parseShort(src, sidx + 176));
        return sr;
    }

    public String toString() {
        return "SessionReg{money=" + Arrays.toString(this.money) + ",\n oper=" + Arrays.toString(this.oper) + ",\n docCount=" + Arrays.toString(this.docCount) + ",\n userDoc=" + this.userDoc + '}';
    }
}

