/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.comepay.report;

import java.util.Arrays;
import java.util.Date;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayUtil;
import ru.softlogic.hardware.device.print.kkm.comepay.report.PayInOut;
import ru.softlogic.hardware.device.print.kkm.comepay.report.SessionReg;
import ru.softlogic.hardware.device.print.kkm.comepay.report.SumTax;

public class Session {
    private Date opened;
    private Date closed;
    private Date writeDate;
    private SessionReg reg;
    private SumTax docSum;
    private byte docOpened;
    private byte status;
    private PayInOut payInOut;
    private long[][] payments;
    private long[] discounts;
    private long reward;
    private int annulCount;
    private byte recovered;
    private long billSumm;

    public static Session parse(byte[] src) throws Exception {
        if (src == null) {
            throw new NullPointerException("Session bytes");
        }
        if (src.length != 430) {
            throw new IllegalArgumentException("Session bytes len=" + src.length + ". Must be 430.");
        }
        if (src[2] != 1) {
            throw new IllegalArgumentException("Session version=" + src[2] + ". Must be 1.");
        }
        if (ComepayUtil.parseShort(src, src.length - 2) != Session.findCrc(src, src.length - 2)) {
            throw new IllegalArgumentException("CRC not corect");
        }
        Session s = new Session();
        s.setOpened(ComepayUtil.parseDateTime(src, 3));
        s.setClosed(ComepayUtil.parseDateTime(src, 10));
        s.setWriteDate(ComepayUtil.parseDate(src, 17));
        s.setReg(SessionReg.parse(src, 21));
        s.setDocSum(SumTax.parse(src, 199));
        s.setDocOpened(src[239]);
        s.setStatus(src[240]);
        s.setPayInOut(PayInOut.parse(src, 241));
        long[][] payments = new long[4][4];
        for (int i = 0; i < 16; ++i) {
            payments[i / 4][i % 4] = ComepayUtil.parseLong(src, 269 + i * 8, 8);
        }
        s.setPayments(payments);
        long[] discounts = new long[2];
        for (int i = 0; i < 2; ++i) {
            discounts[i] = ComepayUtil.parseLong(src, 397 + i * 8, 8);
        }
        s.setDiscounts(discounts);
        s.setReward(ComepayUtil.parseLong(src, 413, 8));
        s.setAnnulCount(ComepayUtil.parseShort(src, 421));
        s.setRecovered(src[423]);
        s.setBillSumm(ComepayUtil.parseLong(src, 424));
        return s;
    }

    public Date getOpened() {
        return this.opened;
    }

    public void setOpened(Date opened) {
        this.opened = opened;
    }

    public Date getClosed() {
        return this.closed;
    }

    public void setClosed(Date closed) {
        this.closed = closed;
    }

    public Date getWriteDate() {
        return this.writeDate;
    }

    public void setWriteDate(Date writeDate) {
        this.writeDate = writeDate;
    }

    public SessionReg getReg() {
        return this.reg;
    }

    public void setReg(SessionReg reg) {
        this.reg = reg;
    }

    public SumTax getDocSum() {
        return this.docSum;
    }

    public void setDocSum(SumTax docSum) {
        this.docSum = docSum;
    }

    public byte getDocOpened() {
        return this.docOpened;
    }

    public void setDocOpened(byte docOpened) {
        this.docOpened = docOpened;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public PayInOut getPayInOut() {
        return this.payInOut;
    }

    public void setPayInOut(PayInOut payInOut) {
        this.payInOut = payInOut;
    }

    public long[][] getPayments() {
        return this.payments;
    }

    public void setPayments(long[][] payments) {
        this.payments = payments;
    }

    public long[] getDiscounts() {
        return this.discounts;
    }

    public void setDiscounts(long[] discounts) {
        this.discounts = discounts;
    }

    public long getReward() {
        return this.reward;
    }

    public void setReward(long reward) {
        this.reward = reward;
    }

    public int getAnnulCount() {
        return this.annulCount;
    }

    public void setAnnulCount(int annulCount) {
        this.annulCount = annulCount;
    }

    public byte getRecovered() {
        return this.recovered;
    }

    public void setRecovered(byte recovered) {
        this.recovered = recovered;
    }

    public long getBillSumm() {
        return this.billSumm;
    }

    public void setBillSumm(long billSumm) {
        this.billSumm = billSumm;
    }

    private static int findCrc(byte[] src, int size) {
        int cs = 0;
        for (int i = 0; i < size; ++i) {
            cs = (cs & 0x8000) != 0 ? (cs <<= 1) : cs << 1 | 1;
            cs &= 0xFFFF;
            cs ^= src[i] & 0xFF;
        }
        return cs;
    }

    public String toString() {
        return "Session{\n opened=" + this.opened + ",\n closed=" + this.closed + ",\n writeDate=" + this.writeDate + ",\n reg=" + this.reg + ",\n docSum=" + this.docSum + ",\n docOpened=" + this.docOpened + ",\n status=" + this.status + ",\n payInOut=" + this.payInOut + ",\n payments=" + Arrays.toString(this.payments[0]) + ", " + Arrays.toString(this.payments[1]) + ", " + Arrays.toString(this.payments[2]) + ", " + Arrays.toString(this.payments[3]) + ",\n discounts=" + Arrays.toString(this.discounts) + ",\n reward=" + this.reward + ",\n annulCount=" + this.annulCount + ",\n recovered=" + this.recovered + ",\n billSumm=" + this.billSumm + '}';
    }
}

