/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.comepay.report;

import java.util.Arrays;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayUtil;

public class PayInOut {
    private long cache;
    private long[] sum;
    private int[] count;

    public long getCache() {
        return this.cache;
    }

    public void setCache(long cache) {
        this.cache = cache;
    }

    public long[] getSum() {
        return this.sum;
    }

    public void setSum(long[] sum) {
        this.sum = sum;
    }

    public int[] getCount() {
        return this.count;
    }

    public void setCount(int[] count) {
        this.count = count;
    }

    public static PayInOut parse(byte[] src, int sidx) {
        if (src == null) {
            throw new NullPointerException("PayInOut bytes");
        }
        PayInOut pio = new PayInOut();
        pio.setCache(ComepayUtil.parseLong(src, sidx, 8));
        long[] sum = new long[2];
        for (int i = 0; i < 2; ++i) {
            sum[i] = ComepayUtil.parseLong(src, sidx + 8 + i * 8, 8);
        }
        pio.setSum(sum);
        int[] count = new int[2];
        for (int i = 0; i < 2; ++i) {
            count[i] = ComepayUtil.parseShort(src, sidx + 24 + i * 2);
        }
        pio.setCount(count);
        return pio;
    }

    public String toString() {
        return "PayInOut{cache=" + this.cache + ", sum=" + Arrays.toString(this.sum) + ", count=" + Arrays.toString(this.count) + '}';
    }
}

