/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.comepay;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import ru.softlogic.hardware.utils.BCDUtils;

public class ComepayUtil {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyy");
    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("ssmmHHddMMyy");

    public static String getMessage(int error) {
        ResourceBundle b = ResourceBundle.getBundle("ru.softlogic.hardware.device.print.kkm.comepay.messages");
        try {
            return b.getString(String.format("%d", error));
        }
        catch (Throwable ex) {
            return b.getString("undefined");
        }
    }

    public static int parseShort(byte[] src, int pos) {
        return (src[pos + 1] & 0xFF) << 8 | src[pos] & 0xFF;
    }

    public static int parseBCDShort(byte[] src, int pos) {
        return (src[pos] & 0xFF) << 8 | src[pos + 1] & 0xFF;
    }

    public static long parseLong(byte[] src, int sidx, int len) {
        long l = 0L;
        for (int i = 0; i < len; ++i) {
            l = l << 8 | (long)(src[sidx + len - i - 1] & 0xFF);
        }
        return l;
    }

    public static long parseLong(byte[] src, int sidx) {
        return ComepayUtil.parseLong(src, sidx, 4);
    }

    public static Date parseDate(byte[] src, int sidx) throws ParseException {
        byte[] data = new byte[3];
        System.arraycopy(src, sidx + 1, data, 0, 3);
        return dateFormat.parse(BCDUtils.bcdToAscii(data));
    }

    public static Date parseDateTime(byte[] src, int sidx) throws ParseException {
        byte[] time = new byte[3];
        byte[] date = new byte[3];
        System.arraycopy(src, sidx, time, 0, 3);
        System.arraycopy(src, sidx + 4, date, 0, 3);
        return dateTimeFormat.parse(BCDUtils.bcdToAscii(time) + BCDUtils.bcdToAscii(date));
    }
}

