/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.comepay;

import java.io.IOException;
import java.util.Date;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.kkm.BaseKkm;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayApi;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayPrinter;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayState;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayType;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayUtil;
import ru.softlogic.hardware.device.print.kkm.comepay.Result;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderManager;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.system.util.ThreadUtil;

public class ComepayKkm
extends BaseKkm {
    private final ComepayApi api;
    private final Logger log = Logger.getLogger((String)"print");
    private final DeviceInfo deviceInfo;
    private final ComepayPrinter printer;
    private final int scroll;

    public ComepayKkm(SerialPort port, KkmOptions options) {
        super(DeviceType.ComepayKkm, port, options);
        this.api = new ComepayApi(port);
        this.printer = new ComepayPrinter(port);
        this.deviceInfo = new DeviceInfo(DeviceType.ComepayKkm);
        this.deviceInfo.setPort(port.getName());
        this.deviceInfo.setVendor("Comepay");
        this.scroll = options != null && options.getScroll() != null && options.getScroll() > 0 ? options.getScroll() : 0;
    }

    @Override
    public ReportResult formReportX() throws IOException {
        this.log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e X-\u043e\u0442\u0447\u0435\u0442");
        int res = this.api.reportX();
        this.addRes(res);
        return new ReportResult(res, res != 0, ComepayUtil.getMessage(res));
    }

    @Override
    public ReportResult formReportZ() throws IOException {
        this.log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e Z-\u043e\u0442\u0447\u0435\u0442");
        int res = this.api.reportZ();
        this.addRes(res);
        if (res == 0) {
            this.notifyZReportInfo(this.api.readZReportInfo());
        }
        return new ReportResult(res, res != 0, ComepayUtil.getMessage(res));
    }

    @Override
    public ReportResult formReportZMem() throws IOException {
        this.log.info((Object)"\u0420\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c Z-\u043e\u0442\u0447\u0435\u0442\u044b \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
        int res = this.api.printReportZFromMem();
        this.addRes(res);
        return new ReportResult(res, res != 0, ComepayUtil.getMessage(res));
    }

    @Override
    public ReportResult closeReportZToMem() throws IOException {
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e Z-\u043e\u0442\u0447\u0435\u0442 \u0432 \u043f\u0430\u043c\u044f\u0442\u0438");
        int res = this.api.putReportZToMem();
        this.addRes(res);
        if (res == 0) {
            this.notifyZReportInfo(this.api.readZReportInfo());
        }
        return new ReportResult(res, res != 0, ComepayUtil.getMessage(res));
    }

    @Override
    public ReportResult formReportDateRange(Date start, Date finish, boolean shortReport, String password) throws IOException {
        this.log.info((Object)("\u0424\u043e\u0440\u043c\u0438\u0440\u0443\u044e \u043e\u0442\u0447\u0435\u0442 \u043f\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0443 \u0434\u0430\u0442, \u043e\u0442 " + start + ", \u0434\u043e " + finish + ", short=" + shortReport));
        int res = this.api.reportByDateRange(start, finish, shortReport ? 0 : 1);
        this.addRes(res);
        return new ReportResult(res, res != 0, ComepayUtil.getMessage(res));
    }

    @Override
    public void setDefaultValues() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Operation operation, RenderData renderData) throws IOException {
        if (this.isSupportedNotFiscalMode() && Boolean.TRUE.equals(operation.getService().isNotFiscal())) {
            this.printNotFiscal(operation, renderData);
            return;
        }
        this.log.info((Object)"Begin------------------------------------------------------");
        long start = System.currentTimeMillis();
        try {
            if (operation.getSumResult().getCash().getBasicSum() > 0 && !operation.isCopy()) {
                int i;
                String[] str = RenderManager.renderingOperation(DeviceType.ComepayKkm, operation, renderData);
                this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                int res = this.api.openCheck(0);
                this.addRes(res);
                if (res != 0 && (res = this.fixError(res)) == 0) {
                    this.log.info((Object)"\u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                    res = this.api.openCheck(0);
                    this.addRes(res);
                    if (res != 0) {
                        res = this.fixError(res);
                        this.addRes(res);
                    }
                }
                if (res != 0) {
                    this.notifyError(operation, "openCheck", res);
                }
                str[0] = str[0].replace("<br>", "\n");
                Matcher m2 = Pattern.compile(".{1,40}").matcher(str[0]);
                while (m2.find()) {
                    String prn = m2.group(0);
                    res = this.api.printAttribute(255, prn);
                    this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u0442\u0440\u043e\u043a\u0443: " + prn + ", \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + res));
                }
                if (operation.getSumResult().getOut().getBasicSum() > 0) {
                    this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u043e\u043a\u0443\u043f\u043a\u0443");
                    res = this.api.addOperation(128, operation.getService().getName(), operation.getSumResult().getOut().getBasicSum() + operation.getSumResult().getCommission().getBasicSum(), 1000, 1);
                    this.addRes(res);
                }
                if (operation.getSumResult().getChange().getBasicSum() > 0) {
                    this.log.info((Object)"\u041a\u0430\u0440\u0442\u0443 \u0441\u0434\u0430\u0447\u0438");
                    res = this.api.addOperation(128, "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u0448\u0435\u043b\u044c\u043a\u0430", operation.getSumResult().getChange().getBasicSum(), 1000, 1);
                    this.addRes(res);
                }
                this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
                res = this.api.closeCheck(operation.getSumResult().getCash().getBasicSum(), operation.getSumResult().getCashLess().getBasicSum(), operation.getSumResult().getCommission().getBasicSum());
                this.addRes(res);
                this.log.info((Object)"\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e");
                for (i = 0; i < this.scroll; ++i) {
                    this.api.printString("");
                }
                this.log.info((Object)"\u041e\u0442\u0440\u0435\u0437\u0430\u044e");
                res = this.api.cut(0);
                this.addRes(res);
                if (str != null) {
                    for (i = 1; i < str.length; ++i) {
                        if (str[i].trim().isEmpty()) continue;
                        String string = str[i].trim();
                        this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0447\u0435\u043a: " + string));
                        this.printer.print(string);
                        this.printer.scroll(this.scroll);
                        this.printer.fullCut();
                        ThreadUtil.sleep((long)(i == str.length - 1 ? 0 : 2000));
                    }
                }
            } else {
                this.log.info((Object)"\u041d\u0435\u0442 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438. \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043e\u0431\u044b\u0447\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442:");
                String[] str = RenderManager.renderingOperation(DeviceType.ComepayPrinter, operation, renderData);
                if (str != null) {
                    for (int i = 0; i < str.length; ++i) {
                        if (str[i].trim().isEmpty()) continue;
                        String string = str[i].trim();
                        this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0447\u0435\u043a: " + string));
                        this.printer.print(string);
                        this.printer.scroll(this.scroll);
                        this.printer.fullCut();
                        ThreadUtil.sleep((long)(i == str.length - 1 ? 0 : 2000));
                    }
                }
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430/\u0432\u044b\u0432\u043e\u0434\u0430 \u043f\u0440\u0438 \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430", (Throwable)ex);
            this.notifyOperationError(operation, null, ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a", (Throwable)ex);
        }
        finally {
            this.log.info((Object)("****** \u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430: " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    @Override
    public void printGroup(GroupOperation operation, RenderData renderData) throws IOException {
        this.print((Operation)operation, renderData);
    }

    @Override
    public void print(MoneyCollection moneyCollection, RenderData renderData) throws IOException {
        this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u044c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: " + moneyCollection));
        this.log.info((Object)"\u041f\u043e\u0441\u044b\u043b\u0430\u044e \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c");
        String[] res = RenderManager.renderingMoneyCollection(DeviceType.ComepayKkm, moneyCollection, renderData);
        if (res != null && res.length > 0) {
            this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0447\u0435\u043a\u043e\u0432 " + res.length));
            for (int i = 0; i < res.length; ++i) {
                String str;
                if (i != 0) {
                    ThreadUtil.sleep((long)3000L);
                }
                if ((str = res[i]) == null || str.trim().isEmpty()) continue;
                this.printer.print(str);
                this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
                this.printer.scroll(this.scroll);
                this.log.info((Object)"\u041e\u0442\u0440\u0435\u0437\u0430\u044e");
                this.printer.fullCut();
            }
        }
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u044c \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
    }

    @Override
    public void print(CustomData data, RenderData renderData) throws IOException {
        String[] str = RenderManager.renderingCustomData(DeviceType.ComepayKkm, data, renderData);
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442:");
        if (str != null && str.length > 0 && !str[0].trim().isEmpty()) {
            this.printer.print(str[0].trim());
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            this.printer.scroll(this.scroll);
            this.log.info((Object)"\u041e\u0442\u0440\u0435\u0437\u0430\u044e");
            this.printer.fullCut();
        } else {
            this.log.error((Object)"\u041d\u0435\u0447\u0435\u0433\u043e \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c");
        }
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        PrinterStatus ps = new PrinterStatus();
        Result<ComepayState> state = this.api.getState();
        if (state.getError() == 0) {
            ComepayState st = state.getData();
            ps.setError(st.isLockedByPassword() || st.isSessionTimedOut() || st.isMemoryOver() || st.getLockFlags() != 0);
            ps.setPaperEnd((st.getLockFlags() & 0x20) > 0);
            ps.setOnline((st.getLockFlags() & 0x10) == 0);
        } else {
            ps.setOnline(false);
        }
        return ps;
    }

    @Override
    public short nextCheckNumber() {
        Random rnd = new Random();
        return (short)rnd.nextInt(16000);
    }

    @Override
    public PrinterType getType() {
        return PrinterType.Kkm;
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void init() throws IOException {
        Result<ComepayState> st;
        this.log.info((Object)"-----------------------------------------------------------");
        this.log.info((Object)("\u041f\u043e\u0440\u0442: " + this.api.getPort()));
        Result<ComepayType> res = this.api.getType();
        if (res.getData() != null) {
            this.deviceInfo.setModel(res.getData().getDeviceName());
            this.deviceInfo.setFirmware(res.getData().getSoftwareVersion() + "/" + res.getData().getHardwareVersion());
            this.log.info((Object)("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430:          " + res.getData().getDeviceName()));
            this.log.info((Object)("\u0412\u0435\u0440\u0441\u0438\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u043e\u0433\u043e \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f:  " + res.getData().getSoftwareVersion()));
            this.log.info((Object)("\u0412\u0435\u0440\u0441\u0438\u044f \u0430\u043f\u043f\u0430\u0440\u0430\u0442\u043d\u043e\u0433\u043e \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f:   " + res.getData().getHardwareVersion()));
        }
        if ((st = this.api.getState()).getData() != null) {
            this.log.info((Object)("\u0424\u043b\u0430\u0433\u0438 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438:                 " + st.getData().getLockFlags()));
            this.log.info((Object)("\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0441\u043c\u0435\u043d\u044b:  " + st.getData().getSessionDuration()));
            this.log.info((Object)("\u041a\u043e\u043b-\u0432\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0445 \u0441\u043c\u0435\u043d:             " + st.getData().getUsedSession()));
            this.log.info((Object)("\u042d\u041a\u041b\u0417 \u0431\u043b\u0438\u0437\u043a\u0430 \u043a \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044e:         " + st.getData().isEklzNearEnd()));
            this.deviceInfo.setInfo(Integer.toString(3000 - st.getData().getUsedSession()));
        }
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public boolean isOpen() {
        return this.api.getPort().isOpen();
    }

    @Override
    public DeviceInfo getInfo() {
        return this.deviceInfo;
    }

    private void addRes(int result) {
        this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + result + ", message=" + ComepayUtil.getMessage(result)));
    }

    private int fixError(int error) throws IOException {
        this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0443: " + error));
        if (error == 74) {
            this.log.info((Object)"\u0427\u0435\u043a \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442. \u0410\u043d\u043d\u0443\u043b\u0438\u0440\u0443\u044e \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u0447\u0435\u043a");
            int res = this.api.cancelCheck();
            this.addRes(res);
            return res;
        }
        if (error == 78) {
            this.log.info((Object)"\u0421\u043c\u0435\u043d\u0430 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u043b\u0430 24 \u0447\u0430\u0441\u0430. \u0421\u043d\u0438\u043c\u0430\u044e z-\u043e\u0442\u0447\u0435\u0442 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
            int res = this.api.putReportZToMem();
            if (res == 0) {
                this.notifyZReportInfo(this.api.readZReportInfo());
            }
            this.addRes(res);
            return res;
        }
        return error;
    }

    private void notifyError(Operation op, String procedure, int result) throws Exception {
        this.notifyOperationError(op, procedure, ComepayUtil.getMessage(result));
        throw new Exception("Can't print dicument, proc=" + procedure + ",res=" + result);
    }

    @Override
    public boolean isNeedCorrectTime() throws IOException {
        return false;
    }

    @Override
    public void correctTime() throws IOException, InterruptedException {
    }
}

