/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.atol;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.kkm.BaseKkm;
import ru.softlogic.hardware.device.print.kkm.KkmControl;
import ru.softlogic.hardware.device.print.kkm.atol.AtolApi;
import ru.softlogic.hardware.device.print.kkm.atol.AtolResult;
import ru.softlogic.hardware.device.print.kkm.atol.AtolShortState;
import ru.softlogic.hardware.device.print.kkm.atol.AtolType;
import ru.softlogic.hardware.device.print.kkm.atol.msg.AtolResultException;
import ru.softlogic.hardware.device.print.kkm.atol.msg.m;
import ru.softlogic.srv.connector.ZReportInfo;

public class Helper {
    private static final Logger log = Logger.getLogger((String)"print");

    public static boolean isReportBufferSupported(int model) {
        return model == 46 || model == 45 || model == 41;
    }

    public static boolean isRetractingSupported(int model) {
        return model == 38 || model == 45 || model == 37 || model == 41;
    }

    public static void waitUntil(AtolApi api, int state, int substate) throws IOException {
        int ioCount = 0;
        try {
            for (int i = 0; i < 100; ++i) {
                try {
                    AtolShortState als = api.getShortState();
                    if (als.getMode() != state || als.getSubmode() != substate) {
                        Thread.sleep(50L);
                        continue;
                    }
                    break;
                }
                catch (IOException ex) {
                    if (++ioCount == 5) {
                        throw ex;
                    }
                    Thread.sleep(500L);
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException(ex);
        }
    }

    public static int printReportsToPaper(AtolApi api, int type, BaseKkm baseKkm) throws IOException, AtolResultException {
        Object conrol = null;
        try {
            Helper.setPresenterParams(api, type, 1);
            log.info((Object)"\u0412\u044b\u0445\u043e\u0436\u0443 \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430: ");
            m.addResEx(api.exitMode());
            log.info((Object)"\u0412\u044b\u0431\u0438\u0440\u0430\u044e \u0440\u0435\u0436\u0438\u043c Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432");
            m.addResEx(api.selectMode((byte)3));
            ZReportInfo zReport = api.readZReportInfo();
            log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e Z-\u043e\u0442\u0447\u0435\u0442 \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438. \u041e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0430\u0435\u043c \u0441\u043d\u044f\u0442\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
            m.addRes(api.printReportsFromMemory());
            log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e Z-\u043e\u0442\u0447\u0435\u0442");
            int res = api.reportZ();
            if (res == 0) {
                log.info((Object)"\u0416\u0434\u0443 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430 \u0441\u043d\u044f\u0442\u0438\u044f \u043e\u0442\u0447\u0435\u0442\u0430");
                Helper.waitUntil(api, 3, 0);
                log.info((Object)"Z-\u043e\u0442\u0447\u0435\u0442 \u0441\u043d\u044f\u0442");
                baseKkm.notifyZReportInfo(zReport);
                return 0;
            }
            return res;
        }
        catch (AtolResultException ex) {
            return ex.getErrorCode();
        }
    }

    public static int setPresenterParams(AtolApi api, int type, int params) throws IOException {
        try {
            log.debug((Object)("\u0411\u043b\u043e\u043a \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0437\u0435\u043d\u0442\u0435\u0440\u043e\u043c, \u043c\u043e\u0434\u0435\u043b\u044c: " + type));
            log.debug((Object)"\u0412\u044b\u0445\u043e\u0436\u0443 \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430: ");
            m.addResEx(api.exitMode());
            log.debug((Object)"\u0412\u044b\u0431\u0438\u0440\u0430\u044e \u0440\u0435\u0436\u0438\u043c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            m.addResEx(api.selectMode((byte)4));
            AtolResult<byte[]> data = api.readTable(2, 1, 22);
            m.addResEx(data);
            byte conrol = data.getData()[0];
            log.debug((Object)"\u0427\u0438\u0442\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 2,1,22");
            log.debug((Object)("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435: " + String.format("%02X", conrol)));
            if (type == 37 || type == 41) {
                conrol = (params & 1) > 0 ? (byte)(conrol & 0xFFFFFFDF) : (byte)(conrol | 0x20);
            }
            log.debug((Object)("\u041d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: " + String.format("%02X", conrol)));
            if (data.getData()[0] != conrol) {
                log.debug((Object)"\u0417\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443");
                m.addResEx(api.writeTable(2, 1, 22, new byte[]{conrol}));
            } else {
                log.debug((Object)"\u041d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
            }
            return 0;
        }
        catch (AtolResultException ex) {
            return ex.getErrorCode();
        }
    }

    public static int processDayReport(AtolApi api, KkmControl control, BaseKkm baseKkm) throws IOException {
        try {
            AtolResult<AtolType> type = api.getKkmType();
            int model = 41;
            if (type.getError() == 0) {
                model = type.getData().getModel();
            } else {
                log.error((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u044c \u043c\u043e\u0434\u0435\u043b\u044c \u041a\u041a\u041c: " + m.getMessage(type)));
            }
            if (Helper.isReportBufferSupported(model)) {
                log.info((Object)"\u041c\u043e\u0434\u0435\u043b\u044c \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0431\u0443\u0444\u0444\u0435\u0440 Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432");
                log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0441\u043c\u0435\u043d\u0443 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c. \u0412\u044b\u0445\u043e\u0436\u0443 \u0438\u0437 \u0440\u0435\u0436\u0438\u043c\u0430");
                m.addResEx(api.exitMode());
                log.info((Object)"\u0421\u0442\u0430\u0432\u043b\u044e \u0440\u0435\u0436\u0438\u043c \u0441\u043d\u044f\u0442\u0438\u044f Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432");
                m.addResEx(api.selectMode((byte)3));
                ZReportInfo zReport = api.readZReportInfo();
                log.info((Object)"\u0412\u043a\u043b\u044e\u0447\u0430\u044e \u0440\u0435\u0436\u0438\u043c \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0442\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0445 \u043e\u0442\u0447\u0435\u0442\u043e\u0432");
                m.addResEx(api.putReportsToMemory());
                log.info((Object)"\u0421\u043d\u0438\u043c\u0430\u044e Z \u043e\u0442\u0447\u0435\u0442 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
                int res = api.reportZ();
                if (res == 103) {
                    log.info((Object)"\u0411\u0443\u0444\u0444\u0435\u0440 \u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d");
                    if (Helper.isRetractingSupported(model)) {
                        log.info((Object)"\u0420\u0435\u0442\u0440\u0430\u043a\u0442\u043e\u0440 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
                        if (control.isPrintZreportWhileBufferIsFull()) {
                            log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u044b \u043d\u0430 \u0431\u0443\u043c\u0430\u0433\u0443");
                            return Helper.printReportsToPaper(api, model, baseKkm);
                        }
                        log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043d\u0435 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u044b \u043d\u0430 \u0431\u0443\u043c\u0430\u0433\u0443");
                        return res;
                    }
                    log.info((Object)"\u0420\u0435\u0442\u0440\u0430\u043a\u0442\u043e\u0440 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f. \u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u044e \u043e\u0448\u0438\u0431\u043a\u0443");
                    return res;
                }
                if (res == 0) {
                    Helper.waitUntil(api, 3, 0);
                    baseKkm.notifyZReportInfo(zReport);
                    return 0;
                }
                return res;
            }
            log.info((Object)"\u041c\u043e\u0434\u0435\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0431\u0443\u0444\u0444\u0435\u0440 \u043e\u0442\u0447\u0435\u0442\u043e\u0432");
            if (control.isPrintZreportWhileBufferIsNotSupported()) {
                log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u044b \u043d\u0430 \u0431\u0443\u043c\u0430\u0433\u0443");
                return Helper.printReportsToPaper(api, model, baseKkm);
            }
            log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043d\u0435 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u044b \u043d\u0430 \u0431\u0443\u043c\u0430\u0433\u0443");
            return -1;
        }
        catch (AtolResultException ex) {
            return ex.getErrorCode();
        }
    }
}

