/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.atol;

import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.Tags;
import ru.softlogic.hardware.device.print.kkm.atol.AtolApi;
import ru.softlogic.hardware.device.print.kkm.atol.AtolResult;
import ru.softlogic.hardware.device.print.kkm.atol.AtolShortState;
import ru.softlogic.hardware.device.print.kkm.atol.AtolType;
import ru.softlogic.hardware.device.print.kkm.atol.PrnImageAdapter;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.api.BasePrinterApi;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.hdw.dev.printer.pos.WrongImageException;
import ru.softlogic.hdw.dev.printer.pos.img.ImageReader;
import ru.softlogic.hdw.dev.printer.pos.img.PrnImage;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.PathUtils;

public class AtolPrinter
extends BasePrinterApi {
    private AtolApi api;
    private Logger log;
    private Map<Tags, String> tags;
    private AtolType atolType;
    private Integer maxLen;
    private int model;
    private boolean centered;

    public AtolPrinter(SerialPort port, Integer maxLen) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043f\u043e\u0440\u0442\u0435");
        }
        this.api = new AtolApi(port);
        this.maxLen = maxLen;
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.tags = new EnumMap<Tags, String>(Tags.class);
        this.tags.put(Tags.BoldBegin, "");
        this.tags.put(Tags.BoldEnd, "");
        this.tags.put(Tags.UnderLineBegin, "");
        this.tags.put(Tags.UnderLineEnd, "");
        this.tags.put(Tags.AlignCenter, "");
        this.tags.put(Tags.AlignLeft, "");
        this.tags.put(Tags.AlignRight, "");
        this.tags.put(Tags.SmallBegin, "");
        this.tags.put(Tags.SmallEnd, "");
        this.tags.put(Tags.Br, "\n");
    }

    @Override
    public void init(PosPrinterOptions options) throws IOException {
    }

    @Override
    public String getFirmware() {
        return "n/a";
    }

    @Override
    public void print(String text) throws IOException {
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442");
        if (text != null && !text.isEmpty()) {
            this.centered = text.endsWith(Tags.AlignCenter.getString());
            for (Tags tag : Tags.values()) {
                String data = this.tags.get((Object)tag);
                text = text.replace(tag.getString(), data == null ? "" : data);
            }
            int textLen = 0;
            this.model = this.getType() != null ? Integer.valueOf(this.getType().getModel()) : null;
            if (this.maxLen == null) {
                textLen = 42;
                if (this.model == 39 || this.model == 46) {
                    this.log.info((Object)"\u0428\u0438\u0440\u0438\u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u0434\u043b\u044f PayCTS2000 40 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
                    textLen = 40;
                } else if (this.model == 38 || this.model == 45) {
                    this.log.info((Object)"\u0428\u0438\u0440\u0438\u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u0434\u043b\u044f PayPPU700 56 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
                    textLen = 52;
                }
            } else {
                textLen = this.maxLen;
            }
            this.api.setMaxLen(textLen);
            Matcher matcher = Pattern.compile(".{1," + textLen + "}").matcher(text);
            while (matcher.find()) {
                String prn = matcher.group(0);
                if (prn.length() < 40) {
                    prn = prn.trim();
                }
                int res = this.api.printText(prn, 1, 1, 0);
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u0442\u0440\u043e\u043a\u0443: " + prn + ", \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + res));
            }
        }
        this.log.info((Object)"\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b \u043f\u0435\u0447\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442\u0430");
    }

    @Override
    public void scroll(int scroll) throws IOException {
        for (int i = 0; i < scroll; ++i) {
            this.api.printText("");
        }
    }

    @Override
    public void fullCut() throws IOException {
        this.log.info((Object)"Cut paper");
        this.api.cutPaper((byte)0);
    }

    @Override
    public void partialCut() throws IOException {
        this.log.info((Object)"Partial cut paper");
        this.api.cutPaper((byte)0);
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        AtolShortState as = this.api.getShortState();
        PrinterStatus ps = new PrinterStatus();
        ps.setError(!as.isWork());
        ps.setPaperEnd(as.isPaperEnd());
        ps.setOnline(as.isPrinterConnected());
        return ps;
    }

    @Override
    public int getModelId() throws IOException {
        return 0;
    }

    @Override
    public Port getConnection() {
        return this.api.getPort();
    }

    @Override
    public String getVendor() {
        return "PAYKiosk";
    }

    @Override
    public String getModel() {
        return "n/a";
    }

    private AtolType getType() throws IOException {
        AtolResult<AtolType> ar;
        if (this.atolType == null && (ar = this.api.getKkmType()).getError() == 0) {
            this.atolType = ar.getData();
        }
        return this.atolType;
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void dispense(int steps) {
    }

    @Override
    public void printImage(String name, int size) throws IOException {
        int halfCheckWidth = 260;
        try {
            int margin;
            PrnImage image = ImageReader.getImage((File)PathUtils.getFilePath((String)("/templates/logo/" + name)));
            PrnImageAdapter img = new PrnImageAdapter(image).createOrtImage();
            if (this.centered) {
                margin = halfCheckWidth / 8 - img.width / 2;
                this.log.debug((Object)("margin=" + margin));
            } else {
                margin = 0;
            }
            this.api.initPrintingImage(0, img.width + margin, img.heigth);
            for (int y = 0; y < img.heigth; ++y) {
                this.api.loadImagePart(img.getString(y, margin));
            }
        }
        catch (WrongImageException ex) {
            throw new IOException("Wrong Image", ex);
        }
    }
}

