/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.ipp;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.ipp.IppPrintable;
import ru.softlogic.hardware.device.print.ipp.IppPrinterOptions;
import ru.softlogic.system.util.FontLoader;

public class KkmIppPrintable
implements IppPrintable {
    private final Font normal;
    private final Font big;
    private String text;
    private int printWidth;
    private final int printCount = 40;
    private final Logger log;

    public KkmIppPrintable() {
        Font base = FontLoader.fromBasePath((String)"ktf.ttf");
        if (base != null) {
            this.normal = base.deriveFont(0, 10.0f);
            this.big = base.deriveFont(1, 15.0f);
        } else {
            this.normal = new Font("Monospaced", 0, 10);
            this.big = new Font("Monospaced", 0, 15);
        }
        this.log = Logger.getLogger((String)"print");
    }

    @Override
    public void init(IppPrinterOptions options, int printWidth, String text) {
        this.text = text;
        this.printWidth = 75;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.text == null || this.text.isEmpty() || pageIndex != 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2d.setBackground(Color.white);
        g2d.setColor(Color.black);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        double dotPerLine = 72.0 * (double)this.printWidth / 25.4;
        this.log.info((Object)("\u0422\u043e\u0447\u0435\u043a \u043f\u043e \u0433\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u0438: " + dotPerLine));
        FontMetrics nFm = graphics.getFontMetrics(this.normal);
        int nBaseLen = (int)(dotPerLine / 40.0);
        FontMetrics bFm = graphics.getFontMetrics(this.big);
        int bBaseLen = nBaseLen * 2;
        this.text = this.text.replace("<br>", "\n").replace("<br/>", "\n");
        Matcher m2 = Pattern.compile(".{1,40}").matcher(this.text + "\n");
        g2d.setFont(this.normal);
        int i = 0;
        float pos = 20.0f;
        while (m2.find()) {
            int j;
            int otstup;
            String line = m2.group(0);
            this.log.info((Object)(">>" + line));
            boolean bold = line.startsWith("<b>");
            if (bold) {
                line = line.substring("<b>".length());
            }
            int hAlign = 0;
            if (line.startsWith("<left>")) {
                hAlign = 0;
                line = line.substring("<left>".length());
            } else if (line.startsWith("<right>")) {
                hAlign = 1;
                line = line.substring("<right>".length());
            }
            if (line.startsWith("<center>")) {
                hAlign = 2;
                line = line.substring("<center>".length());
            }
            if (bold) {
                pos += (float)bFm.getHeight() * 0.75f;
                g2d.setFont(this.big);
                otstup = 0;
                if (hAlign == 1) {
                    otstup = (20 - line.length()) * bBaseLen;
                } else if (hAlign == 2) {
                    otstup = (10 - line.length() / 2) * bBaseLen;
                }
                for (j = 0; j < line.length() && j < 20; ++j) {
                    g2d.drawString("" + line.charAt(j), (float)otstup + (float)(bBaseLen * j), pos);
                }
            } else {
                pos += (float)nFm.getHeight() * 0.87f;
                g2d.setFont(this.normal);
                otstup = 0;
                if (hAlign == 1) {
                    otstup = (40 - line.length()) * nBaseLen;
                } else if (hAlign == 2) {
                    otstup = (20 - line.length() / 2) * nBaseLen;
                }
                for (j = 0; j < line.length() && j < 40; ++j) {
                    g2d.drawString("" + line.charAt(j), (float)(nBaseLen * j) + (float)otstup, pos);
                }
            }
            ++i;
        }
        return 0;
    }

    public String toString() {
        return "KkmIppPrintable{}";
    }
}

