/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print;

import java.io.File;
import ru.softlogic.hardware.api.ApiFactory;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.Printer;
import ru.softlogic.hardware.device.print.ipp.DefaultIppPrintable;
import ru.softlogic.hardware.device.print.ipp.IppPrintable;
import ru.softlogic.hardware.device.print.ipp.IppPrinter;
import ru.softlogic.hardware.device.print.ipp.IppPrinterOptions;
import ru.softlogic.hardware.device.print.ipp.KkmIppPrintable;
import ru.softlogic.hardware.device.print.kkm.KkmControl;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.kkm.atol.AtolKkm;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayKkm;
import ru.softlogic.hardware.device.print.kkm.helpmicro.HelpMicroKkm;
import ru.softlogic.hardware.device.print.kkm.iskra.IskraKkm;
import ru.softlogic.hardware.device.print.kkm.leokas.LeoKkm;
import ru.softlogic.hardware.device.print.kkm.payonline.PayonlineKkm;
import ru.softlogic.hardware.device.print.kkm.rpsytem.RpSystemKkm;
import ru.softlogic.hardware.device.print.kkm.shtrih.ShtrihFrkKkm;
import ru.softlogic.hardware.device.print.kkm.shtrih.ShtrihKkm;
import ru.softlogic.hardware.device.print.kkm.tfa.TfaKkm;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerKkm;
import ru.softlogic.hardware.device.print.kkm.yarus.YarusKkm;
import ru.softlogic.hardware.device.print.posprinter.PosPrinter;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterStub2;
import ru.softlogic.hardware.device.print.posprinter.api.PrinterDeviceApi;
import ru.softlogic.hardware.device.print.posprinter.drv.CitizenCTS2000Printer_com;
import ru.softlogic.hardware.device.print.posprinter.drv.CitizenCTS2000Printer_usb;
import ru.softlogic.hardware.device.print.posprinter.drv.CitizenPpu232Printer_com;
import ru.softlogic.hardware.device.print.posprinter.drv.CustomTg2480Printer_com;
import ru.softlogic.hardware.device.print.posprinter.drv.CustomTg2480Printer_usb;
import ru.softlogic.hardware.device.print.posprinter.drv.CustomVkp80Printer_com;
import ru.softlogic.hardware.device.print.posprinter.drv.CustomVkp80Printer_usb;
import ru.softlogic.hardware.device.print.posprinter.drv.PosPrinterStub;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortType;
import ru.softlogic.io.parallel.ParallelPort;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;
import ru.softlogic.system.util.PathUtils;

public class PrinterFactory {
    public static Printer createPosPrinterInstance(DeviceType type, Port conn, PosPrinterOptions options) {
        PosPrinter printer = null;
        switch (type) {
            case GenericPosPrinter: {
                if (conn.getType() == PortType.SerialPort) {
                    printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.GenericPosPrinter, (SerialPort)conn)), options);
                    break;
                }
                if (conn.getType() == PortType.ParallelPort) {
                    printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.GenericPosPrinter, (ParallelPort)conn), options);
                    break;
                }
                if (conn.getType() != PortType.UsbPort) break;
                printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.GenericPosPrinter, (UsbPort)conn), options);
                break;
            }
            case GenericPosPrinterDdc: {
                if (conn.getType() == PortType.SerialPort) {
                    printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.GenericPosPrinterDdc, (SerialPort)conn)), options);
                    break;
                }
                if (conn.getType() == PortType.ParallelPort) {
                    printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.GenericPosPrinterDdc, (ParallelPort)conn), options);
                    break;
                }
                if (conn.getType() != PortType.UsbPort) break;
                printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.GenericPosPrinterDdc, (UsbPort)conn), options);
                break;
            }
            case CitizenCbm1000: {
                if (conn.getType() == PortType.SerialPort) {
                    printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.CitizenCbm1000, (SerialPort)conn)), options);
                    break;
                }
                if (conn.getType() != PortType.ParallelPort) break;
                printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.CitizenCbm1000, (ParallelPort)conn), options);
                break;
            }
            case CitizenPpu700: {
                if (conn.getType() == PortType.SerialPort) {
                    printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.CitizenPpu700, (SerialPort)conn)), options);
                    break;
                }
                if (conn.getType() != PortType.UsbPort) break;
                printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.CitizenPpu700, (UsbPort)conn), options);
                break;
            }
            case IPI1120E: {
                if (conn.getType() != PortType.SerialPort) break;
                printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.IPI1120E, (SerialPort)conn)), options);
                break;
            }
            case CustomVkp80: {
                if (conn.getType() == PortType.SerialPort) {
                    printer = new PosPrinter(new CustomVkp80Printer_com((SerialPort)conn), options);
                    break;
                }
                if (conn.getType() != PortType.UsbPort) break;
                printer = new PosPrinter(new CustomVkp80Printer_usb((UsbPort)conn), options);
                break;
            }
            case CitizenCTS2000: {
                if (conn.getType() == PortType.SerialPort) {
                    printer = new PosPrinter(new CitizenCTS2000Printer_com((SerialPort)conn), options);
                    break;
                }
                if (conn.getType() != PortType.UsbPort) break;
                printer = new PosPrinter(new CitizenCTS2000Printer_usb((UsbPort)conn), options);
                break;
            }
            case CustomTg2480: {
                if (conn.getType() == PortType.SerialPort) {
                    printer = new PosPrinter(new CustomTg2480Printer_com((SerialPort)conn), options);
                    break;
                }
                if (conn.getType() != PortType.UsbPort) break;
                printer = new PosPrinter(new CustomTg2480Printer_usb((UsbPort)conn), options);
                break;
            }
            case CitizenPpu232: {
                if (conn.getType() != PortType.SerialPort) break;
                printer = new PosPrinter(new CitizenPpu232Printer_com((SerialPort)conn), options);
                break;
            }
            case Epson500: {
                if (conn.getType() != PortType.ParallelPort) break;
                printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.Epson500, (ParallelPort)conn), options);
                break;
            }
            case Swecoin2000: {
                if (conn.getType() == PortType.SerialPort) {
                    printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.Swecoin2000, (SerialPort)conn)), options);
                    break;
                }
                if (conn.getType() == PortType.ParallelPort) {
                    printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.Swecoin2000, (ParallelPort)conn), options);
                    break;
                }
                if (conn.getType() != PortType.UsbPort) break;
                printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.Swecoin2000, (UsbPort)conn), options);
                break;
            }
            case SysfutureAv268: {
                if (conn.getType() != PortType.SerialPort) break;
                printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.SysfutureAv268, (SerialPort)conn)), options);
                break;
            }
            case StarLinePrinter: {
                if (conn.getType() == PortType.SerialPort) {
                    printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.StarLinePrinter, (SerialPort)conn)), options);
                    break;
                }
                if (conn.getType() == PortType.ParallelPort) {
                    printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.StarLinePrinter, (ParallelPort)conn), options);
                    break;
                }
                if (conn.getType() != PortType.UsbPort) break;
                printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.StarLinePrinter, (UsbPort)conn), options);
                break;
            }
            case ShtrihKkm: 
            case ShtrihFrkKkm: 
            case ShtrihPrinter: {
                if (conn.getType() != PortType.SerialPort) break;
                printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.ShtrihPrinter, (SerialPort)conn)), options);
                break;
            }
            case YarusKkm: 
            case YarusPrinter: {
                if (conn.getType() != PortType.SerialPort) break;
                printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.YarusPrinter, (SerialPort)conn)), options);
                break;
            }
            case AtolKkm: 
            case AtolPrinter: {
                if (conn.getType() != PortType.SerialPort) break;
                printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.AtolPrinter, (SerialPort)conn)), options);
                break;
            }
            case IskraKkm: 
            case IskraPrinter: {
                if (conn.getType() != PortType.SerialPort) break;
                printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.IskraPrinter, (SerialPort)conn)), options);
                break;
            }
            case ComepayKkm: 
            case ComepayPrinter: {
                if (conn.getType() != PortType.SerialPort) break;
                printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.ComepayPrinter, (SerialPort)conn)), options);
                break;
            }
            case GeBE: {
                if (conn.getType() == PortType.SerialPort) {
                    printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.GeBE, (SerialPort)conn)), options);
                    break;
                }
                if (conn.getType() != PortType.UsbPort) break;
                printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.GeBE, (UsbPort)conn), options);
                break;
            }
            case GeBE2: {
                if (conn.getType() == PortType.SerialPort) {
                    printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.GeBE2, (SerialPort)conn)), options);
                    break;
                }
                if (conn.getType() != PortType.UsbPort) break;
                printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.GeBE2, (UsbPort)conn), options);
                break;
            }
            case GP58CA: {
                if (conn.getType() != PortType.SerialPort) break;
                printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.GP58CA, (SerialPort)conn)), options);
                break;
            }
            case PosPrinterStub: {
                printer = new PosPrinterStub((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.GenericPosPrinter, (SerialPort)conn)), options);
                break;
            }
            case Hwasung: {
                if (conn.getType() == PortType.SerialPort) {
                    printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.Hwasung, (SerialPort)conn)), options);
                    break;
                }
                if (conn.getType() != PortType.UsbPort) break;
                printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.Hwasung, (UsbPort)conn), options);
                break;
            }
            case SnbcT080: {
                if (conn.getType() == PortType.SerialPort) {
                    printer = new PosPrinter((PrinterDeviceApi)((Object)ApiFactory.createDeviceApi(DeviceType.SnbcT080, (SerialPort)conn)), options);
                    break;
                }
                if (conn.getType() != PortType.UsbPort) break;
                printer = new PosPrinter((PrinterDeviceApi)ApiFactory.createDeviceApi(DeviceType.SnbcT080, (UsbPort)conn), options);
            }
        }
        return printer;
    }

    public static Printer createFiscalPrinterInstance(DeviceType type, Port conn, boolean printerMode, KkmOptions options, KkmControl control) {
        if (conn.getType() != PortType.SerialPort) {
            return null;
        }
        if (!printerMode) {
            switch (type) {
                case TfaKkm: {
                    return new TfaKkm((SerialPort)conn, options);
                }
                case TreasurerKkm: {
                    return new TreasurerKkm((SerialPort)conn, options, control);
                }
                case PayonlineKkm: {
                    return new PayonlineKkm((SerialPort)conn, options, control);
                }
                case ShtrihKkm: {
                    return new ShtrihKkm((SerialPort)conn, options, control);
                }
                case ShtrihFrkKkm: {
                    return new ShtrihFrkKkm((SerialPort)conn, options, control);
                }
                case YarusKkm: {
                    return new YarusKkm((SerialPort)conn, options, control);
                }
                case AtolKkm: {
                    return new AtolKkm((SerialPort)conn, options, control);
                }
                case HelpMicroKkm: {
                    return new HelpMicroKkm((SerialPort)conn, options);
                }
                case IskraKkm: {
                    String dataPath = PathUtils.getAppHome() + File.separator + "data" + File.separator + "kkm" + File.separator + "iskra.obj";
                    return new IskraKkm((SerialPort)conn, dataPath, options);
                }
                case ComepayKkm: {
                    return new ComepayKkm((SerialPort)conn, options);
                }
                case LeokasKkm: {
                    return new LeoKkm((SerialPort)conn, options);
                }
                case RpSystemKkm: {
                    return new RpSystemKkm((SerialPort)conn, options);
                }
            }
            return null;
        }
        PosPrinterOptions ppo = new PosPrinterOptions();
        if (options != null) {
            ppo.setScroll(options.getScroll() == null ? 0 : options.getScroll());
        }
        return PrinterFactory.createPosPrinterInstance(type, conn, ppo);
    }

    public static Printer createIppPrinter(String name, boolean addListener, IppPrinterOptions options, String renderType) {
        IppPrintable printable = null;
        printable = "kkm".equals(renderType) ? new KkmIppPrintable() : new DefaultIppPrintable();
        return new IppPrinter(name, addListener, options, printable);
    }

    public static Printer createStub() {
        return new PosPrinterStub2();
    }
}

