/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.present.leader;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceInfoListener;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.present.Dispenser;
import ru.softlogic.hardware.device.present.DispenserNetworkOptions;
import ru.softlogic.hardware.device.present.DispenserOptions;
import ru.softlogic.hardware.device.present.Status;
import ru.softlogic.hardware.device.present.StatusListener;
import ru.softlogic.hardware.device.present.leader.LeaderApi;
import ru.softlogic.hardware.device.present.leader.m;

public class LeaderPresentDispenser
extends Dispenser {
    private DispenserOptions pdo;
    private DispenserNetworkOptions pnc;
    private StatusListener statusListener;
    private DeviceInfoListener infoListener;
    private BlockingQueue<Integer> queue;
    private LeaderApi api;
    private Logger log;
    private int status;

    public LeaderPresentDispenser(DispenserOptions pdo, DispenserNetworkOptions pnc, StatusListener statusListener, DeviceInfoListener infoListener) {
        if (pdo == null) {
            throw new NullPointerException("PresentDispenserOptions");
        }
        if (statusListener == null) {
            throw new NullPointerException("StatusListener");
        }
        if (infoListener == null) {
            throw new NullPointerException("DeviceInfoListener");
        }
        this.pdo = pdo;
        this.pnc = pnc;
        this.statusListener = statusListener;
        this.infoListener = infoListener;
        this.api = new LeaderApi(pnc == null || pnc.getHost() == null || pnc.getHost().isEmpty() ? "127.0.0.1" : pnc.getHost(), pnc == null || pnc.getPort() == null || pnc.getPort() <= 0 ? 20000 : pnc.getPort());
        this.queue = new LinkedBlockingQueue<Integer>();
        this.log = Logger.getLogger((String)"present");
    }

    @Override
    public void givePresent(int count) {
        if (count <= 0 || count > 100) {
            throw new IllegalArgumentException("Count must be in range 1..100");
        }
        this.queue.add(count);
    }

    @Override
    public int getPresentCost(int count) {
        return this.pdo.getCost();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        DeviceInfo di = new DeviceInfo(DeviceType.LeaderCandy);
        di.setModel("\u041a\u043e\u043d\u0444\u0435\u0442\u043d\u0438\u0446\u0430 \u043b\u0438\u0434\u0435\u0440");
        di.setVendor("\u041b\u0438\u0434\u0435\u0440");
        this.infoListener.onDeviceInfo(di);
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Integer cnt;
                    this.status = this.api.getStatus();
                    this.log.info((Object)("Status=" + m.get(this.status)));
                    if (this.status == 207) {
                        this.statusListener.onStatus(new Status(0));
                    } else if (this.status == 174) {
                        this.statusListener.onStatus(new Status(2));
                    } else if (this.status == 223) {
                        this.statusListener.onStatus(new Status(4));
                    } else if (this.status == 191) {
                        this.statusListener.onStatus(new Status(3));
                    } else if (this.status == 255) {
                        this.statusListener.onStatus(new Status(1));
                    } else {
                        this.statusListener.onStatus(new Status(10));
                    }
                    if ((cnt = this.queue.poll(10L, TimeUnit.SECONDS)) == null) continue;
                    this.log.info((Object)("Needs to give " + cnt + " presents"));
                    for (int i = 0; i < cnt; ++i) {
                        this.log.info((Object)("Give present " + i + ", result: " + this.api.givePresent()));
                        Thread.sleep(1000L);
                    }
                    this.log.info((Object)"Done");
                }
                catch (IOException ex) {
                    this.statusListener.onStatus(new Status(1));
                    this.log.error((Object)ex);
                    Thread.sleep(1000L);
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.log.info((Object)"Stop thread");
    }
}

