/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.present.leader;

import java.io.IOException;
import java.net.Socket;

public class LeaderApi {
    public static final int STATUS_OK = 207;
    public static final int STATUS_BUSY = 143;
    public static final int STATUS_JAMM = 174;
    public static final int STATUS_STALL = 239;
    public static final int STATUS_ERROR = 159;
    public static final int STATUS_EMPTY = 223;
    public static final int STATUS_EMPTY2 = 191;
    public static final int STATUS_CONN = 255;
    private final String host;
    private final int port;

    public LeaderApi(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void reset() throws IOException {
        Socket socket = null;
        try {
            socket = new Socket(this.host, this.port);
            socket.getOutputStream().write("type=reset\n".getBytes());
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() throws IOException {
        Socket socket = null;
        try {
            socket = new Socket(this.host, this.port);
            socket.getOutputStream().write("type=status\n".getBytes());
            int n = this.getStatus(socket);
            return n;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean givePresent() throws IOException {
        Socket socket = null;
        try {
            socket = new Socket(this.host, this.port);
            socket.getOutputStream().write("type=extradition number=1\n".getBytes());
            int status = this.getStatus(socket);
            boolean bl = status == 207;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int getStatus(Socket socket) throws IOException {
        String result = "";
        byte[] res = new byte[10];
        while (!result.contains("\n")) {
            int cnt = socket.getInputStream().read(res);
            result = result + new String(res, 0, cnt);
        }
        if ((result = result.trim()).matches("^\\d+$")) {
            return Integer.parseInt(result);
        }
        throw new IOException("Wrong answer format: " + result);
    }
}

