/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.hopper.smart;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.cash.unit.MoneyUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceInfoListener;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.CashBox;
import ru.softlogic.hardware.device.hopper.BaseHopper;
import ru.softlogic.hardware.device.hopper.DispenseAdapter;
import ru.softlogic.hardware.device.hopper.DispenseListener;
import ru.softlogic.hardware.device.hopper.HopperException;
import ru.softlogic.hardware.device.hopper.HopperStateListener;
import ru.softlogic.hardware.device.hopper.PayoutManager;
import ru.softlogic.hardware.device.hopper.PayoutOperation;
import ru.softlogic.hardware.device.hopper.algorithm.Denomination;
import ru.softlogic.hardware.device.hopper.algorithm.GreedyAlgorithmCalculatorMX;
import ru.softlogic.hardware.device.hopper.algorithm.PayoutCalculator;
import ru.softlogic.hardware.proto.essp.Banknote;
import ru.softlogic.hardware.proto.essp.CashBoxPayout;
import ru.softlogic.hardware.proto.essp.HopperSetup;
import ru.softlogic.hardware.proto.essp.IncompleteSum;
import ru.softlogic.hardware.proto.essp.Payout;
import ru.softlogic.hardware.proto.essp.Result;
import ru.softlogic.hardware.proto.essp.SSPApi;
import ru.softlogic.hardware.proto.essp.SSPUtils;
import ru.softlogic.hardware.proto.essp.SmartHopperApi;
import ru.softlogic.hardware.proto.essp.eSSPException;
import ru.softlogic.hardware.proto.essp.eSSPLayer;
import ru.softlogic.hardware.proto.essp.m;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class SmartHopperDriver
extends BaseHopper {
    private static final int PROTO = 6;
    private SerialPort port;
    private CashBox box;
    private CashBox flowDownBox;
    private PayoutManager pm;
    private DeviceInfoListener deviceInfoListener;
    private PayoutCalculator pc;
    private HopperSetup setup;
    private Logger log;
    private SSPApi api;
    private SmartHopperApi eApi;
    private boolean enable;
    private int ioErrorCount;
    private byte[] lastData = null;
    private volatile DispenseListener dl;
    private Map<Banknote, Integer> counts;
    private HopperStateListener stateListener;

    public SmartHopperDriver(SerialPort port, CashBox box, CashBox flowDownBox, PayoutManager pm, DeviceInfoListener deviceInfoListener, HopperStateListener stateListener) {
        if (port == null) {
            throw new NullPointerException("Port is needed");
        }
        if (box == null) {
            throw new NullPointerException("CashBox is needed");
        }
        if (flowDownBox == null) {
            throw new NullPointerException("FlowDownBox is needed");
        }
        if (pm == null) {
            throw new NullPointerException("PayoutManager is needed");
        }
        if (deviceInfoListener == null) {
            throw new NullPointerException("DeviceInfoListener");
        }
        this.port = port;
        this.box = box;
        this.flowDownBox = flowDownBox;
        this.pm = pm;
        this.deviceInfoListener = deviceInfoListener;
        this.stateListener = stateListener;
        this.log = Logger.getLogger((String)"payout");
        this.api = new SSPApi(port, 16, this.log);
        this.enable = true;
        this.pc = new GreedyAlgorithmCalculatorMX(40);
    }

    @Override
    public synchronized void clear(DispenseListener listener, int dest, Keeper keeper) throws HopperException, IOException {
        if (listener == null) {
            throw new HopperException("Listener is not set");
        }
        HopperSetup currSetup = this.setup;
        if (currSetup == null) {
            this.log.info((Object)"No connection to hopper");
            listener.onError();
            return;
        }
        this.log.info((Object)("Box: " + keeper));
        this.log.info((Object)"Clear hopper through top slot");
        LinkedList<Payout> pos = new LinkedList<Payout>();
        this.log.info((Object)"Add units");
        Map units = keeper.getCashUnits();
        for (CashUnit cu : units.keySet()) {
            Banknote coin = new Banknote(cu.getNominal().getBasicSum(), currSetup.getMainCountryCode());
            int needs = (Integer)units.get(cu);
            if (needs <= 0) continue;
            Result<Integer> pr = this.eApi.getCoinAmount(coin);
            if (!pr.isOk()) {
                throw new HopperException("Error on get coin amount: " + m.get(pr));
            }
            if (needs > pr.getData()) {
                this.log.info((Object)("Add " + coin + "->" + (needs - pr.getData())));
                int res = this.eApi.setCoinAmount(coin, needs - pr.getData());
                if (res != 240) {
                    throw new HopperException("Error on set options: " + m.get(res));
                }
            }
            pos.add(new Payout(new Banknote(cu.getNominal().getBasicSum(), currSetup.getMainCountryCode()), needs));
        }
        int res = this.eApi.setOptions(7);
        if (res != 240) {
            throw new HopperException("Error on set opetion: " + m.get(res));
        }
        Result<Integer> result = null;
        if (dest == 1) {
            result = this.eApi.payoutByDenomination(88, pos);
        } else {
            LinkedList<Payout> pos2 = new LinkedList<Payout>();
            Iterator iterator = pos.iterator();
            while (iterator.hasNext()) {
                pos2.add(new Payout(((Payout)iterator.next()).getCoin(), 0));
            }
            result = this.eApi.floatByDenomination(88, pos2);
        }
        if (!result.isOk()) {
            throw new HopperException("Error: " + m.get(result) + ", cause: " + m.getPayoutCause(result.getData()));
        }
        this.dl = listener;
    }

    @Override
    public synchronized void add(MoneyUnit mu, int count) throws HopperException, IOException {
    }

    @Override
    public Keeper getKeeper() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized void payout(PayoutOperation payoutOperation) throws HopperException, IOException {
        if (SystemProp.isSmartHopperSplit()) {
            int sum = Math.min(payoutOperation.getSumPayout(), 1000);
            this._payout(new PayoutOperation(sum, payoutOperation.getSumInput(), new SplitPayoutListener(payoutOperation)));
        } else {
            this._payout(payoutOperation);
        }
    }

    private synchronized void _payout(PayoutOperation payoutOperation) throws HopperException, IOException {
        this.log.info((Object)("Payout, sum=" + payoutOperation.getSumPayout()));
        this.log.info((Object)("Event ack: " + this.asStr(this.eApi.eventAsk())));
        HopperSetup currSetup = this.setup;
        if (currSetup == null) {
            this.log.info((Object)"No connection to hopper");
            payoutOperation.getListener().onError();
            return;
        }
        this.log.info((Object)("Box: " + this.box.getKeeper()));
        HashMap<Denomination, Integer> presence = new HashMap<Denomination, Integer>();
        for (CashUnit cu : this.box.getKeeper().getCashUnits().keySet()) {
            Integer count = (Integer)this.box.getKeeper().getCashUnits().get(cu);
            if (count == null || count <= 0) continue;
            presence.put(new Denomination(1, cu.getNominal().getBasicSum(), cu), count);
        }
        this.log.info((Object)("Presence: " + presence));
        Map<Denomination, Integer> po = this.pc.calculate(presence, payoutOperation.getSumPayout());
        this.log.info((Object)("Payout set: " + po));
        LinkedList<Payout> pos = new LinkedList<Payout>();
        HashMap<CashUnit, Integer> units = new HashMap<CashUnit, Integer>();
        for (Denomination dn : po.keySet()) {
            units.put((CashUnit)dn.getObject(), po.get(dn));
            pos.add(new Payout(new Banknote(dn.getNominal(), currSetup.getMainCountryCode()), po.get(dn)));
        }
        this.log.info((Object)"Check the possibility of payout");
        if (this.pm.canGive(units, payoutOperation.getSumPayout(), payoutOperation.getSumInput())) {
            this.log.info((Object)"Payout allowed");
            this.log.info((Object)"Add units");
            for (CashUnit cu : units.keySet()) {
                Banknote coin = new Banknote(cu.getNominal().getBasicSum(), currSetup.getMainCountryCode());
                int needs = (Integer)units.get(cu);
                Result<Integer> pr = this.eApi.getCoinAmount(coin);
                if (!pr.isOk()) {
                    throw new HopperException("Error on get coin amount: " + m.get(pr));
                }
                if (needs <= pr.getData()) continue;
                this.log.info((Object)("Add " + coin + "->" + (needs - pr.getData())));
                int res = this.eApi.setCoinAmount(coin, needs - pr.getData());
                if (res != 240) {
                    throw new HopperException("Error on set options: " + m.get(res));
                }
                this.log.info((Object)"Successfully added");
            }
            this.printContent();
            this.log.info((Object)("Payout counts: " + po));
            int res = this.eApi.setOptions(7);
            if (res != 240) {
                throw new HopperException("Error on set options: " + m.get(res));
            }
            this.log.info((Object)("coins=" + pos));
            Result<Integer> result = this.eApi.payoutByDenomination(88, pos);
            if (!result.isOk()) {
                throw new HopperException("Error: " + m.get(result) + ", cause: " + m.getPayoutCause(result.getData()));
            }
            this.dl = payoutOperation.getListener();
            this.dl.onPayoutNominals(units);
        } else {
            this.log.info((Object)"Payout is not allowed");
            payoutOperation.getListener().onProcess(0);
            payoutOperation.getListener().onResult(new Keeper());
        }
    }

    @Override
    public void run() {
        this.log.info((Object)"Thread start");
        Boolean lastEnable = null;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                try {
                    if (this.setup == null) {
                        this.initDevice();
                    }
                    if (lastEnable == null || lastEnable != this.enable) {
                        lastEnable = this.enable;
                        if (this.enable) {
                            this.log.info((Object)("Enable device, result: " + this.asStr(this.api.enable())));
                        } else {
                            this.log.info((Object)("Disable device, result: " + this.asStr(this.api.disable())));
                        }
                    }
                    this.poll();
                    Thread.sleep(200L);
                    this.ioErrorCount = 0;
                }
                catch (IOException ex) {
                    this.notifyError();
                    this.log.error((Object)"I/O Error", (Throwable)ex);
                    this.port.close();
                    this.setup = null;
                    lastEnable = null;
                    ++this.ioErrorCount;
                    if (this.ioErrorCount == 3) {
                        this.processState(2);
                    }
                    Thread.sleep(500L);
                }
                catch (eSSPException ex) {
                    this.log.error((Object)"Essp error", (Throwable)ex);
                    this.port.close();
                    this.setup = null;
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.log.info((Object)"Thread stop");
    }

    private synchronized void poll() throws IOException {
        boolean jamm = false;
        Result<byte[]> res = this.eApi.pollWithAck();
        if (res.getError() == 240) {
            byte[] data = res.getData();
            if (data != null && data.length > 0 && !Arrays.equals(data, this.lastData)) {
                this.lastData = data;
                block26: for (int i = 0; i < data.length; ++i) {
                    switch (data[i] & 0xFF) {
                        case 218: {
                            List<Banknote> coins = SSPUtils.convertToCoins(data, i, 6);
                            this.log.info((Object)("Dispensing " + coins));
                            i += 7 * data[i + 1] + 1;
                            this.notifySum(coins.get(0).getNominal());
                            continue block26;
                        }
                        case 210: {
                            List<Banknote> coins = SSPUtils.convertToCoins(data, i, 6);
                            this.log.info((Object)("Dispened " + coins));
                            i += 7 * data[i + 1] + 1;
                            this.log.info((Object)("Confirm, result: " + this.asStr(this.eApi.eventAsk())));
                            this.notifyFinish();
                            continue block26;
                        }
                        case 215: {
                            List<Banknote> coins = SSPUtils.convertToCoins(data, i, 6);
                            this.log.info((Object)("Floating " + SSPUtils.convertToCoins(data, i, 6)));
                            i += 7 * data[i + 1] + 1;
                            this.notifySum(coins.get(0).getNominal());
                            continue block26;
                        }
                        case 216: {
                            this.log.info((Object)("Floated " + SSPUtils.convertToCoins(data, i, 6)));
                            i += 7 * data[i + 1] + 1;
                            this.log.info((Object)("Confirm, result: " + this.asStr(this.eApi.eventAsk())));
                            this.notifyFinish();
                            continue block26;
                        }
                        case 217: {
                            List<Banknote> coins = SSPUtils.convertToCoins(data, i, 6);
                            this.log.info((Object)("Timeout " + coins));
                            i += 7 * data[i + 1] + 1;
                            this.log.info((Object)("Confirm, result: " + this.asStr(this.eApi.eventAsk())));
                            this.notifyFinish();
                            continue block26;
                        }
                        case 179: {
                            List<Banknote> coins = SSPUtils.convertToCoins(data, i, 6);
                            this.log.info((Object)("Smart empting " + coins));
                            this.notifySum(coins.get(0).getNominal());
                            i += 7 * data[i + 1] + 1;
                            continue block26;
                        }
                        case 180: {
                            this.log.info((Object)("Smart empted " + SSPUtils.convertToCoins(data, i, 6)));
                            i += 7 * data[i + 1] + 1;
                            this.log.info((Object)("Confirm, result" + this.asStr(this.eApi.eventAsk())));
                            this.notifyFinish();
                            continue block26;
                        }
                        case 129: {
                            this.log.info((Object)"Lid open");
                            continue block26;
                        }
                        case 130: {
                            this.log.info((Object)"Lid closed");
                            continue block26;
                        }
                        case 131: {
                            this.log.info((Object)("Calibration fail, cause: " + m.getCalibrationCause(data[i + 1])));
                            this.log.info((Object)("Do calibration, result: " + this.eApi.runCalibration()));
                            ++i;
                            this.notifyFinish();
                            continue block26;
                        }
                        case 213: {
                            this.log.info((Object)("Jammes " + SSPUtils.convertToCoins(data, i, 6)));
                            i += 7 * data[i + 1] + 1;
                            continue block26;
                        }
                        case 214: {
                            this.log.info((Object)("Halted " + SSPUtils.convertToCoins(data, i, 6)));
                            i += 7 * data[i + 1] + 1;
                            this.notifyFinish();
                            continue block26;
                        }
                        case 221: {
                            List<IncompleteSum> sums = SSPUtils.convertToSums(data, i);
                            this.log.info((Object)("Incomplete payout " + sums));
                            i += 12 * data[i + 1] + 1;
                            this.log.info((Object)("Confirm, result: " + this.asStr(this.eApi.eventAsk())));
                            continue block26;
                        }
                        case 220: {
                            this.log.info((Object)("Incomplete float " + SSPUtils.convertToSums(data, i)));
                            i += 12 * data[i + 1] + 1;
                            this.log.info((Object)("Confirm, result: " + this.asStr(this.eApi.eventAsk())));
                            continue block26;
                        }
                        case 222: {
                            this.log.info((Object)("Cashbox paid " + SSPUtils.convertToCoins(data, i, 6)));
                            i += 7 * data[i + 1] + 1;
                            continue block26;
                        }
                        case 223: {
                            this.log.info((Object)("Coin creadit " + SSPUtils.convertToCoin(data, i)));
                            i += 7;
                            continue block26;
                        }
                        case 196: {
                            jamm = true;
                            this.log.info((Object)"Coin mechanism jammed");
                            continue block26;
                        }
                        case 197: {
                            this.log.info((Object)"Coin mechanism return active");
                            continue block26;
                        }
                        case 230: {
                            this.log.info((Object)("Fraud attempt detected " + SSPUtils.convertToCoins(data, i, 6)));
                            i += 7 * data[i + 1] + 1;
                            this.log.info((Object)("Confirm, result: " + this.asStr(this.eApi.eventAsk())));
                            this.notifyFinish();
                            continue block26;
                        }
                        case 194: {
                            this.log.info((Object)"Empting");
                            this.notifySum(0);
                            continue block26;
                        }
                        case 195: {
                            this.log.info((Object)"Emptied");
                            this.notifyFinish();
                            continue block26;
                        }
                        case 178: {
                            this.log.info((Object)"Low payout level");
                            continue block26;
                        }
                        case 241: {
                            this.log.info((Object)"Slave reset");
                            continue block26;
                        }
                        case 232: {
                            this.log.info((Object)"Slave disable");
                            continue block26;
                        }
                        default: {
                            this.log.info((Object)("Unknown code, seq=" + BU.toString((byte[])data)));
                        }
                    }
                }
            }
        } else {
            this.log.debug((Object)("Poll error: " + m.get(res)));
        }
        this.processState(jamm ? 3 : 0);
    }

    private int printContent() throws IOException {
        this.log.info((Object)"Box content:");
        int total = 0;
        this.counts = new HashMap<Banknote, Integer>();
        HopperSetup currSetup = this.setup;
        if (currSetup == null) {
            this.log.info((Object)"No connection to hopper");
            return 0;
        }
        for (Banknote c : currSetup.getCoins()) {
            Result<Integer> res = this.eApi.getCoinAmount(c);
            this.log.info((Object)("    " + c.getNominal() + " " + c.getCountry() + ": " + this.asStr(res)));
            if (!res.isOk()) continue;
            total += c.getNominal() * res.getData();
            this.counts.put(c, res.getData());
        }
        this.log.info((Object)"--------");
        this.log.info((Object)("    Total: " + total));
        return total;
    }

    private synchronized void initDevice() throws IOException, eSSPException {
        this.log.info((Object)"Try to open port");
        this.port.open();
        this.log.info((Object)"Port is open");
        this.setup = null;
        this.log.info((Object)"Init device");
        this.log.info((Object)("Sync=" + this.asStr(this.api.sync())));
        this.log.info((Object)("Sync=" + this.asStr(this.api.sync())));
        this.log.info((Object)("Sync=" + this.asStr(this.api.sync())));
        this.log.info((Object)("Set host protocol to 6: " + this.asStr(this.api.setHostProtocol(6))));
        this.log.info((Object)"Create encrypted layer");
        eSSPLayer layer = this.api.createEncryptedLayer(SSPApi.ITL_KEY);
        this.eApi = new SmartHopperApi(layer, 16, 0, this.log);
        this.log.info((Object)("Set host protocol to 6: " + this.asStr(this.api.setHostProtocol(6))));
        this.log.info((Object)"Get device setup");
        Result<HopperSetup> ds = this.eApi.getDeviceSetup();
        if (ds.getError() == 240) {
            this.setup = ds.getData();
            this.log.info((Object)("    Unit type: " + m.getUnitName(this.setup.getUnitType())));
            this.log.info((Object)("    Firmware: " + this.setup.getFirmvare()));
            this.log.info((Object)("    Main country code: " + this.setup.getMainCountryCode()));
            this.log.info((Object)("    Proto: " + this.setup.getProto()));
            this.log.info((Object)"    Coins:");
            for (Banknote c : this.setup.getCoins()) {
                this.log.info((Object)("        " + c.getNominal() + ", " + c.getCountry()));
            }
        } else {
            throw new IOException("Error: " + m.get(ds.getError()));
        }
        this.log.info((Object)"Set coin options: ");
        for (Banknote c : this.setup.getCoins()) {
            this.log.info((Object)("    " + c.getNominal() + " " + c.getCountry()));
            this.log.info((Object)("        Set routuing to payout: " + this.asStr(this.eApi.setRouting(0, c))));
            this.log.info((Object)("        Unset inhibit: " + this.asStr(this.eApi.setCoinMechInhibits(c, this.enable))));
        }
        this.printContent();
        this.log.info((Object)("Get minimum payout: " + this.asStr(this.eApi.getMinimumPayout(this.setup.getMainCountryCode()))));
        this.log.info((Object)("Set auto calibration: " + this.asStr(this.eApi.setCommandCalibration(0))));
        this.log.info((Object)("Halt payout: " + this.asStr(this.eApi.haltPayout())));
        this.log.info((Object)("Unset global inhibit: " + this.asStr(this.eApi.setGlobalInhibit(true))));
        Result<Integer> ro = this.eApi.getOptions();
        if (ro.isOk()) {
            this.log.info((Object)("Options: " + BU.toHex((int)ro.getData())));
        }
        this.log.info((Object)("Set options: " + this.asStr(this.eApi.setOptions(5))));
        DeviceInfo di = new DeviceInfo(DeviceType.SmartHopper);
        di.setPort(this.port.getName() + " " + this.port.getParams());
        di.setVendor("ITL");
        di.setModel(m.getUnitName(this.setup.getUnitType()));
        di.setFirmware(this.setup.getFirmvare());
        di.setInfo(this.setup.getMainCountryCode());
        di.setProto(Integer.toString(this.setup.getProto()));
        this.deviceInfoListener.onDeviceInfo(di);
    }

    private String asStr(int error) {
        return m.get(error);
    }

    private String asStr(Result<Integer> res) {
        if (res.getError() != 240) {
            return m.get(res.getError());
        }
        if (res.getData() != null) {
            return res.getData().toString();
        }
        return m.get(res.getError());
    }

    private void notifySum(int sum) {
        if (this.dl != null) {
            this.dl.onProcess(sum);
        }
    }

    private void notifyFinish() throws IOException {
        this.log.info((Object)"Request payout data: ");
        Result<CashBoxPayout> rpo = this.eApi.cashboxPayoutData();
        if (rpo.isOk()) {
            for (Payout po : rpo.getData().getPayouts()) {
                this.log.info((Object)("  " + po.getCoin() + "->" + po.getCount()));
            }
            this.log.info((Object)("Unvalidate coins: " + rpo.getData().getUnvalidateCount()));
        } else {
            this.log.error((Object)m.get(rpo));
        }
        if (this.dl == null) {
            return;
        }
        Map<Banknote, Integer> first = this.counts;
        this.printContent();
        Keeper keeper = new Keeper();
        for (Banknote c : this.setup.getCoins()) {
            int diff = first.get(c) - this.counts.get(c);
            if (diff <= 0) continue;
            this.log.info((Object)("Dispensed " + diff + "->" + c));
            CashUnit cu = CashFactory.getDefaultInstance().getCoinUnitByNominal(new Sum(c.getNominal()));
            if (cu != null) {
                for (int i = 0; i < diff; ++i) {
                    keeper.addCash(cu);
                }
                continue;
            }
            this.log.info((Object)("Mapping not found: " + c));
        }
        if (this.dl.isNeedSub()) {
            this.box.sub(keeper);
        }
        DispenseListener tdl = this.dl;
        this.dl = null;
        tdl.onResult(keeper);
    }

    @Override
    public void flowDownCoins(Keeper target, DispenseListener listener) throws IOException, HopperException {
        this.log.info((Object)("Start flowdown with target " + target));
        HopperSetup currSetup = this.setup;
        if (currSetup == null) {
            this.log.info((Object)"No connection to hopper");
            listener.onError();
            return;
        }
        LinkedList<Payout> pos = new LinkedList<Payout>();
        for (CashUnit cu : target.getCashUnits().keySet()) {
            Integer t = (Integer)target.getCashUnits().get(cu);
            Integer c = (Integer)this.box.getKeeper().getCashUnits().get(cu);
            if (t == null || c == null) continue;
            pos.add(new Payout(new Banknote(cu.getNominal().getBasicSum(), currSetup.getMainCountryCode()), Math.min(t, c)));
        }
        for (CashUnit cu : this.box.getKeeper().getCashUnits().keySet()) {
            if (target.getCashUnits().containsKey(cu)) continue;
            pos.add(new Payout(new Banknote(cu.getNominal().getBasicSum(), currSetup.getMainCountryCode()), (Integer)this.box.getKeeper().getCashUnits().get(cu)));
        }
        for (CashUnit cu : this.box.getKeeper().getCashUnits().keySet()) {
            Banknote coin = new Banknote(cu.getNominal().getBasicSum(), currSetup.getMainCountryCode());
            int res = this.eApi.setCoinAmount(coin, 0);
            if (res != 240) {
                throw new HopperException("Error on set options: " + m.get(res));
            }
            res = this.eApi.setCoinAmount(coin, (Integer)this.box.getKeeper().getCashUnits().get(cu));
            if (res == 240) continue;
            throw new HopperException("Error on set options: " + m.get(res));
        }
        this.printContent();
        int res = this.eApi.setOptions(7);
        if (res != 240) {
            throw new HopperException("Error on set options: " + m.get(res));
        }
        Result<Integer> result = this.eApi.floatByDenomination(88, pos);
        if (!result.isOk()) {
            throw new HopperException("Error: " + m.get(result) + ", cause: " + m.getPayoutCause(result.getData()));
        }
        this.dl = new FlowDownDispenseListener(listener);
    }

    @Override
    public boolean isFlowDownSupported() {
        return true;
    }

    private void processState(int status) {
        if (this.stateListener != null) {
            this.stateListener.onState(status);
        }
    }

    private void notifyError() {
        if (this.dl != null) {
            this.dl.onError();
            this.dl = null;
        }
    }

    private void updatePackChangePayed(Map<CashUnit, Integer> units) {
        for (Map.Entry<CashUnit, Integer> entrySet : units.entrySet()) {
            CashUnit cu = entrySet.getKey();
            Integer count = entrySet.getValue();
            Session.getInstance().getPack().getChange().addCash(cu, count.intValue());
        }
        Session.getInstance().flush();
    }

    private class SplitPayoutListener
    extends DispenseAdapter {
        private final PayoutOperation operation;
        private final Keeper dispensed;
        private Map<CashUnit, Integer> payoutNominals;

        public SplitPayoutListener(PayoutOperation operation) {
            this.operation = operation;
            this.dispensed = new Keeper();
        }

        @Override
        public void onProcess(int sumDispensed) {
            this.operation.getListener().onProcess(this.dispensed.getSum().getBasicSum() + sumDispensed);
        }

        @Override
        public void onResult(Keeper keeper) {
            SmartHopperDriver.this.log.info((Object)("Dispense result " + keeper));
            for (Map.Entry e : keeper.getCashUnits().entrySet()) {
                this.dispensed.addCash((CashUnit)e.getKey(), ((Integer)e.getValue()).intValue());
            }
            SmartHopperDriver.this.log.info((Object)("Dispensed total " + this.dispensed));
            if (keeper.getSum().isEmpty()) {
                SmartHopperDriver.this.log.info((Object)("Dispense not possible " + this.dispensed));
                this.operation.getListener().onResult(this.dispensed);
                return;
            }
            if (this.operation.getSumPayout() > this.dispensed.getSum().getBasicSum()) {
                try {
                    int sum = Math.min(this.operation.getSumPayout() - this.dispensed.getSum().getBasicSum(), 1000);
                    SmartHopperDriver.this._payout(new PayoutOperation(sum, this.operation.getSumInput(), this));
                }
                catch (Exception ex) {
                    SmartHopperDriver.this.log.error((Object)ex, (Throwable)ex);
                    this.operation.getListener().onResult(this.dispensed);
                }
            } else {
                this.operation.getListener().onResult(this.dispensed);
            }
        }

        @Override
        public void onPayoutNominals(Map<CashUnit, Integer> units) {
            this.payoutNominals = units;
            SmartHopperDriver.this.updatePackChangePayed(units);
        }

        @Override
        public void onError() {
            Map<CashUnit, Integer> units = this.payoutNominals;
            if (units != null) {
                for (Map.Entry<CashUnit, Integer> e : units.entrySet()) {
                    this.dispensed.addCash(e.getKey(), e.getValue().intValue());
                }
            }
            this.operation.getListener().onResult(this.dispensed);
        }
    }

    private class FlowDownDispenseListener
    extends DispenseAdapter {
        private final DispenseListener dl;

        public FlowDownDispenseListener(DispenseListener dl) {
            this.dl = dl;
        }

        @Override
        public void onProcess(int sumDispensed) {
            SmartHopperDriver.this.log.info((Object)("Dispensed " + sumDispensed));
            this.dl.onProcess(sumDispensed);
        }

        @Override
        public void onResult(Keeper keeper) {
            SmartHopperDriver.this.log.info((Object)("Dispense result " + keeper));
            for (CashUnit cu : keeper.getCashUnits().keySet()) {
                SmartHopperDriver.this.flowDownBox.addCash(cu, (Integer)keeper.getCashUnits().get(cu));
            }
            this.dl.onResult(keeper);
        }

        @Override
        public void onError() {
            this.dl.onError();
        }
    }
}

