/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.hopper.smart;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.proto.essp.SSPApi;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class AppSmartHopperApi
implements SerialDeviceApi {
    private final SerialParams[] params;
    private final SerialPort port;
    private final SSPApi api;

    public AppSmartHopperApi(SerialPort port) {
        this.port = port;
        this.api = new SSPApi(port, 16, Logger.getLogger((String)"payout"));
        this.params = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            for (SerialParams sp : this.getAvailableParameters()) {
                this.port.putParams(sp);
                try {
                    this.port.open();
                    this.api.sync();
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                finally {
                    this.port.close();
                }
            }
        }
        throw new NoSuchDeviceException("Device on port " + this.port.getName() + " is not SmartHopper");
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.SmartHopper;
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void close() {
        this.api.close();
    }
}

