/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.hopper.sch2;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.proto.cctalk.v2.payout.PayoutApi;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class Sch2Api
implements SerialDeviceApi {
    private SerialPort port;
    private PayoutApi api;
    private SerialParams[] params;

    public Sch2Api(SerialPort port) {
        if (port == null) {
            throw new NullPointerException("SerialPort");
        }
        this.port = port;
        this.api = new PayoutApi(port, Logger.getLogger((String)"hopper"));
        this.params = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            for (SerialParams sp : this.getAvailableParameters()) {
                this.port.putParams(sp);
                try {
                    this.port.open();
                    this.api.getHopperApi(3).testHopper();
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    this.port.close();
                }
            }
        }
        throw new NoSuchDeviceException("Device on port " + this.port.getName() + " is not SCH2 Hopper");
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.SCH2Hopper;
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void close() {
        this.api.close();
    }
}

