/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.hopper.algorithm;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.hardware.device.hopper.algorithm.Denomination;
import ru.softlogic.hardware.device.hopper.algorithm.PayoutCalculator;

public class SimplexMethod
implements PayoutCalculator {
    private double[][] matrix;
    private int count;
    private int rows;

    @Override
    public Map<Denomination, Integer> calculate(Map<Denomination, Integer> presence, int sum) {
        this.init(presence, sum);
        Boolean fg = this.isOptimal();
        while (!fg.booleanValue()) {
            this.iteration();
            fg = this.isOptimal();
            if (fg != null) continue;
            return null;
        }
        if (!this.isInteger()) {
            this.algoritmLittla(0);
        }
        return this.getResult(presence);
    }

    private void init(Map<Denomination, Integer> presence, int sum) {
        this.count = presence.size();
        this.matrix = new double[500][150];
        this.rows = this.count + 3;
        for (int i = 0; i < this.count + 1; ++i) {
            this.matrix[0][i] = i;
        }
        int k = 1;
        for (Map.Entry<Denomination, Integer> entry : presence.entrySet()) {
            this.matrix[1][k] = entry.getKey().getNominal();
            this.matrix[0][k] = entry.getKey().getNominal();
            ++k;
        }
        this.matrix[1][k] = sum;
        k = 2;
        for (Map.Entry<Denomination, Integer> entry : presence.entrySet()) {
            for (int i = 1; i < this.count + 1; ++i) {
                if (this.matrix[1][i] != (double)entry.getKey().getNominal()) continue;
                this.matrix[k][i] = 1.0;
            }
            this.matrix[k][this.count + 1] = entry.getValue().intValue();
            ++k;
        }
        this.matrix[this.count + 2] = this.getFunction();
    }

    private Boolean isOptimal() {
        boolean fg = false;
        for (int i = 1; i < this.count + 1; ++i) {
            if (!(this.matrix[this.rows - 1][i] < 0.0)) continue;
            fg = true;
            for (int j = 1; j < this.count + 2; ++j) {
                if (!(this.matrix[j][i] > 0.0)) continue;
                return false;
            }
        }
        if (fg) {
            return null;
        }
        return true;
    }

    private void iteration() {
        int col = this.getPermissiveColumn();
        int row = this.getPermissiveRownum(col);
        this.methodJordanGauss(row, col);
    }

    private int getPermissiveColumn() {
        double min = 0.0;
        int col = 0;
        for (int i = 1; i < this.count + 1; ++i) {
            if (!(this.matrix[this.rows - 1][i] < min)) continue;
            min = this.matrix[this.rows - 1][i];
            col = i;
        }
        return col;
    }

    private int getPermissiveRownum(int col) {
        int i;
        double min = 0.0;
        int row = 0;
        for (i = 1; i < this.rows - 1; ++i) {
            this.matrix[i][this.count + 2] = this.matrix[i][col] > 0.0 ? this.matrix[i][this.count + 1] / this.matrix[i][col] : 0.0;
        }
        min = 2.147483647E9;
        for (i = 1; i < this.rows - 1; ++i) {
            if (!(this.matrix[i][this.count + 2] > 0.0) || !(this.matrix[i][this.count + 2] < min)) continue;
            min = this.matrix[i][this.count + 2];
            row = i;
        }
        return row;
    }

    private double[] getFunction() {
        double[] func = new double[this.count + 3];
        for (int i = 2; i < this.count + 2; ++i) {
            func[i - 1] = -1.0 * this.matrix[1][i - 1];
        }
        return func;
    }

    private boolean isInteger() {
        for (int i = 1; i < this.count + 2; ++i) {
            double temp = new BigDecimal(this.matrix[i][this.count + 1] % 1.0).setScale(12, RoundingMode.HALF_UP).doubleValue();
            if (temp == 0.0) continue;
            return false;
        }
        return true;
    }

    private void methodJordanGauss(int row, int col) {
        int j;
        int i;
        double elem = this.matrix[0][col];
        this.matrix[0][col] = this.matrix[row][0];
        this.matrix[row][0] = elem;
        elem = this.matrix[row][col];
        for (i = 1; i < this.rows; ++i) {
            for (j = 1; j < this.count + 2; ++j) {
                if (i == row || j == col) continue;
                this.matrix[i][j] = this.matrix[i][j] - this.matrix[i][col] * this.matrix[row][j] / elem;
            }
        }
        i = 1;
        while (i < this.count + 3) {
            double[] dArray = this.matrix[row];
            int n = i++;
            dArray[n] = dArray[n] / elem;
        }
        for (i = 1; i < this.rows; ++i) {
            double[] dArray = this.matrix[i];
            int n = col;
            dArray[n] = dArray[n] / (elem * -1.0);
        }
        this.matrix[row][col] = 1.0 / elem;
        for (i = 1; i < this.rows; ++i) {
            for (j = 1; j < this.count + 2; ++j) {
                this.matrix[i][j] = new BigDecimal(this.matrix[i][j]).setScale(12, RoundingMode.HALF_UP).doubleValue();
            }
        }
    }

    private Map<Denomination, Integer> getResult(Map<Denomination, Integer> presence) {
        HashMap<Denomination, Integer> out = new HashMap<Denomination, Integer>();
        for (Map.Entry<Denomination, Integer> entry : presence.entrySet()) {
            for (int i = 1; i < this.rows; ++i) {
                if (this.matrix[i][0] != (double)entry.getKey().getNominal() || this.matrix[i][this.count + 1] == 0.0) continue;
                out.put(entry.getKey(), new BigDecimal(this.matrix[i][this.count + 1] / 1.0).setScale(2, RoundingMode.HALF_UP).intValue());
            }
        }
        return out;
    }

    private void algoritmLittla(int row) {
        int j;
        int i;
        if (row != 0) {
            double min = this.matrix[row][1];
            int indexcol = 1;
            for (int i2 = 2; i2 < this.count + 1; ++i2) {
                if (!(this.matrix[row][i2] < min)) continue;
                min = this.matrix[row][i2];
                indexcol = i2;
            }
            this.methodJordanGauss(row, indexcol);
        }
        double[] addRow = new double[this.count + 3];
        for (i = 0; i < this.rows && (new BigDecimal(this.matrix[i][this.count + 1] % 1.0).setScale(12, RoundingMode.HALF_UP).doubleValue() == 0.0 || this.matrix[i][0] == 0.0); ++i) {
        }
        if (i == this.rows) {
            return;
        }
        int edge = (int)this.matrix[i][this.count + 1];
        if (edge != 0) {
            this.matrix[this.rows] = this.matrix[this.rows - 1];
            this.matrix[this.rows - 1] = this.matrix[this.rows - 2];
            for (j = 1; j < this.count + 1; ++j) {
                addRow[j] = -1.0 * this.matrix[i][j];
            }
            addRow[this.count + 1] = (double)edge - this.matrix[i][this.count + 1];
            this.matrix[this.rows - 1] = addRow;
            ++this.rows;
            this.algoritmLittla(this.rows - 2);
        } else {
            for (j = 1; j < this.count + 2; ++j) {
                this.matrix[i][j] = -1.0 * this.matrix[i][j];
            }
            this.algoritmLittla(i);
        }
    }
}

