/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.hopper.algorithm;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.hopper.algorithm.Denomination;
import ru.softlogic.hardware.device.hopper.algorithm.DenominationComparator;
import ru.softlogic.hardware.device.hopper.algorithm.PayoutCalculator;

public class GreedyAlgorithmCalculatorMX
implements PayoutCalculator {
    private int limit;
    private final Logger log = Logger.getLogger((String)"payout");

    public GreedyAlgorithmCalculatorMX(int limit) {
        if (limit < 0 || limit > 50) {
            throw new IllegalArgumentException("Limit must be in range 0..50");
        }
        this.limit = limit;
    }

    @Override
    public Map<Denomination, Integer> calculate(Map<Denomination, Integer> presence, int sum) {
        if (presence == null || presence.isEmpty()) {
            return new HashMap<Denomination, Integer>();
        }
        if (sum <= 0) {
            return new HashMap<Denomination, Integer>();
        }
        int totalCount = 0;
        for (Integer cnt : presence.values()) {
            if (cnt == null) continue;
            totalCount += cnt.intValue();
        }
        if (totalCount <= 0) {
            return new HashMap<Denomination, Integer>();
        }
        LinkedList<Denomination> lst = new LinkedList<Denomination>();
        lst.addAll(presence.keySet());
        Collections.sort(lst, new DenominationComparator());
        HashMap<Denomination, Integer> result = new HashMap<Denomination, Integer>();
        for (int i = 0; i < lst.size(); ++i) {
            Integer cnt2;
            Denomination den = (Denomination)lst.get(i);
            this.log.debug((Object)("denomination: " + den));
            Integer cnt = presence.get(den);
            if (cnt == null || cnt <= 0) continue;
            this.log.debug((Object)("cnt=" + cnt));
            Integer lim = null;
            if ((den.getNominal() == 1000 || den.getNominal() == 200) && i < lst.size() - 1 && (cnt2 = presence.get(lst.get(i + 1))) != null) {
                lim = (int)(((double)cnt.intValue() - (double)this.limit * 1.0 / 100.0 * (double)(cnt + cnt2)) / ((100.0 - (double)this.limit) / 100.0));
            }
            this.log.debug((Object)("lim=" + lim));
            int rCnt = sum / den.getNominal();
            this.log.debug((Object)("rcnt=" + rCnt));
            if (lim != null) {
                rCnt = Math.min(rCnt, lim);
                this.log.debug((Object)("rcnt lim=" + rCnt));
            }
            if ((rCnt = Math.min(rCnt, cnt)) <= 0) continue;
            result.put(den, rCnt);
            if ((sum -= den.getNominal() * rCnt) == 0) break;
        }
        return result;
    }
}

