/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.hopper.algorithm;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import ru.softlogic.hardware.device.hopper.algorithm.Denomination;
import ru.softlogic.hardware.device.hopper.algorithm.DenominationComparator;
import ru.softlogic.hardware.device.hopper.algorithm.PayoutCalculator;

public class GreedyAlgorithmCalculator
implements PayoutCalculator {
    private int limit;

    public GreedyAlgorithmCalculator(int limit) {
        if (limit < 0 || limit > 50) {
            throw new IllegalArgumentException("Limit must be in range 0..50");
        }
        this.limit = limit;
    }

    @Override
    public Map<Denomination, Integer> calculate(Map<Denomination, Integer> presence, int sum) {
        if (presence == null || presence.isEmpty()) {
            return new HashMap<Denomination, Integer>();
        }
        if (sum <= 0) {
            return new HashMap<Denomination, Integer>();
        }
        int totalCount = 0;
        for (Integer cnt : presence.values()) {
            if (cnt == null) continue;
            totalCount += cnt.intValue();
        }
        if (totalCount <= 0) {
            return new HashMap<Denomination, Integer>();
        }
        LinkedList<Denomination> lst = new LinkedList<Denomination>();
        lst.addAll(presence.keySet());
        Collections.sort(lst, new DenominationComparator());
        HashMap<Denomination, Integer> result = new HashMap<Denomination, Integer>();
        for (Denomination den : lst) {
            Integer cnt = presence.get(den);
            if (cnt == null || cnt <= 0 || !((double)cnt.intValue() * 1.0 / (double)totalCount > (double)this.limit * 1.0 / 100.0)) continue;
            int rCnt = sum / den.getNominal();
            if ((rCnt = Math.min(rCnt, cnt)) <= 0) continue;
            result.put(den, rCnt);
            if ((sum -= den.getNominal() * rCnt) != 0) continue;
            break;
        }
        return result;
    }
}

