/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.hopper.algorithm;

import java.util.HashMap;
import java.util.Map;
import ru.softlogic.hardware.device.hopper.algorithm.Denomination;
import ru.softlogic.hardware.device.hopper.algorithm.PayoutCalculator;

public class DynamicBag
implements PayoutCalculator {
    private int[][] matrix;
    private int[] weight;
    private int[] ans;
    private int[] cost;
    private int[] count;
    private int rows;
    private int cols;
    int minNom;

    @Override
    public Map<Denomination, Integer> calculate(Map<Denomination, Integer> presence, int sum) {
        if (!this.init(presence, sum)) {
            return presence;
        }
        this.fillAns();
        this.findAnsRec(this.rows - 1, this.cols - 1);
        return this.getResult(presence);
    }

    private void fillAns() {
        for (int i = 1; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.matrix[i][j] = this.matrix[i - 1][j];
                for (int k = this.min(this.count[i], j / this.weight[i]); k > 0; --k) {
                    this.matrix[i][j] = this.max(this.matrix[i][j], this.matrix[i - 1][j - k * this.weight[i]] + this.cost[i] * k);
                }
            }
        }
    }

    private void findAnsRec(int k, int s) {
        if (this.matrix[k][s] == 0) {
            return;
        }
        if (this.matrix[k - 1][s] == this.matrix[k][s]) {
            this.findAnsRec(k - 1, s);
        } else {
            int i;
            for (i = 0; (this.matrix[k][s] - this.matrix[k - 1][s - i * this.weight[k]]) / this.cost[k] != i; ++i) {
            }
            this.findAnsRec(k - 1, s - i * this.weight[k]);
            this.ans[k] = i;
        }
    }

    private int min(int a, int b) {
        return a < b ? a : b;
    }

    private int max(int a, int b) {
        return a > b ? a : b;
    }

    private boolean init(Map<Denomination, Integer> presence, int sum) {
        this.rows = presence.size() + 1;
        this.minNom = Integer.MAX_VALUE;
        int limit = 0;
        for (Map.Entry<Denomination, Integer> entry : presence.entrySet()) {
            if (this.minNom > entry.getKey().getNominal()) {
                this.minNom = entry.getKey().getNominal();
            }
            limit += entry.getKey().getNominal() * entry.getValue();
        }
        if (limit <= sum) {
            return false;
        }
        this.cols = sum / this.minNom + 1;
        this.matrix = new int[this.rows][this.cols];
        this.ans = new int[this.rows];
        this.cost = new int[this.rows];
        this.count = new int[this.rows];
        this.weight = new int[this.rows];
        int temp = 1;
        for (Map.Entry<Denomination, Integer> entry : presence.entrySet()) {
            this.count[temp] = entry.getValue();
            this.weight[temp] = entry.getKey().getNominal() / this.minNom;
            this.cost[temp] = this.count[temp] * this.weight[temp];
            ++temp;
        }
        return true;
    }

    private Map<Denomination, Integer> getResult(Map<Denomination, Integer> presence) {
        HashMap<Denomination, Integer> out = new HashMap<Denomination, Integer>();
        for (Map.Entry<Denomination, Integer> entry : presence.entrySet()) {
            for (int i = 1; i < this.rows; ++i) {
                if (this.weight[i] * this.minNom != entry.getKey().getNominal() || this.ans[i] == 0) continue;
                out.put(entry.getKey(), this.ans[i]);
            }
        }
        return out;
    }
}

