/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cdm.f56.response.commandspecified;

import ru.softlogic.hardware.device.cdm.f56.response.commandspecified.CommandResponse;
import ru.softlogic.hardware.device.cdm.f56.response.data.SettingsInfo;
import ru.softlogic.io.utils.BU;

public class DeviceInfoResponse
implements CommandResponse {
    private int operationType;
    private final byte[] userSettings = new byte[40];
    private String modelName;
    private String identificationCode;
    private int maxBillCount;
    private SettingsInfo.Option frontOption;
    private SettingsInfo.Option rearOption;
    private SettingsInfo.MachineSetting machineSetting;
    private boolean jamRetryControlAvailable;
    private boolean bcsSensorAvailable;
    private String thickAdjustment;
    private String romVersion;

    @Override
    public void init(byte[] responseData, int pos) {
        this.operationType = BU.c((byte)responseData[pos]);
        System.arraycopy(responseData, pos + 1, this.userSettings, 0, this.userSettings.length);
        this.modelName = new String(responseData, pos + 41, 8);
        this.identificationCode = new String(responseData, pos + 49, 4);
        this.maxBillCount = Integer.parseInt(new String(responseData, pos + 53, 3));
        this.machineSetting = SettingsInfo.MachineSetting.toMachineSetting(responseData[pos + 56]);
        this.frontOption = SettingsInfo.Option.toOption(responseData[pos + 57]);
        this.rearOption = SettingsInfo.Option.toOption(responseData[pos + 58]);
        this.jamRetryControlAvailable = responseData[pos + 59] == 49;
        this.bcsSensorAvailable = responseData[pos + 60] == 49;
        this.thickAdjustment = new String(responseData, pos + 61, 2);
        this.romVersion = new String(responseData, pos + 63, 3);
    }

    public int getOperationType() {
        return this.operationType;
    }

    public byte[] getUserSettings() {
        return this.userSettings;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getIdentificationCode() {
        return this.identificationCode;
    }

    public int getMaxBillCount() {
        return this.maxBillCount;
    }

    public SettingsInfo.Option getFrontOption() {
        return this.frontOption;
    }

    public SettingsInfo.Option getRearOption() {
        return this.rearOption;
    }

    public SettingsInfo.MachineSetting getMachineSetting() {
        return this.machineSetting;
    }

    public boolean isJamRetryControlAvailable() {
        return this.jamRetryControlAvailable;
    }

    public boolean isBcsSensorAvailable() {
        return this.bcsSensorAvailable;
    }

    public String getThickAdjustment() {
        return this.thickAdjustment;
    }

    public String getRomVersion() {
        return this.romVersion;
    }
}

