/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.cdm.f56.response.commandspecified;

import java.util.Arrays;
import ru.softlogic.hardware.device.cdm.f56.NumberUtil;
import ru.softlogic.hardware.device.cdm.f56.response.commandspecified.CommandResponse;
import ru.softlogic.hardware.device.cdm.f56.response.data.CasseteStatistic;
import ru.softlogic.hardware.device.cdm.f56.response.data.SensorLevelInfo;
import ru.softlogic.io.utils.BU;

public class CountResponse
implements CommandResponse {
    private final int[] factCounts = new int[4];
    private final int[] factRejections = new int[4];
    private final CasseteStatistic[] statistic = new CasseteStatistic[4];
    private int paramOrder;
    private final int[] paramCounts = new int[4];
    private final int[] paramRejections = new int[4];
    private final int[] paramPickRetries = new int[4];
    private SensorLevelInfo sensorLevels;

    @Override
    public void init(byte[] responseData, int pos) {
        for (int i = 0; i < 4; ++i) {
            this.factCounts[i] = NumberUtil.toInt(responseData[pos + i * 2], responseData[pos + i * 2 + 1]);
            this.factRejections[i] = NumberUtil.toInt(responseData[pos + i * 2 + 8], responseData[pos + i * 2 + 9]);
            this.statistic[i] = new CasseteStatistic(responseData, pos + 16 + i * 16);
            this.paramCounts[i] = NumberUtil.toInt(responseData[pos + i * 2 + 81], responseData[pos + i * 2 + 82]);
            this.paramRejections[i] = NumberUtil.toInt(responseData[pos + i * 2 + 89], responseData[pos + i * 2 + 90]);
            this.paramPickRetries[i] = BU.c((byte)responseData[pos + i + 97]);
        }
        this.paramOrder = BU.c((byte)responseData[pos + 80]);
        this.sensorLevels = new SensorLevelInfo(responseData, pos + 101);
    }

    public int getFactCounts(int box) {
        return this.factCounts[box];
    }

    public int getFactRejections(int box) {
        return this.factRejections[box];
    }

    public CasseteStatistic getStatistic(int box) {
        return this.statistic[box];
    }

    public int getParamOrder() {
        return this.paramOrder;
    }

    public int getParamCounts(int box) {
        return this.paramCounts[box];
    }

    public int getParamRejections(int box) {
        return this.paramRejections[box];
    }

    public int getParamPickRetries(int box) {
        return this.paramPickRetries[box];
    }

    public SensorLevelInfo getSensorRegValue() {
        return this.sensorLevels;
    }

    public String toString() {
        return "CountResponse{factCounts=" + Arrays.toString(this.factCounts) + ", factRejections=" + Arrays.toString(this.factRejections) + ", statistic=" + Arrays.toString(this.statistic) + ", paramOrder=" + this.paramOrder + ", paramCounts=" + Arrays.toString(this.paramCounts) + ", paramRejections=" + Arrays.toString(this.paramRejections) + ", paramPickRetries=" + Arrays.toString(this.paramPickRetries) + ", sensorRegValue=" + this.sensorLevels + '}';
    }
}

